/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ultima.render;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import java.awt.Color;
import java.awt.Graphics2D;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.ByteSubarray;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ultima.render.ColorMap;

public class FlowIndelRendering {
    public static final String TAG_T0 = "t0";
    private static ColorMap indelColorMap = ColorMap.getJet(42);
    private static final double MIN_PROB_DEFAULT = 0.01;
    private static String ATTR_TP = "tp";
    private static String ATTR_TI = "ti";
    private static String RG_ATTR_PL = "PL";
    private static String RG_ATTR_MC = "mc";
    private static String RG_ATTR_PL_ULTIMA = "ULTIMA";

    public boolean handlesAlignment(Alignment alignment) {
        if (!(alignment instanceof SAMAlignment)) {
            return false;
        }
        SAMAlignment samAlignment = (SAMAlignment)alignment;
        return FlowIndelRendering.getUltimaFileVersion(alignment) != UltimaFileFormat.NON_FLOW;
    }

    public void renderSmallInsertion(Alignment alignment, AlignmentBlock aBlock, RenderContext context, int h, int x, int y, AlignmentTrack.RenderOptions renderOptions) {
        int pxWing = h > 10 ? 2 : (h > 5 ? 1 : 0);
        int hairline = 2;
        if (renderOptions.isInsertQualColoring()) {
            pxWing = Math.min(pxWing, Math.max(1, (int)(1.0 / context.getScale())));
            hairline = Math.min(hairline, pxWing);
        }
        Graphics2D g = context.getGraphics();
        g.fillRect(x, y, hairline, h);
        g.fillRect(x - pxWing, y, hairline + 2 * pxWing, hairline);
        g.fillRect(x - pxWing, y + h - hairline, hairline + 2 * pxWing, hairline);
        UltimaFileFormat uff = FlowIndelRendering.getUltimaFileVersion(alignment);
        if (renderOptions.isInsertQualColoring() && uff != UltimaFileFormat.NON_FLOW) {
            double p;
            double d = p = uff == UltimaFileFormat.BASE_TP ? this.qualsAsProbInsertTP((SAMAlignment)alignment, aBlock) : FlowIndelRendering.qualsAsProb(aBlock.getQualities());
            if (p != 0.0) {
                double q = -10.0 * Math.log10(p);
                Color qColor = new Color(indelColorMap.getColor((int)q));
                g.setColor(qColor);
                g.fillRect(x - pxWing, (int)((double)y + (double)(h - hairline) * (q / 42.0)) - 1, hairline + 2 * pxWing, hairline * 2);
            }
        }
    }

    public void renderSmallInsertionWings(Alignment alignment, AlignmentBlock insertionBlock, RenderContext context, int pxH, int pxTop, int pxRight, int pxLeft, AlignmentTrack.RenderOptions renderOptions) {
        int pxWing = pxH > 10 ? 2 : 1;
        Graphics2D g = context.getGraphics();
        int hairline = 2;
        double locScale = context.getScale();
        if (renderOptions.isInsertQualColoring()) {
            pxWing = Math.min(pxWing, Math.max(1, (int)(1.0 / locScale)));
            hairline = Math.min(hairline, pxWing);
        }
        g.fillRect(pxLeft - pxWing, pxTop, pxRight - pxLeft + hairline * pxWing, hairline);
        g.fillRect(pxLeft - pxWing, pxTop + pxH - hairline, pxRight - pxLeft + hairline * pxWing, hairline);
        UltimaFileFormat uff = FlowIndelRendering.getUltimaFileVersion(alignment);
        if (renderOptions.isInsertQualColoring() & uff != UltimaFileFormat.NON_FLOW) {
            double p;
            double d = p = uff == UltimaFileFormat.BASE_TP ? this.qualsAsProbInsertTP((SAMAlignment)alignment, insertionBlock) : FlowIndelRendering.qualsAsProb(insertionBlock.getQualities());
            if (p != 0.0) {
                double q = -10.0 * Math.log10(p);
                Color qColor = new Color(indelColorMap.getColor((int)q));
                g.setColor(qColor);
                g.fillRect(pxLeft - pxWing, (int)((double)pxTop + (double)(pxH - hairline) * (q / 42.0)), pxRight - pxLeft + hairline * pxWing, hairline);
            }
        }
    }

    public void renderDeletionGap(Alignment alignment, Gap gap, int y, int h, int x, int w, RenderContext context, AlignmentTrack.RenderOptions renderOptions) {
        Color[] markerColor = new Color[2];
        double[] markerQ = new double[2];
        UltimaFileFormat uff = FlowIndelRendering.getUltimaFileVersion(alignment);
        if (renderOptions.isInsertQualColoring() && uff != UltimaFileFormat.NON_FLOW) {
            int blockIndex;
            boolean blockFound = false;
            AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
            for (blockIndex = 0; blockIndex < blocks.length; ++blockIndex) {
                if (blocks[blockIndex].getEnd() == gap.getStart()) {
                    blockFound = true;
                    break;
                }
                if (blocks[blockIndex].getEnd() > gap.getStart()) break;
            }
            if (blockFound && blockIndex < blocks.length - 1) {
                AlignmentBlock abPrev = alignment.getAlignmentBlocks()[blockIndex];
                AlignmentBlock abNext = alignment.getAlignmentBlocks()[blockIndex + 1];
                if (abPrev.getQualities().length > 0 && abNext.getQualities().length > 0) {
                    double p;
                    int delLength;
                    Genome genome = GenomeManager.getInstance().getCurrentGenome();
                    char gapBase0 = Character.toUpperCase((char)genome.getReference(alignment.getChr(), gap.getStart()));
                    char gapBase1 = Character.toUpperCase((char)genome.getReference(alignment.getChr(), gap.getStart() + gap.getnBases() - 1));
                    char alignBase0 = Character.toUpperCase((char)abPrev.getBases().getByte(abPrev.getBases().length - 1));
                    char alignBase1 = Character.toUpperCase((char)abNext.getBases().getByte(0));
                    char gapBase0p = Character.toUpperCase((char)genome.getReference(alignment.getChr(), gap.getStart() - 1));
                    char gapBase1n = Character.toUpperCase((char)genome.getReference(alignment.getChr(), gap.getStart() + gap.getnBases()));
                    boolean snp0 = gapBase0p != alignBase0;
                    boolean snp1 = gapBase1n != alignBase1;
                    byte[] quals01 = new byte[1];
                    if (!snp0) {
                        quals01[0] = abPrev.getQualities().getByte(abPrev.getQualities().length - 1);
                        if (uff == UltimaFileFormat.BASE_TP) {
                            delLength = 1;
                            while (delLength + 1 < gap.getnBases() && gapBase0 == Character.toUpperCase(genome.getReference(alignment.getChr(), gap.getStart() + delLength))) {
                                ++delLength;
                            }
                            p = this.qualsAsProbDeleteTP((SAMAlignment)alignment, abPrev, delLength, false, gap);
                        } else {
                            p = FlowIndelRendering.qualsAsProb(new ByteSubarray(quals01, 0, quals01.length, 0));
                        }
                        if (p != 0.0) {
                            markerQ[0] = -10.0 * Math.log10(p);
                            markerColor[0] = new Color(indelColorMap.getColor((int)markerQ[0]));
                        }
                    }
                    if (!snp1) {
                        quals01[0] = abNext.getQualities().getByte(0);
                        if (uff == UltimaFileFormat.BASE_TP) {
                            delLength = 1;
                            while (delLength + 1 < gap.getnBases() && gapBase1 == Character.toUpperCase(genome.getReference(alignment.getChr(), gap.getStart() + gap.getnBases() - delLength))) {
                                ++delLength;
                            }
                            p = this.qualsAsProbDeleteTP((SAMAlignment)alignment, abNext, delLength, true, gap);
                        } else {
                            p = FlowIndelRendering.qualsAsProb(new ByteSubarray(quals01, 0, quals01.length, 0));
                        }
                        if (p != 0.0) {
                            markerQ[1] = -10.0 * Math.log10(p);
                            markerColor[1] = new Color(indelColorMap.getColor((int)markerQ[1]));
                        }
                    }
                }
            }
            Graphics2D g = context.getGraphics();
            if (markerColor[0] != null || markerColor[1] != null) {
                int hairline = Math.min(2, (int)(1.0 / context.getScale()));
                Color c = g.getColor();
                if (markerQ[0] == markerQ[1] || gap.getnBases() == 1) {
                    double q1 = markerQ[0];
                    Color c1 = markerColor[0];
                    if (c1 == null) {
                        q1 = markerQ[1];
                        c1 = markerColor[1];
                    } else if (markerColor[1] != null && markerQ[1] != q1) {
                        q1 = (q1 + markerQ[1]) / 2.0;
                        c1 = new Color(indelColorMap.getColor((int)q1));
                    }
                    g.setColor(c1);
                    g.fillRect(x + (int)((double)w * q1 / 42.0) - hairline, y, hairline * 2, h);
                } else {
                    if (markerColor[0] != null) {
                        g.setColor(markerColor[0]);
                        g.fillRect(x + (int)((double)w * markerQ[0] / 42.0) - hairline, y, hairline * 2, h * 3 / 4);
                    }
                    if (markerColor[1] != null) {
                        g.setColor(markerColor[1]);
                        g.fillRect(x + (int)((double)w * markerQ[1] / 42.0) - hairline, y + h / 4, hairline * 2, h * 3 / 4);
                    }
                }
                g.setColor(c);
            }
        }
    }

    private static UltimaFileFormat getUltimaFileVersion(Alignment alignment) {
        if (!(alignment instanceof SAMAlignment)) {
            return UltimaFileFormat.NON_FLOW;
        }
        SAMAlignment samAlignment = (SAMAlignment)alignment;
        if (!FlowIndelRendering.isUltimaFlowReadGroup(samAlignment.getRecord().getReadGroup())) {
            return UltimaFileFormat.NON_FLOW;
        }
        if (alignment.getAttribute(ATTR_TI) != null) {
            return UltimaFileFormat.BASE_TI;
        }
        if (alignment.getAttribute(ATTR_TP) != null) {
            return UltimaFileFormat.BASE_TP;
        }
        return UltimaFileFormat.NON_FLOW;
    }

    private static boolean isUltimaFlowReadGroup(SAMReadGroupRecord readGroup) {
        if (readGroup == null) {
            return false;
        }
        if (RG_ATTR_PL_ULTIMA.equals(readGroup.getAttribute(RG_ATTR_PL))) {
            return true;
        }
        return readGroup.getAttribute(RG_ATTR_MC) != null;
    }

    private static double qualsAsProb(ByteSubarray quals) {
        double probSum = 0.0;
        double probCount = 0.0;
        for (int i = 0; i < quals.length; ++i) {
            byte q = quals.getByte(i);
            if (q == 255) continue;
            probSum += Math.pow(10.0, (double)(-q) / 10.0);
            probCount += 1.0;
        }
        if (probCount != 0.0) {
            return probSum / probCount;
        }
        return -1.0;
    }

    public double qualsAsProbInsertTP(SAMAlignment samAlignment, AlignmentBlock block) {
        return this.qualsAsProbInsertTP(samAlignment, block, 0, block.getLength());
    }

    public double qualsAsProbInsertTP(SAMAlignment samAlignment, AlignmentBlock block, int fragOfs, int fragLength) {
        byte[] tp;
        if (!this.blockIsHmer(block, fragOfs, fragLength)) {
            byte[] bases = block.getBases().getBytes();
            int f1ofs = 0;
            int f1Length = 0;
            byte base = bases[f1ofs];
            for (int n = 0; n < bases.length && bases[n] == base; ++n) {
                ++f1Length;
            }
            int f2ofs = bases.length;
            int f2Length = 0;
            base = bases[f2ofs - 1];
            for (int n = bases.length - 1; n >= 0 && bases[n] == base; --n) {
                ++f2Length;
                --f2ofs;
            }
            double p1 = this.qualsAsProbInsertTP(samAlignment, block, f1ofs, f1Length);
            double p2 = this.qualsAsProbInsertTP(samAlignment, block, f2ofs, f2Length);
            if (p1 == 0.0) {
                return p2;
            }
            if (p2 == 0.0) {
                return p1;
            }
            return (p1 + p2) / 2.0;
        }
        SAMRecord record = samAlignment.getRecord();
        if (record == null) {
            return 0.0;
        }
        byte base = block.getBase(fragOfs);
        int start = block.getIndexOnRead() + fragOfs;
        if (fragLength == 1 && (tp = record.getByteArrayAttribute(ATTR_TP))[start] == -1) {
            byte q = block.getQuality(0);
            return Math.pow(10.0, (double)(-q) / 10.0);
        }
        HMer hmer = this.findHmer(record, start, fragLength, base);
        return this.findQualByTPValue(record, hmer, -fragLength);
    }

    private HMer findHmer(SAMRecord record, int start, int length, byte base) {
        HMer hmer = new HMer();
        hmer.start = start;
        byte[] bases = record.getReadBases();
        hmer.end = hmer.start + (length - 1);
        while (hmer.start > 0 && bases[hmer.start - 1] == base) {
            --hmer.start;
        }
        while (hmer.end + 1 < bases.length && bases[hmer.end + 1] == base) {
            ++hmer.end;
        }
        return hmer;
    }

    private double findQualByTPValue(SAMRecord record, HMer hmer, int tpValue) {
        int mc;
        int hmerSize;
        byte[] tp = record.getByteArrayAttribute(ATTR_TP);
        for (int ofs = hmer.start; ofs <= hmer.end; ++ofs) {
            if (tp[ofs] != tpValue) continue;
            byte[] quals = record.getBaseQualities();
            return Math.pow(10.0, (double)(-quals[ofs]) / 10.0);
        }
        if (tpValue > 0 && tpValue + (hmerSize = hmer.end - hmer.start + 1) > (mc = this.getMC(record))) {
            return 0.99;
        }
        return 0.0;
    }

    private int getMC(SAMRecord record) {
        try {
            return Integer.parseInt(record.getReadGroup().getAttribute("mc"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private boolean blockIsHmer(AlignmentBlock block, int fragOfs, int fragLength) {
        byte[] bases = block.getBases().getBytes();
        if (bases == null || bases.length < fragOfs + fragLength) {
            return false;
        }
        if (fragLength == 1) {
            return true;
        }
        byte base = bases[fragOfs];
        for (int n = fragOfs + 1; n < fragOfs + fragLength; ++n) {
            if (bases[n] == base) continue;
            return false;
        }
        return true;
    }

    public double qualsAsProbDeleteTP(SAMAlignment samAlignment, AlignmentBlock block, int delLength, boolean delIsBeforeBlock, Gap gap) {
        SAMRecord record = samAlignment.getRecord();
        if (record == null) {
            return 0.0;
        }
        byte base = block.getBase(delIsBeforeBlock ? 0 : block.getLength() - 1);
        int start = block.getIndexOnRead();
        if (!delIsBeforeBlock) {
            start += block.getLength() - 1;
        }
        HMer hmer = this.findHmer(record, start, 0, base);
        double t0qual = this.qualsAsProbDeleteTPByT0(samAlignment, record, block, delLength, delIsBeforeBlock, gap);
        if (t0qual != 0.0) {
            return t0qual;
        }
        return this.findQualByTPValue(record, hmer, delLength);
    }

    private double qualsAsProbDeleteTPByT0(SAMAlignment samAlignment, SAMRecord record, AlignmentBlock block, int delLength, boolean delIsBeforeBlock, Gap gap) {
        if (delLength != 1) {
            return 0.0;
        }
        int loc = block.getIndexOnRead() + (delIsBeforeBlock ? -1 : block.getLength() - 1);
        if (loc < 0) {
            return 0.0;
        }
        byte[] bases = record.getReadBases();
        if (loc >= bases.length - 1) {
            return 0.0;
        }
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        byte delBase = (byte)Character.toUpperCase(genome.getReference(samAlignment.getChr(), gap.getStart()));
        if (delBase == bases[loc] || delBase == bases[loc + 1]) {
            return 0.0;
        }
        if (!record.hasAttribute(TAG_T0)) {
            return 0.0;
        }
        byte[] t0 = record.getStringAttribute(TAG_T0).getBytes();
        double p0 = Math.pow(10.0, (double)(t0[loc] - 33) / -10.0);
        double p1 = Math.pow(10.0, (double)(t0[loc + 1] - 33) / -10.0);
        return Math.max(p0, p1);
    }

    private static enum UltimaFileFormat {
        NON_FLOW,
        BASE_TI,
        BASE_TP;

    }

    private class HMer {
        int start;
        int end;

        private HMer() {
        }
    }
}

