/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.supdiagram;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.SupplementaryAlignment;
import org.broad.igv.sam.SupplementaryGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.supdiagram.AlignmentArrow;
import org.broad.igv.ui.supdiagram.SupplementaryAlignmentDiagramDialog;
import org.broad.igv.ui.util.IGVMouseInputAdapter;
import org.broad.igv.util.ChromosomeColors;

class SupplementalAlignmentDiagram
extends JPanel {
    public static final int LABEL_GAP = 2;
    private static final Logger log = LogManager.getLogger(SupplementalAlignmentDiagram.class);
    public static final int BORDER_GAP = 30;
    public static final int BETWEEN_ALIGNMENT_GAP = 15;
    public static final int BETWEEN_CONTIG_GAP = 10;
    public static final int ALIGNMENT_HEIGHT = 10;
    public static final Color SELECTED_COLOR = Color.BLUE;
    public static final Color PRIMARY_BORDER_COLOR = Color.DARK_GRAY;
    public static final int DEFAULT_WIDTH = 500;
    private Rectangle2D chrDiagramBounds = null;
    private Rectangle2D readDiagramBounds = null;
    private final Map<AlignmentArrow, SupplementaryAlignment> elementsOnScreen = new LinkedHashMap<AlignmentArrow, SupplementaryAlignment>();
    private final Set<SupplementaryAlignment> selected = new LinkedHashSet<SupplementaryAlignment>();
    private final SupplementaryGroup toDraw;

    public SupplementalAlignmentDiagram(final SupplementaryGroup toDraw) {
        this.toDraw = toDraw;
        this.setBackground(Color.WHITE);
        this.addMouseMotionListener(new IGVMouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                SupplementalAlignmentDiagram.this.selected.clear();
                for (AlignmentArrow arrow : SupplementalAlignmentDiagram.this.elementsOnScreen.keySet()) {
                    if (!arrow.contains(e.getPoint())) continue;
                    SupplementalAlignmentDiagram.this.selected.add(SupplementalAlignmentDiagram.this.elementsOnScreen.get(arrow));
                    SupplementalAlignmentDiagram.this.repaint();
                    return;
                }
                SupplementalAlignmentDiagram.this.repaint();
            }
        });
        this.addMouseListener(new IGVMouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    IGV igv = null;
                    try {
                        igv = IGV.getInstance();
                    }
                    catch (RuntimeException ex) {
                        log.info("Clicked " + SupplementalAlignmentDiagram.this.selected.stream().map(Object::toString).collect(Collectors.joining("\n")));
                    }
                    if (igv != null && !SupplementalAlignmentDiagram.this.selected.isEmpty()) {
                        SupplementaryAlignment first = (SupplementaryAlignment)SupplementalAlignmentDiagram.this.selected.stream().findFirst().get();
                        Set<String> selectedReadNameSet = Set.of(toDraw.getReadName());
                        if (e.isShiftDown()) {
                            FrameManager.addNewLociToFrames(FrameManager.getDefaultFrame(), List.of(first), selectedReadNameSet);
                        } else {
                            igv.setDefaultFrame(first.getContig() + ":" + first.getStart() + "-" + first.getEnd());
                            AlignmentTrack.sortSelectedReadsToTheTop(selectedReadNameSet);
                        }
                        igv.getAlignmentTracks().forEach(t -> t.setSelectedAlignment(toDraw.unwrap()));
                    }
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(Color.WHITE);
        ((Graphics2D)g).setComposite(SupplementalAlignmentDiagram.getAlphaComposite());
        g.setColor(Color.LIGHT_GRAY);
        this.elementsOnScreen.clear();
        int halfHeight = this.getHeight() / 2;
        int width = this.getWidth();
        this.chrDiagramBounds = new Rectangle2D.Float(0.0f, 10.0f, width, halfHeight - 10);
        this.drawContigOrder(g, this.chrDiagramBounds);
        this.readDiagramBounds = new Rectangle2D.Float(0.0f, halfHeight, width, halfHeight);
        this.drawReadOrder(g, this.readDiagramBounds);
        if (!this.selected.isEmpty()) {
            SupplementaryAlignment first = this.selected.iterator().next();
            g.setColor(Color.BLACK);
            g.drawString(String.format("%s:%d-%d", first.getContig(), first.getStart(), first.getEnd()), 30, this.getHeight() - g.getFontMetrics().getHeight() + 2);
        }
    }

    private void drawReadOrder(Graphics g, Rectangle2D bounds) {
        g.setColor(Color.DARK_GRAY);
        ((Graphics2D)g).draw(bounds);
        g.drawString("Read Order", (int)bounds.getX() + 5, (int)bounds.getY() + 15);
        Map<SupplementaryAlignment, AlignmentArrow> saInReadOrder = SupplementalAlignmentDiagram.drawAlignmentsInReadOrder((Graphics2D)g.create(), this.toDraw, this.selected, bounds);
        SupplementalAlignmentDiagram.drawArcs((Graphics2D)g.create(), this.toDraw, this.selected, saInReadOrder, bounds);
        int lowestArrowPoint = saInReadOrder.values().stream().mapToInt(a -> (int)a.getBounds2D().getMaxY()).max().getAsInt();
        this.drawReadLengthLabel((Graphics2D)g.create(), lowestArrowPoint + 15, saInReadOrder);
        saInReadOrder.forEach((k, v) -> this.elementsOnScreen.put((AlignmentArrow)v, (SupplementaryAlignment)k));
        g.setColor(Color.DARK_GRAY);
        ((Graphics2D)g).draw(bounds);
    }

    private void drawContigOrder(Graphics g, Rectangle2D bounds) {
        g.setColor(Color.DARK_GRAY);
        ((Graphics2D)g).draw(bounds);
        g.drawString("Alignment Order", (int)bounds.getX() + 5, (int)bounds.getY() + 15);
        Map<SupplementaryAlignment, AlignmentArrow> saInPositionOrder = SupplementalAlignmentDiagram.drawAlignmentsInCondensedChromosomeOrder((Graphics2D)g.create(), this.toDraw, this.selected, bounds);
        SupplementalAlignmentDiagram.drawArcs((Graphics2D)g.create(), this.toDraw, this.selected, saInPositionOrder, bounds);
        int lowestArrowPoint = saInPositionOrder.values().stream().mapToInt(a -> (int)a.getBounds2D().getMaxY()).max().getAsInt();
        SupplementalAlignmentDiagram.drawContigLabels((Graphics2D)g.create(), lowestArrowPoint + 15, saInPositionOrder);
        saInPositionOrder.forEach((k, v) -> this.elementsOnScreen.put((AlignmentArrow)v, (SupplementaryAlignment)k));
        g.setColor(Color.DARK_GRAY);
        ((Graphics2D)g).draw(bounds);
    }

    private void drawReadLengthLabel(Graphics2D g, int mid, Map<SupplementaryAlignment, AlignmentArrow> saInReadOrder) {
        ArrayList<AlignmentArrow> arrowsInOrder = new ArrayList<AlignmentArrow>(saInReadOrder.values());
        int left = (int)((AlignmentArrow)arrowsInOrder.get(0)).getBounds().getMinX();
        int right = (int)((AlignmentArrow)arrowsInOrder.get(arrowsInOrder.size() - 1)).getBounds().getMaxX();
        int baseCount = this.toDraw.getBaseCount();
        g.setColor(Color.BLACK);
        SupplementalAlignmentDiagram.drawCenteredStringWithRangeLines(g, mid, "Length in bases = " + baseCount, left, right);
    }

    private static void drawArcs(Graphics2D g, SupplementaryGroup toDraw, Set<SupplementaryAlignment> selected, Map<SupplementaryAlignment, AlignmentArrow> saToArrowMap, Rectangle2D bounds) {
        toDraw.iterateInReadOrder().forEachRemaining(sa -> {
            SupplementaryAlignment next = toDraw.getNextInRead((SupplementaryAlignment)sa);
            if (next != null) {
                boolean highlight = selected.contains(sa) || selected.contains(next);
                SupplementalAlignmentDiagram.drawArc(g, (AlignmentArrow)saToArrowMap.get(sa), (AlignmentArrow)saToArrowMap.get(next), highlight, bounds);
            }
        });
    }

    private static Composite getAlphaComposite() {
        float alpha = 0.75f;
        int type = 3;
        return AlphaComposite.getInstance(3, 0.75f);
    }

    private static Map<SupplementaryAlignment, AlignmentArrow> drawAlignmentsInReadOrder(Graphics2D g, SupplementaryGroup toDraw, Set<SupplementaryAlignment> selected, Rectangle2D bounds) {
        int midline = (int)(bounds.getY() + 0.5 * bounds.getHeight());
        LinkedHashMap<SupplementaryAlignment, AlignmentArrow> positions = new LinkedHashMap<SupplementaryAlignment, AlignmentArrow>();
        int totalAlignedBases = toDraw.getBaseCount();
        int scaledAlignmentGap = SupplementalAlignmentDiagram.scale(2, 15, bounds.getWidth());
        int scaledBorderGap = SupplementalAlignmentDiagram.scale(10, 30, bounds.getWidth());
        double availableSpace = bounds.getWidth() - (double)(2 * scaledBorderGap + (toDraw.size() - 1) * scaledAlignmentGap);
        double lastPosition = scaledBorderGap;
        for (SupplementaryAlignment sa : toDraw::iterateInReadOrder) {
            double spaceToUse = SupplementalAlignmentDiagram.getSpaceToUse(availableSpace, sa.getNumberOfAlignedBases(), totalAlignedBases);
            int end = (int)(lastPosition + spaceToUse);
            AlignmentArrow readArrow = new AlignmentArrow(midline, 10, (int)(bounds.getX() + lastPosition), (int)(bounds.getX() + (double)end), sa.getStrand());
            lastPosition = end + scaledAlignmentGap;
            positions.put(sa, readArrow);
        }
        SupplementalAlignmentDiagram.drawArrows(g, selected, positions, toDraw.getPrimaryAlignment());
        return positions;
    }

    private static Graphics2D getSelectedGraphics(Graphics2D g) {
        Graphics2D selectedGraphics = (Graphics2D)g.create();
        selectedGraphics.setStroke(new BasicStroke(3.0f));
        selectedGraphics.setColor(SELECTED_COLOR);
        return selectedGraphics;
    }

    private static <T extends Locatable> Map<Locatable, List<T>> groupBySpanningInterval(List<T> intervals) {
        ArrayList<Locatable> currentGroup = null;
        LinkedHashMap<Locatable, List<T>> output = new LinkedHashMap<Locatable, List<T>>();
        Locatable spanning = null;
        if (intervals.isEmpty()) {
            return Collections.emptyMap();
        }
        for (Locatable loc : intervals) {
            if (currentGroup == null || currentGroup.isEmpty()) {
                currentGroup = new ArrayList<Locatable>();
                currentGroup.add(loc);
                spanning = loc;
                continue;
            }
            if (spanning.overlaps(loc)) {
                currentGroup.add(loc);
                spanning = new Interval(spanning.getContig(), Math.min(spanning.getStart(), loc.getStart()), Math.max(spanning.getEnd(), loc.getEnd()));
                continue;
            }
            output.put(spanning, currentGroup);
            currentGroup = new ArrayList();
            currentGroup.add(loc);
            spanning = loc;
        }
        output.put(spanning, currentGroup);
        return output;
    }

    private static Map<SupplementaryAlignment, AlignmentArrow> drawAlignmentsInCondensedChromosomeOrder(Graphics2D g, SupplementaryGroup toDraw, Set<SupplementaryAlignment> selected, Rectangle2D bounds) {
        double midline = bounds.getY() + 0.5 * bounds.getHeight();
        LinkedHashMap<SupplementaryAlignment, AlignmentArrow> positions = new LinkedHashMap<SupplementaryAlignment, AlignmentArrow>();
        List<String> contigs = toDraw.getContigs();
        int scaledAlignmentGap = SupplementalAlignmentDiagram.scale(2, 15, bounds.getWidth());
        int scaledContigGap = SupplementalAlignmentDiagram.scale(2, 10, bounds.getWidth());
        int scaledBorderGap = SupplementalAlignmentDiagram.scale(10, 30, bounds.getWidth());
        Map<Locatable, List<SupplementaryAlignment>> groupedBySpan = SupplementalAlignmentDiagram.groupBySpanningInterval(toDraw.streamInPositionOrder().toList());
        Map byContig = groupedBySpan.keySet().stream().collect(Collectors.groupingBy(Locatable::getContig, LinkedHashMap::new, Collectors.toList()));
        double perContigAvailableSpace = (bounds.getWidth() - (double)(2 * scaledBorderGap + (contigs.size() - 1) * scaledContigGap)) / (double)contigs.size();
        int contigStart = scaledBorderGap;
        for (Map.Entry contigEntry : byContig.entrySet()) {
            int contigEnd = (int)((double)contigStart + perContigAvailableSpace);
            List distinctSpans = (List)contigEntry.getValue();
            int totalSpansLength = distinctSpans.stream().mapToInt(Locatable::getLengthOnReference).sum();
            int spanStart = contigStart;
            for (Locatable span : distinctSpans) {
                int spanLength = span.getLengthOnReference();
                int spanSpaceAvailable = (int)SupplementalAlignmentDiagram.getSpaceToUse(perContigAvailableSpace - (double)((distinctSpans.size() - 1) * scaledAlignmentGap), spanLength, totalSpansLength);
                List<SupplementaryAlignment> activeSpanGroup = groupedBySpan.get(span);
                for (int i = 0; i < activeSpanGroup.size(); ++i) {
                    SupplementaryAlignment sa = activeSpanGroup.get(i);
                    int scaledReadStart = (int)SupplementalAlignmentDiagram.getSpaceToUse(spanSpaceAvailable, sa.getStart() - span.getStart(), spanLength);
                    int scaledReadEnd = (int)SupplementalAlignmentDiagram.getSpaceToUse(spanSpaceAvailable, sa.getEnd() - span.getStart(), spanLength);
                    int heightOffset = 10 - (int)(20.0 * (1.0 / ((double)activeSpanGroup.size() + 1.0)) * ((double)i + 1.0));
                    AlignmentArrow readArrow = new AlignmentArrow((int)midline + 2 * heightOffset, 10, (int)bounds.getX() + spanStart + scaledReadStart, (int)bounds.getX() + spanStart + scaledReadEnd, sa.getStrand());
                    positions.put(sa, readArrow);
                }
                spanStart += spanSpaceAvailable + scaledAlignmentGap;
            }
            contigStart = contigEnd + scaledContigGap;
        }
        SupplementalAlignmentDiagram.drawArrows(g, selected, positions, toDraw.getPrimaryAlignment());
        return positions;
    }

    private static Map<SupplementaryAlignment, AlignmentArrow> drawAlignmentsInPositionOrder(Graphics2D g, SupplementaryGroup toDraw, Set<SupplementaryAlignment> selected, int width, int midline) {
        LinkedHashMap<SupplementaryAlignment, AlignmentArrow> positions = new LinkedHashMap<SupplementaryAlignment, AlignmentArrow>();
        List<String> contigs = toDraw.getContigs();
        int totalAlignedBases = toDraw.getLengthOnReference();
        int scaledAlignmentGap = SupplementalAlignmentDiagram.scale(2, 15, width);
        int scaledContigGap = SupplementalAlignmentDiagram.scale(2, 10, width);
        int scaledBorderGap = SupplementalAlignmentDiagram.scale(10, 30, width);
        double availableSpace = width - (2 * scaledBorderGap + (toDraw.size() - 1) * scaledAlignmentGap + (contigs.size() - 1) * scaledContigGap);
        String lastContig = contigs.get(0);
        double lastPosition = scaledBorderGap;
        for (SupplementaryAlignment sa : toDraw::iterateInPositionOrder) {
            double spaceToUse = SupplementalAlignmentDiagram.getSpaceToUse(availableSpace, sa.getLengthOnReference(), totalAlignedBases);
            String newContig = sa.getContig();
            if (lastPosition != (double)scaledBorderGap && !Objects.equals(lastContig, newContig)) {
                lastPosition += (double)scaledContigGap;
            }
            lastContig = newContig;
            int end = (int)(lastPosition + spaceToUse);
            AlignmentArrow readArrow = new AlignmentArrow(midline, 10, (int)lastPosition, end, sa.getStrand());
            positions.put(sa, readArrow);
            lastPosition = end + scaledAlignmentGap;
        }
        SupplementalAlignmentDiagram.drawArrows(g, selected, positions, toDraw.getPrimaryAlignment());
        return positions;
    }

    private static int scale(int min, int max, double width) {
        if (width >= 500.0) {
            return max;
        }
        double scaleDown = width / 500.0;
        return Math.max((int)((double)max * scaleDown), min);
    }

    private static void drawArrows(Graphics2D g, Set<SupplementaryAlignment> selected, Map<SupplementaryAlignment, AlignmentArrow> positions, SupplementaryAlignment primary) {
        positions.forEach((sa, readArrow) -> {
            g.setColor(ChromosomeColors.getColor(sa.getContig()));
            g.fill((Shape)readArrow);
        });
        g.setColor(PRIMARY_BORDER_COLOR);
        AlignmentArrow primaryShape = positions.get(primary);
        g.draw(primaryShape);
        for (Map.Entry<SupplementaryAlignment, AlignmentArrow> pair : positions.entrySet()) {
            SupplementaryAlignment sa2 = pair.getKey();
            AlignmentArrow readArrow2 = pair.getValue();
            g.setColor(ChromosomeColors.getColor(sa2.getContig()));
            Graphics2D g2 = selected.contains(sa2) ? SupplementalAlignmentDiagram.getSelectedGraphics(g) : g;
            g2.draw(readArrow2);
        }
    }

    private static double getSpaceToUse(double availableSpace, int numberOfBasePairs, int totalAlignedBases) {
        double fractionOfWhole = (double)numberOfBasePairs / (double)totalAlignedBases;
        return fractionOfWhole * availableSpace;
    }

    private static void drawContigLabels(Graphics2D g, int mid, Map<SupplementaryAlignment, AlignmentArrow> positions) {
        positions.keySet().stream().collect(Collectors.groupingBy(SupplementaryAlignment::getContig)).forEach((contig, alignments) -> {
            int start = (int)((AlignmentArrow)positions.get(alignments.get(0))).getBounds().getX();
            Rectangle rightmostBounds = ((AlignmentArrow)positions.get(alignments.get(alignments.size() - 1))).getBounds();
            int end = (int)(rightmostBounds.getX() + rightmostBounds.getWidth());
            g.setColor(ChromosomeColors.getColor(contig));
            SupplementalAlignmentDiagram.drawCenteredStringWithRangeLines(g, mid, contig, start, end);
        });
    }

    private static void drawCenteredStringWithRangeLines(Graphics2D g, int mid, String string, int start, int end) {
        FontMetrics fontMetrics = g.getFontMetrics();
        int labelWidth = fontMetrics.stringWidth(string);
        int lineY = mid;
        int height = fontMetrics.getHeight();
        if (labelWidth + 4 < end - start) {
            int leftLineEnd = (start + end - labelWidth) / 2 - 2;
            int rightLineStart = (start + end + labelWidth) / 2 + 2;
            g.drawLine(start, lineY - 2, start, lineY + 2);
            g.drawLine(end, lineY - 2, end, lineY + 2);
            g.drawLine(start, lineY, leftLineEnd, lineY);
            g.drawString(string, leftLineEnd + 2, lineY + height / 3);
            g.drawLine(rightLineStart, lineY, end, lineY);
        } else {
            g.drawString(string, start, lineY + height / 3);
        }
    }

    private static void drawArc(Graphics2D g, AlignmentArrow currentPos, AlignmentArrow nextPos, boolean highlight, Rectangle2D bounds) {
        CubicCurve2D.Double c = new CubicCurve2D.Double();
        Point2D from = currentPos.getTip();
        Point2D to = nextPos.getTail();
        g.setStroke(new BasicStroke(2.0f, 0, 0));
        double distance = Math.abs(from.getX() - to.getX());
        double minHeight = bounds.getY();
        double heightAdjustment = 1.0;
        double maxHeight = bounds.getHeight() - 5.0;
        double actualHeight = maxHeight * heightAdjustment;
        double controlY = bounds.getY() + (bounds.getHeight() - actualHeight);
        Point2D.Double control1 = new Point2D.Double(from.getX() + (to.getX() - from.getX()) / 4.0, controlY);
        Point2D.Double control2 = new Point2D.Double(from.getX() + 3.0 * (to.getX() - from.getX()) / 4.0, controlY);
        c.setCurve(from, control1, control2, to);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (highlight) {
            g.setColor(SupplementaryAlignmentDiagramDialog.ARC_HIGHLIGHT_COLOR);
        } else {
            g.setColor(Color.GRAY);
        }
        g.draw(c);
        SupplementalAlignmentDiagram.drawPoint(g, to);
    }

    private static void drawPoint(Graphics2D g, Point2D point) {
        g.draw(new Ellipse2D.Double(point.getX() - 1.0, point.getY() - 1.0, 2.0, 2.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeContigName(Graphics g, String contig, double x, int y) {
        Color originalColor = g.getColor();
        try {
            g.setColor(ChromosomeColors.getColor(contig));
            g.drawString(contig, (int)x, y);
        }
        finally {
            g.setColor(originalColor);
        }
    }
}

