/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.Arrays;
import java.util.Random;

public class Downsampler<T> {
    private final Random RAND = new Random();

    public T[] sample(T[] input, int max) {
        if (input.length < max) {
            return input;
        }
        T[] downsampled = Arrays.copyOf(input, max);
        for (int i = max; i < input.length; ++i) {
            double samplingProb = (double)max / (double)(i + 1);
            if (!(this.RAND.nextDouble() < samplingProb)) continue;
            int idx = (int)(this.RAND.nextDouble() * (double)(max - 1));
            downsampled[idx] = input[i];
        }
        return downsampled;
    }
}

