/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import htsjdk.tribble.Feature;
import htsjdk.tribble.NamedFeature;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.IGVNamedFeature;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;

public class SearchCommand
implements Runnable {
    private static Logger log = LogManager.getLogger(SearchCommand.class);
    public static int SEARCH_LIMIT = 10000;
    String searchString;
    ReferenceFrame referenceFrame;
    boolean recordHistory = true;
    Genome genome;
    private static HashMap<String, ResultType> tokenMatchers;
    static String featureMutAA;
    static String featureMutNT;

    public SearchCommand(ReferenceFrame referenceFrame, String searchString) {
        this(referenceFrame, searchString, GenomeManager.getInstance().getCurrentGenome());
    }

    public SearchCommand(ReferenceFrame referenceFrame, String searchString, boolean recordHistory) {
        this(referenceFrame, searchString);
        this.recordHistory = recordHistory;
    }

    SearchCommand(ReferenceFrame referenceFrame, String searchString, Genome genome) {
        this.referenceFrame = referenceFrame;
        this.searchString = searchString.trim();
        this.genome = genome;
    }

    @Override
    public void run() {
        List<SearchResult> results = this.runSearch(this.searchString);
        this.showSearchResult(results);
    }

    public List<SearchResult> runSearch(String searchString) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String[] tokens = (searchString = searchString.replace("\"", "")).split("\\s+");
        if (tokens.length > 1 && tokens.length <= 3) {
            Chromosome c2;
            Chromosome c1;
            boolean mightBeLocus = true;
            for (int i = 1; i < tokens.length; ++i) {
                mightBeLocus = mightBeLocus && SearchCommand.isInteger(tokens[i]);
            }
            if (mightBeLocus && (c1 = this.genome.getChromosome(tokens[0])) != null && (c2 = this.genome.getChromosome(tokens[1])) == null) {
                results.add(this.calcChromoLocus(searchString));
                return results;
            }
        }
        for (String s : tokens) {
            SearchResult result = this.parseToken(s);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    public void showSearchResult(List<SearchResult> results) {
        int origZoom = this.referenceFrame.getZoom();
        if (results == null || results.size() == 0) {
            results = new ArrayList<SearchResult>();
            results.add(new SearchResult());
        }
        boolean showMessage = false;
        boolean success = true;
        Object message = "Invalid search string: " + this.searchString;
        boolean isGeneListMode = FrameManager.isGeneListMode();
        boolean resetFrames = false;
        if (results.size() == 1) {
            resetFrames = isGeneListMode;
            SearchResult result = results.get(0);
            if (result.type != ResultType.ERROR) {
                IGV.getInstance().getSession().setCurrentGeneList(null);
            }
            switch (result.type) {
                case FEATURE: {
                    this.showFlankedRegion(result.chr, result.start, result.end);
                    break;
                }
                case LOCUS: {
                    if (result.chr.equalsIgnoreCase("All")) {
                        this.referenceFrame.changeChromosome("All", false);
                        break;
                    }
                    Chromosome chromosome = GenomeManager.getInstance().getCurrentGenome().getChromosome(result.chr);
                    if (chromosome == null) {
                        message = "Unknow chromosome: " + result.chr;
                        success = false;
                        showMessage = true;
                        break;
                    }
                    if (result.start > chromosome.getLength()) {
                        message = "Range " + result.locus + " is beyond the end of the chromosome";
                        success = false;
                        showMessage = true;
                        break;
                    }
                    this.referenceFrame.jumpTo(result.chr, result.start, result.end);
                    break;
                }
                default: {
                    message = "Cannot find feature or locus: " + this.searchString;
                    success = false;
                    showMessage = true;
                }
            }
        } else {
            resetFrames = true;
            ArrayList<String> loci = new ArrayList<String>(results.size());
            message = "<html>";
            for (SearchResult res : results) {
                if (res.type != ResultType.ERROR) {
                    loci.add(res.getLocus());
                    continue;
                }
                message = (String)message + res.getMessage() + "<br>";
                showMessage = true;
            }
            GeneList geneList = new GeneList("", loci);
            IGV.getInstance().getSession().setCurrentGeneList(geneList);
        }
        if (resetFrames) {
            IGV.getInstance().resetFrames();
        } else {
            IGV.getInstance().repaint();
        }
        if (success && this.recordHistory) {
            IGV.getInstance().getSession().getHistory().push(this.searchString, origZoom);
        }
        if (showMessage) {
            MessageUtils.showMessage((String)message);
        }
    }

    public static Object[] getSelectionList(List<SearchResult> results, boolean longName) {
        ArrayList<String> options = new ArrayList<String>(Math.min(results.size(), SEARCH_LIMIT));
        for (SearchResult result : results) {
            if (result.type == ResultType.ERROR) continue;
            if (longName) {
                options.add(result.getLongName());
                continue;
            }
            options.add(result.getShortName());
        }
        return options.toArray();
    }

    Set<ResultType> checkTokenType(String token) {
        token = token.trim();
        HashSet<ResultType> possibles = new HashSet<ResultType>();
        for (String key : tokenMatchers.keySet()) {
            if (!token.matches(key)) continue;
            possibles.add(tokenMatchers.get(key));
        }
        return possibles;
    }

    private SearchResult parseToken(String token) {
        NamedFeature feat = FeatureDB.getFeature(token.toUpperCase().trim());
        if (feat != null) {
            return new SearchResult(feat);
        }
        SearchResult result = this.calcChromoLocus(token);
        if (result != null) {
            return result;
        }
        List<Track> searchableTracks = IGV.getInstance().getAllTracks().stream().filter(Track::isSearchable).toList();
        for (Track t : searchableTracks) {
            NamedFeature match = t.search(token);
            if (match == null) continue;
            return new SearchResult(match);
        }
        feat = this.searchWebservice(token);
        if (feat != null) {
            return new SearchResult(feat);
        }
        boolean mutAA = token.matches(featureMutAA);
        boolean mutNT = token.matches(featureMutNT);
        if (mutAA || mutNT) {
            Map<Integer, BasicFeature> genomePosList;
            String[] items = token.toUpperCase().split(":");
            String name = items[0].trim().toUpperCase();
            String coords = items[1];
            int coordLength = coords.length();
            if (mutAA) {
                String refSymbol = coords.substring(0, 1);
                String mutSymbol = coords.substring(coordLength - 1);
                String strLoc = coords.substring(1, coordLength - 1);
                int location = Integer.parseInt(strLoc) - 1;
                genomePosList = FeatureDB.getMutationAA(name, location + 1, refSymbol, mutSymbol, this.genome);
            } else if (mutNT) {
                String strLoc = coords.substring(0, coordLength - 3);
                String refSymbol = coords.substring(coordLength - 3, coordLength - 2);
                int location = Integer.parseInt(strLoc) - 1;
                genomePosList = FeatureDB.getMutationNT(name, location + 1, refSymbol, this.genome);
            } else {
                throw new IllegalArgumentException("Something went wrong parsing input token");
            }
            Iterator<Integer> iterator = genomePosList.keySet().iterator();
            if (iterator.hasNext()) {
                int genomePos = iterator.next();
                Feature feature = genomePosList.get(genomePos);
                int[] locs = SearchCommand.getStartEnd("" + (genomePos + 2));
                return new SearchResult(ResultType.LOCUS, feature.getChr(), locs[0], locs[1]);
            }
        }
        return null;
    }

    private NamedFeature searchWebservice(String str) {
        try {
            String tmp = "https://igv.org/genomes/locus.php?genome=$GENOME$&name=$FEATURE$";
            String genomeID = GenomeManager.getInstance().getGenomeId();
            if (genomeID != null && genomeID.indexOf("/") < 0 && genomeID.indexOf("\\") < 0) {
                URL url = new URL(tmp.replace("$GENOME$", genomeID).replace("$FEATURE$", str));
                String r = HttpUtils.getInstance().getContentsAsString(url);
                String[] t = Globals.whitespacePattern.split(r);
                if (t.length > 2) {
                    Locus l = Locus.fromString(t[1]);
                    String chr = this.genome == null ? l.getChr() : this.genome.getCanonicalChrName(l.getChr());
                    return new BasicFeature(chr, l.getStart(), l.getEnd());
                }
            }
        }
        catch (Exception e) {
            log.error("Search webservice error", e);
        }
        return null;
    }

    private SearchResult calcChromoLocus(String searchString) {
        boolean whitespace_delim;
        int[] startEnd = null;
        String[] tokens = searchString.split("\\s+");
        String chr = tokens[0];
        boolean bl = whitespace_delim = tokens.length >= 2;
        if (whitespace_delim) {
            Object posString = tokens[1];
            if (tokens.length >= 3) {
                posString = (String)posString + "-" + tokens[2];
            }
            startEnd = SearchCommand.getStartEnd((String)posString);
        } else {
            int colonIdx = searchString.lastIndexOf(":");
            if (colonIdx > 0) {
                chr = searchString.substring(0, colonIdx);
                Chromosome chromosome = this.genome.getChromosome(chr);
                if (chromosome == null) {
                    if (this.genome.getChromosome(searchString) != null) {
                        chr = searchString;
                        startEnd = null;
                    }
                } else {
                    String posString = searchString.substring(colonIdx).replace(":", "");
                    startEnd = SearchCommand.getStartEnd(posString);
                }
            }
        }
        if (chr.equals("*") || chr.toLowerCase().equals("all")) {
            return new SearchResult(ResultType.LOCUS, "All", 0, Integer.MAX_VALUE);
        }
        Chromosome chromosome = this.genome.getChromosome(chr);
        if (chromosome == null && (chromosome = this.genome.getChromosome(chr = tokens[0])) != null) {
            startEnd = null;
        }
        if (chromosome != null && !searchString.equals("All")) {
            chr = chromosome.getName();
            if (startEnd == null) {
                return new SearchResult(ResultType.LOCUS, chr, 0, chromosome.getLength());
            }
            int start = Math.min(startEnd[0], startEnd[1]);
            int end = Math.max(startEnd[0], startEnd[1]);
            return new SearchResult(ResultType.LOCUS, chr, start, end);
        }
        return null;
    }

    private void showFlankedRegion(String chr, int start, int end) {
        int flankingRegion = PreferencesManager.getPreferences().getAsInt("FLANKING_REGION");
        int delta = end - start == 1 ? 20 : (flankingRegion < 0 ? -flankingRegion * (end - start) / 100 : flankingRegion);
        start = Math.max(0, start - delta);
        this.referenceFrame.jumpTo(chr, start, end += delta);
    }

    private static int[] getStartEnd(String posString) {
        try {
            String[] posTokens = posString.split("-");
            String startString = posTokens[0].replaceAll(",", "");
            int start = Math.max(0, Integer.parseInt(startString) - 1);
            int end = start + 1;
            if (posTokens.length > 1) {
                String endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            if (posTokens.length == 1 || end >= start && end - start < 10) {
                int center = (start + end) / 2;
                int widen = 20;
                start = center - widen;
                start = Math.max(0, start);
                end = center + widen;
            }
            return new int[]{Math.min(start, end), Math.max(start, end)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static List<SearchResult> getResults(List<IGVNamedFeature> objects) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>(objects.size());
        for (IGVNamedFeature f : objects) {
            results.add(new SearchResult(f));
        }
        return results;
    }

    private static boolean isInteger(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        featureMutAA = "(\\S)+:[A-Z,a-z,*](((\\d)+,?)+)[A-Z,a-z,*]";
        featureMutNT = "(\\S)+:(\\S)+[A,C,G,T,a,c,g,t]\\>[A,C,G,T,a,c,g,t]";
    }

    public static class SearchResult {
        String chr;
        private int start;
        private int end;
        ResultType type;
        private String locus;
        private String message;
        private NamedFeature feature;

        public SearchResult() {
            this(ResultType.ERROR, null, -1, -1);
        }

        public SearchResult(ResultType type, String chr, int start, int end) {
            this.type = type;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.locus = Locus.getFormattedLocusString(chr, start, end);
        }

        public SearchResult(NamedFeature feature) {
            this(ResultType.FEATURE, feature.getChr(), feature.getStart(), feature.getEnd());
            this.feature = feature;
            this.locus = Locus.getFormattedLocusString(this.chr, this.start, this.end);
        }

        void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        String getLocus() {
            return this.locus;
        }

        String getShortName() {
            if (this.type == ResultType.FEATURE) {
                return this.feature.getName();
            }
            return this.locus;
        }

        String getLongName() {
            if (this.type == ResultType.FEATURE) {
                return this.feature.getName() + " (" + this.locus + ")";
            }
            return this.locus;
        }

        public ResultType getType() {
            return this.type;
        }

        public String getChr() {
            return this.chr;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public NamedFeature getFeature() {
            return this.feature;
        }
    }

    public static enum ResultType {
        FEATURE,
        LOCUS,
        ERROR,
        LIFTOVER;

    }
}

