/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Comparator;

public class ChromosomeNameComparator
implements Comparator<String> {
    private static ChromosomeNameComparator instance;
    private Table<String, String, Integer> cache = HashBasedTable.create();

    private ChromosomeNameComparator() {
    }

    public static ChromosomeNameComparator get() {
        if (instance == null) {
            instance = new ChromosomeNameComparator();
        }
        return instance;
    }

    private boolean isMito(String chr) {
        return chr.equalsIgnoreCase("chrM") || chr.equalsIgnoreCase("MT");
    }

    @Override
    public int compare(String chr1, String chr2) {
        boolean privledged2;
        boolean t1 = chr1.toLowerCase().startsWith("chr");
        boolean t2 = chr2.toLowerCase().startsWith("chr");
        if (t1 && !t2) {
            return -1;
        }
        if (t2 && !t1) {
            return 1;
        }
        String c1 = chr1;
        String c2 = chr2;
        if (t1 && t2) {
            c1 = chr1.substring(3);
            c2 = chr2.substring(3);
        }
        IntegerWithSuffix intSuffix1 = this.foo(c1);
        IntegerWithSuffix intSuffix2 = this.foo(c2);
        if (intSuffix1 != null && intSuffix2 == null) {
            return -1;
        }
        if (intSuffix2 != null && intSuffix1 == null) {
            return 1;
        }
        if (intSuffix1 != null && intSuffix2 != null) {
            if (intSuffix1.i == intSuffix2.i) {
                return intSuffix1.suffix.compareTo(intSuffix2.suffix);
            }
            return intSuffix1.i - intSuffix2.i;
        }
        boolean privledged1 = (t1 || intSuffix1 != null || this.isMito(chr1)) && c1.length() <= 3;
        boolean bl = privledged2 = (t2 || intSuffix2 != null || this.isMito(chr2)) && c2.length() <= 3;
        if (privledged1 && !privledged2) {
            return -1;
        }
        if (privledged2 && !privledged1) {
            return 1;
        }
        if (this.isMito(chr1)) {
            return 1;
        }
        if (this.isMito(chr2)) {
            return -1;
        }
        return chr1.compareToIgnoreCase(chr2);
    }

    private static boolean isInteger(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    IntegerWithSuffix foo(String str) {
        char c;
        int i;
        Object intSting = "";
        for (i = 0; i < str.length() && (c = str.charAt(i)) >= '0' && c <= '9'; ++i) {
            intSting = (String)intSting + c;
        }
        if (((String)intSting).length() == 0) {
            return null;
        }
        i = Integer.parseInt((String)intSting);
        String suffix = str.substring(((String)intSting).length());
        return new IntegerWithSuffix(i, suffix);
    }

    static class IntegerWithSuffix {
        int i;
        String suffix;

        public IntegerWithSuffix(int i, String suffix) {
            this.i = i;
            this.suffix = suffix;
        }
    }
}

