/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.bb;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.data.BasicScore;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.ChromAlias;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ucsc.BPTree;
import org.broad.igv.ucsc.Trix;
import org.broad.igv.ucsc.bb.BBHeader;
import org.broad.igv.ucsc.bb.BBTotalSummary;
import org.broad.igv.ucsc.bb.BBZoomHeader;
import org.broad.igv.ucsc.bb.BedData;
import org.broad.igv.ucsc.bb.ChromTree;
import org.broad.igv.ucsc.bb.RPTree;
import org.broad.igv.ucsc.bb.WigDatum;
import org.broad.igv.ucsc.bb.codecs.BBCodec;
import org.broad.igv.ucsc.bb.codecs.BBCodecFactory;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;
import org.broad.igv.util.CompressionUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class BBFile {
    public static final int BBFILE_HEADER_SIZE = 64;
    public static final long BIGWIG_MAGIC = 2291137574L;
    public static final long BIGBED_MAGIC = 2273964779L;
    public static final int BBFILE_EXTENDED_HEADER_HEADER_SIZE = 64;
    private Trix trix;
    String autosql;
    private ChromTree chromTree;
    private HashSet<String> chrNames;
    double featureDensity;
    Map<String, String> chrAliasTable;
    public BBTotalSummary totalSummary;
    private BPTree[] _searchTrees;
    BBCodec bedCodec;
    String path;
    Type type;
    BBHeader header = null;
    BBZoomHeader[] zoomHeaders;
    ByteOrder byteOrder;
    Genome genome;

    public boolean isBigWigFile() {
        return this.type == Type.BIGWIG;
    }

    public boolean isBigBedFile() {
        return this.type == Type.BIGBED;
    }

    public String getAutoSql() {
        return this.autosql;
    }

    public Set<String> getChromosomeNames() {
        return this.chrNames;
    }

    public void setTrix(Trix trix) {
    }

    public BBFile(String path, Genome genome) throws IOException {
        this.path = path;
        this.genome = genome;
        this.chrAliasTable = new HashMap<String, String>();
        this.init();
    }

    public BBFile(String path, Genome genome, String trixPath) throws IOException {
        this(path, genome);
        this.trix = new Trix(trixPath + "x", trixPath);
    }

    void init() throws IOException {
        this.header = this.readHeader();
    }

    BBHeader readHeader() throws IOException {
        ByteOrder order = ByteOrder.LITTLE_ENDIAN;
        UnsignedByteBuffer buffer = UnsignedByteBuffer.loadBinaryBuffer(this.path, order, 0L, 64);
        long magic = buffer.getUInt();
        if (magic == 2291137574L) {
            this.type = Type.BIGWIG;
        } else if (magic == 2273964779L) {
            this.type = Type.BIGBED;
        } else {
            order = ByteOrder.BIG_ENDIAN;
            buffer = UnsignedByteBuffer.loadBinaryBuffer(this.path, order, 0L, 64);
            magic = buffer.getUInt();
            if (magic == 2291137574L) {
                this.type = Type.BIGWIG;
            } else if (magic == 2273964779L) {
                this.type = Type.BIGBED;
            } else {
                throw new RuntimeException("Bad magic number " + magic);
            }
        }
        this.byteOrder = order;
        BBHeader header = new BBHeader();
        header.version = buffer.getUShort();
        header.nZoomLevels = buffer.getUShort();
        header.chromTreeOffset = buffer.getLong();
        header.fullDataOffset = buffer.getLong();
        header.fullIndexOffset = buffer.getLong();
        header.fieldCount = buffer.getUShort();
        header.definedFieldCount = buffer.getUShort();
        header.autoSqlOffset = buffer.getLong();
        header.totalSummaryOffset = buffer.getLong();
        header.uncompressBuffSize = buffer.getInt();
        header.extensionOffset = buffer.getLong();
        buffer = UnsignedByteBuffer.loadBinaryBuffer(this.path, order, 64L, (int)(header.fullDataOffset - 64L + 4L));
        this.zoomHeaders = new BBZoomHeader[header.nZoomLevels];
        for (int i = 0; i < header.nZoomLevels; ++i) {
            BBZoomHeader zlh = new BBZoomHeader();
            zlh.reductionLevel = buffer.getInt();
            zlh.reserved = buffer.getInt();
            zlh.dataOffset = buffer.getLong();
            zlh.indexOffset = buffer.getLong();
            this.zoomHeaders[i] = zlh;
        }
        Arrays.sort(this.zoomHeaders, (o1, o2) -> o2.reductionLevel - o1.reductionLevel);
        int startOffset = 64;
        if (header.autoSqlOffset > 0L) {
            buffer.position((int)(header.autoSqlOffset - 64L));
            this.autosql = buffer.getString();
        }
        if (header.version > 1 && header.totalSummaryOffset > 0L) {
            buffer.position((int)(header.totalSummaryOffset - 64L));
            this.totalSummary = BBTotalSummary.parseSummary(buffer);
        }
        buffer.position((int)(header.chromTreeOffset - 64L));
        this.chromTree = ChromTree.parseTree(buffer, 64, this.genome);
        this.chrNames = new HashSet<String>(Arrays.asList(this.chromTree.names()));
        buffer.position((int)(header.fullDataOffset - 64L));
        header.dataCount = buffer.getInt();
        this.header = header;
        if (header.extensionOffset > 0L) {
            this.loadExtendedHeader(header.extensionOffset);
        }
        if (header.version > 1) {
            buffer = UnsignedByteBuffer.loadBinaryBuffer(this.path, order, header.totalSummaryOffset, 40);
            this.totalSummary = BBTotalSummary.parseSummary(buffer);
        }
        this.featureDensity = (double)header.dataCount / (double)this.chromTree.sumLengths;
        if (this.type == Type.BIGBED) {
            this.bedCodec = BBCodecFactory.getCodec(this.autosql, header.definedFieldCount);
        }
        return header;
    }

    void loadExtendedHeader(long offset) throws IOException {
        UnsignedByteBuffer binaryParser = UnsignedByteBuffer.loadBinaryBuffer(this.path, this.byteOrder, offset, 64);
        int extensionSize = binaryParser.getUShort();
        int extraIndexCount = binaryParser.getUShort();
        long extraIndexListOffset = binaryParser.getLong();
        if (extraIndexCount == 0) {
            return;
        }
        int sz = extraIndexCount * 56;
        binaryParser = UnsignedByteBuffer.loadBinaryBuffer(this.path, this.byteOrder, extraIndexListOffset, sz);
        long[] indexOffset = new long[extraIndexCount];
        for (int i = 0; i < extraIndexCount; ++i) {
            int type = binaryParser.getUShort();
            int fc = binaryParser.getUShort();
            indexOffset[i] = binaryParser.getLong();
            binaryParser.getInt();
            for (int j = 0; j < fc; ++j) {
                int fieldId = binaryParser.getUShort();
                binaryParser.getUShort();
            }
        }
        this.header.extraIndexCount = extraIndexCount;
        this.header.extraIndexOffsets = indexOffset;
    }

    List<byte[]> getLeafChunks(String chr1, int bpStart, String chr2, int bpEnd, long treeOffset) throws IOException {
        if (this.header == null) {
            this.header = this.readHeader();
        }
        Integer chrIdx1 = this.getIdForChr(chr1);
        Integer chrIdx2 = this.getIdForChr(chr2);
        if (chrIdx1 == null || chrIdx2 == null) {
            return Collections.EMPTY_LIST;
        }
        RPTree rpTree = RPTree.loadTree(this.path, treeOffset);
        ArrayList<byte[]> leafChunks = new ArrayList<byte[]>();
        List<RPTree.Item> leafItems = rpTree.findLeafItemsOverlapping(chrIdx1, bpStart, chrIdx2, bpEnd);
        if (leafItems != null && leafItems.size() > 0) {
            long start = Long.MAX_VALUE;
            long end = 0L;
            for (RPTree.Item item : leafItems) {
                start = Math.min(start, item.dataOffset);
                end = Math.max(end, item.dataOffset + item.dataSize);
            }
            int size = (int)(end - start);
            int uncompressBufSize = this.header.uncompressBuffSize;
            try (SeekableStream is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);){
                byte[] buffer = new byte[size];
                is.seek(start);
                is.readFully(buffer);
                for (RPTree.Item item : leafItems) {
                    int offset = (int)(item.dataOffset - start);
                    int end_ = (int)((long)offset + item.dataSize);
                    byte[] itemBuffer = leafItems.size() == 1 ? buffer : Arrays.copyOfRange(buffer, offset, end_);
                    leafChunks.add(itemBuffer);
                }
            }
        }
        return leafChunks;
    }

    Integer getIdForChr(String chr) throws IOException {
        Integer chrIdx;
        if (this.chrAliasTable.get(chr) != null) {
            chr = this.chrAliasTable.get(chr);
        }
        if ((chrIdx = this.chromTree.getIdForName(chr)) == null && this.genome != null) {
            String alias = null;
            ChromAlias aliasRecord = this.genome.getAliasRecord(chr);
            if (aliasRecord != null) {
                for (String v : aliasRecord.values()) {
                    chrIdx = this.chromTree.getIdForName(v);
                    if (chrIdx == null) continue;
                    alias = v;
                    break;
                }
            }
            this.chrAliasTable.put(chr, alias);
        }
        return chrIdx;
    }

    String getChrForId(int chrIdx) {
        return this.chromTree.getNameForId(chrIdx);
    }

    BBZoomHeader zoomLevelForScale(double bpPerPixel) {
        Object level = null;
        for (BBZoomHeader zl : this.zoomHeaders) {
            if (!((double)zl.reductionLevel < bpPerPixel)) continue;
            return zl;
        }
        BBZoomHeader lastLevel = this.zoomHeaders[this.zoomHeaders.length - 1];
        return (double)(lastLevel.reductionLevel / 2) < bpPerPixel ? lastLevel : null;
    }

    public boolean isSearchable() {
        return this.header.extraIndexCount > 0;
    }

    public BasicFeature search(String term) throws IOException {
        long[] region;
        String[] exactMatches;
        String termLower;
        Map<String, String[]> results;
        if (this.header == null) {
            this.readHeader();
        }
        if (this.header.extraIndexCount == 0) {
            return null;
        }
        if (this.trix != null && (results = this.trix.search(termLower = term.toLowerCase())) != null && results.containsKey(termLower) && (exactMatches = results.get(termLower)).length > 0) {
            term = exactMatches[0];
        }
        if ((region = this.searchForRegions(term)) != null) {
            long start = region[0];
            int size = (int)region[1];
            try (SeekableStream is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);){
                BasicFeature largest;
                byte[] buffer = new byte[size];
                is.seek(start);
                is.readFully(buffer);
                List<BasicFeature> features = this.decodeFeatures(buffer, -1, -1, -1);
                String searchTerm = term;
                BasicFeature basicFeature = largest = features.stream().filter(f -> f.getName().equalsIgnoreCase(searchTerm) || f.getAttributes().values().stream().anyMatch(v -> v.equalsIgnoreCase(searchTerm))).reduce((f1, f2) -> {
                    int l2;
                    int l1 = f1.getEnd() - f1.getStart();
                    return l1 > (l2 = f2.getEnd() - f2.getStart()) ? f1 : f2;
                }).get();
                return basicFeature;
            }
        }
        return null;
    }

    List<BasicFeature> decodeFeatures(byte[] buffer, int chrIdx, int start, int end) {
        ArrayList<BasicFeature> features = new ArrayList<BasicFeature>();
        byte[] uncompressed = this.header.uncompressBuffSize > 0 ? new CompressionUtils().decompress(buffer, this.header.uncompressBuffSize) : buffer;
        UnsignedByteBuffer bb = UnsignedByteBuffer.wrap(uncompressed, this.byteOrder);
        while (bb.remaining() > 0L) {
            int chromId = bb.getInt();
            int chromStart = bb.getInt();
            int chromEnd = bb.getInt();
            String restOfFields = bb.getString();
            if (chrIdx > 0) {
                if (chromId < chrIdx || chromId == chrIdx && chromEnd < start) continue;
                if (chromId > chrIdx || chromId == chrIdx && chromStart >= end) break;
            }
            String chr = this.getChrForId(chromId);
            BedData bedData = new BedData(chr, chromStart, chromEnd, restOfFields);
            BasicFeature feature = this.bedCodec.decode(bedData);
            features.add(feature);
        }
        return features;
    }

    List<LocusScore> decodeZoomData(byte[] buffer, int chrIdx, int start, int end, WindowFunction windowFunction, List<LocusScore> features) {
        byte[] uncompressed = this.header.uncompressBuffSize > 0 ? new CompressionUtils().decompress(buffer, this.header.uncompressBuffSize) : buffer;
        UnsignedByteBuffer bb = UnsignedByteBuffer.wrap(uncompressed, this.byteOrder);
        while (bb.remaining() > 0L) {
            int chromId = bb.getInt();
            int chromStart = bb.getInt();
            int chromEnd = bb.getInt();
            int validCount = bb.getInt();
            float minVal = bb.getFloat();
            float maxVal = bb.getFloat();
            float sumData = bb.getFloat();
            float sumSquares = bb.getFloat();
            if (chrIdx > 0) {
                if (chromId < chrIdx || chromId == chrIdx && chromEnd < start) continue;
                if (chromId > chrIdx || chromId == chrIdx && chromStart >= end) break;
            }
            String chr = this.getChrForId(chromId);
            WigDatum feature = new WigDatum(chr, chromStart, chromEnd, switch (windowFunction) {
                case WindowFunction.min -> minVal;
                case WindowFunction.max -> maxVal;
                case WindowFunction.mean -> sumData / (float)validCount;
                default -> throw new RuntimeException("Unsupported window function: " + windowFunction);
            });
            features.add(feature);
        }
        return features;
    }

    List<LocusScore> decodeWigData(byte[] buffer, int chrIdx, int start, int end, List<LocusScore> features) {
        int blockStart;
        byte[] uncompressed = this.header.uncompressBuffSize > 0 ? new CompressionUtils().decompress(buffer, this.header.uncompressBuffSize) : buffer;
        UnsignedByteBuffer binaryParser = UnsignedByteBuffer.wrap(uncompressed, this.byteOrder);
        int chromId = binaryParser.getInt();
        int chromStart = blockStart = binaryParser.getInt();
        int chromEnd = binaryParser.getInt();
        int itemStep = binaryParser.getInt();
        int itemSpan = binaryParser.getInt();
        byte type = binaryParser.get();
        byte reserved = binaryParser.get();
        int itemCount = binaryParser.getUShort();
        if (chromId >= chrIdx && chromId <= chrIdx) {
            int idx = 0;
            while (itemCount-- > 0) {
                float value = Float.POSITIVE_INFINITY;
                switch (type) {
                    case 1: {
                        chromStart = binaryParser.getInt();
                        chromEnd = binaryParser.getInt();
                        value = binaryParser.getFloat();
                        break;
                    }
                    case 2: {
                        chromStart = binaryParser.getInt();
                        value = binaryParser.getFloat();
                        chromEnd = chromStart + itemSpan;
                        break;
                    }
                    case 3: {
                        value = binaryParser.getFloat();
                        chromStart = blockStart + idx * itemStep;
                        chromEnd = chromStart + itemSpan;
                        ++idx;
                    }
                }
                if (chromId < chrIdx || chromId == chrIdx && chromEnd < start) continue;
                if (chromId > chrIdx || chromId == chrIdx && chromStart >= end) break;
                if (!Float.isFinite(value)) continue;
                features.add(new BasicScore(chromStart, chromEnd, value));
            }
        }
        return features;
    }

    private long[] searchForRegions(String term) throws IOException {
        BPTree[] searchTrees = this.getSearchTrees();
        if (searchTrees != null) {
            String termLower;
            Map<String, String[]> trixResults;
            if (this.trix != null && (trixResults = this.trix.search(termLower = term.toLowerCase())) != null && trixResults.containsKey(termLower)) {
                term = trixResults.get(termLower)[0];
            }
            for (BPTree bpTree : searchTrees) {
                long[] result;
                if (bpTree == null || (result = bpTree.search(term)) == null) continue;
                return result;
            }
        }
        return null;
    }

    BPTree[] getSearchTrees() throws IOException {
        if (this._searchTrees == null && this.header.extraIndexOffsets != null && this.header.extraIndexOffsets.length > 0) {
            this._searchTrees = new BPTree[this.header.extraIndexOffsets.length];
            int idx = 0;
            for (long offset : this.header.extraIndexOffsets) {
                BPTree bpTree = BPTree.loadBPTree(this.path, offset);
                this._searchTrees[idx++] = bpTree;
            }
        }
        return this._searchTrees;
    }

    static enum Type {
        BIGWIG,
        BIGBED;

    }
}

