/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import htsjdk.samtools.util.SequenceUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.mods.BaseModficationFilter;
import org.broad.igv.sam.mods.BaseModificationColors;
import org.broad.igv.sam.mods.BaseModificationCounts;
import org.broad.igv.sam.mods.BaseModificationKey;
import org.broad.igv.track.RenderContext;

public class BaseModificationCoverageRenderer {
    static Map<String, Integer> modRankOrder;

    public static void drawModifications(RenderContext context, int pX, int pBottom, int dX, int barHeight, int pos, AlignmentCounts alignmentCounts, AlignmentTrack.ColorOption colorOption, BaseModficationFilter filter, float threshold, Set<String> simplexModifications) {
        BaseModificationCounts modificationCounts = alignmentCounts.getModifiedBaseCounts();
        if (modificationCounts != null) {
            Set<BaseModificationKey> allModificationKeys = modificationCounts.getAllModificationKeys();
            ArrayList<BaseModificationKey> sortedKeys = new ArrayList<BaseModificationKey>(allModificationKeys);
            Collections.sort(sortedKeys);
            int total = alignmentCounts.getTotalCount(pos);
            for (BaseModificationKey key : sortedKeys) {
                int count;
                int modifiable;
                try {
                    if (filter != null && !filter.pass(key.modification, key.getCanonicalBase())) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (key.modification.startsWith("NONE_") && colorOption != AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR) continue;
                byte base = (byte)key.getBase();
                byte compl = SequenceUtil.complement((byte)base);
                int n = modifiable = base == 78 ? total : alignmentCounts.getCount(pos, base) + alignmentCounts.getCount(pos, compl);
                int detectable = base == 78 ? total : (simplexModifications.contains(key.modification) ? alignmentCounts.getPosCount(pos, base) + alignmentCounts.getNegCount(pos, compl) : modifiable);
                if (detectable == 0 || (count = modificationCounts.getCount(pos, key, threshold, colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR)) == 0) continue;
                float modFraction = (float)modifiable / (float)total * ((float)count / (float)detectable);
                int modHeight = Math.round(modFraction * (float)barHeight);
                int likelihoodSum = modificationCounts.getLikelihoodSum(pos, key, threshold, colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR);
                int averageLikelihood = (int)((double)likelihoodSum) / count;
                int baseY = pBottom - modHeight;
                Color modColor = BaseModificationColors.getModColor(key.modification, averageLikelihood, colorOption);
                Graphics2D graphics = context.getGraphics();
                graphics.setColor(modColor);
                graphics.fillRect(pX, baseY, dX, modHeight);
                pBottom = baseY;
            }
        }
    }
}

