/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import htsjdk.tribble.Feature;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.DirectoryManager;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeException;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.load.ChromsizesLoader;
import org.broad.igv.feature.genome.load.DotGenomeLoader;
import org.broad.igv.feature.genome.load.FastaGenomeLoader;
import org.broad.igv.feature.genome.load.GenbankLoader;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeObjectLoader;
import org.broad.igv.feature.genome.load.HubGenomeLoader;
import org.broad.igv.feature.genome.load.JsonGenomeLoader;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.Utilities;

public abstract class GenomeLoader {
    public static final long ONE_WEEK = 604800000L;
    private static Logger log = LogManager.getLogger(GenomeLoader.class);
    public static Map<String, File> localSequenceMap;

    public static GenomeLoader getLoader(String genomePath) throws IOException {
        if (genomePath.endsWith(".genome")) {
            File archiveFile = GenomeManager.getGenomeFile(genomePath);
            if (!archiveFile.exists()) {
                MessageUtils.showMessage("File not found: " + archiveFile.getAbsolutePath());
                return null;
            }
            return new DotGenomeLoader(archiveFile);
        }
        if (genomePath.endsWith(".gbk") || genomePath.endsWith(".gb")) {
            return new GenbankLoader(genomePath);
        }
        if (genomePath.endsWith(".chrom.sizes")) {
            return new ChromsizesLoader(genomePath);
        }
        if (genomePath.endsWith(".json")) {
            return new JsonGenomeLoader(genomePath);
        }
        if (genomePath.endsWith(".2bit")) {
            GenomeConfig config = new GenomeConfig();
            config.twoBitURL = genomePath;
            config.id = genomePath;
            config.name = HttpUtils.isRemoteURL(genomePath) ? Utilities.getFileNameFromURL(genomePath) : new File(genomePath).getName();
            return new GenomeObjectLoader(config);
        }
        if (genomePath.endsWith("hub.txt")) {
            return new HubGenomeLoader(genomePath);
        }
        if (genomePath.endsWith(".gz")) {
            String gziPath = genomePath + ".gzi";
            String faiPath = genomePath + ".fai";
            if (!FileUtils.resourceExists(gziPath) || !FileUtils.resourceExists(faiPath)) {
                throw new GenomeException("IGV cannot readed gzipped fasta files.");
            }
        }
        return new FastaGenomeLoader(genomePath);
    }

    public abstract Genome loadGenome() throws IOException;

    public static FeatureTrack createGeneTrack(Genome genome, List<Feature> features) {
        FeatureDB.clearFeatures();
        FeatureTrack geneFeatureTrack = null;
        String name = "Annotations";
        String id = genome.getId() + "_genes";
        geneFeatureTrack = new FeatureTrack(id, name, (FeatureSource)new FeatureCollectionSource(features, genome));
        geneFeatureTrack.setMinimumHeight(5);
        geneFeatureTrack.setHeight(35);
        geneFeatureTrack.setColor(Color.BLUE.darker());
        return geneFeatureTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, File> loadSequenceMap() {
        File sequenceFile = new File(DirectoryManager.getGenomeCacheDirectory(), "sequenceMap.txt");
        localSequenceMap = new HashMap<String, File>();
        if (sequenceFile.exists()) {
            BufferedReader br = null;
            try {
                String nextLine;
                br = new BufferedReader(new FileReader(sequenceFile));
                while ((nextLine = br.readLine()) != null) {
                    String[] tokens = nextLine.split("\t");
                    if (tokens.length <= 1) continue;
                    File file = new File(tokens[1]);
                    if (file.exists()) {
                        localSequenceMap.put(tokens[0], file);
                        continue;
                    }
                    log.warn("Sequence file not found: " + file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                try {
                    log.error("Error loading sequence map file", e);
                }
                catch (Throwable throwable) {
                    GenomeLoader.closeSilently(br);
                    throw throwable;
                }
                GenomeLoader.closeSilently(br);
            }
            GenomeLoader.closeSilently(br);
        }
        return localSequenceMap;
    }

    static void closeSilently(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error("Error closing stream", e);
            }
        }
    }

    static void closeSilently(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.error("Error closing reader", e);
            }
        }
    }
}

