/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.sanityinc.jargs.CmdLineParser;
import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.tribble.util.URLHelperFactory;
import java.awt.Color;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.DefaultExceptionHandler;
import org.broad.igv.ui.DesktopIntegration;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.GlobalKeyDispatcher;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.ShutdownThread;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;
import org.broad.igv.util.stream.IGVUrlHelperFactory;

public class Main {
    private static Logger log = LogManager.getLogger(Main.class);

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        IGVArgs igvArgs = new IGVArgs(args);
        if (igvArgs.igvDirectory != null) {
            Main.setIgvDirectory(igvArgs);
        }
        Main.checkDotIgvDirectory();
        HttpUtils.getInstance().updateProxySettings();
        ParsingUtils.setURLHelperFactory((URLHelperFactory)IGVUrlHelperFactory.getInstance());
        Runnable runnable = () -> {
            if (Globals.IS_WINDOWS && System.getProperty("os.name").contains("10")) {
                UIManager.put("FileChooser.useSystemExtensionHiding", false);
            }
            DesktopIntegration.verifyJavaPlatform();
            Main.initApplication(igvArgs);
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(3);
            ImageIcon icon = new ImageIcon(Main.class.getResource("mainframeicon.png"));
            if (icon != null) {
                frame.setIconImage(icon.getImage());
            }
            Main.open(frame, igvArgs);
        };
        SwingUtilities.invokeLater(runnable);
    }

    private static void setIgvDirectory(IGVArgs igvArgs) {
        File dir = new File(igvArgs.igvDirectory);
        if (!dir.exists()) {
            try {
                if (dir.mkdir()) {
                    DirectoryManager.setIgvDirectory(dir);
                }
                log.error("Unable to create igv directory " + dir.getAbsolutePath());
            }
            catch (Exception e) {
                log.error("Error creating igv directory " + dir.getAbsolutePath(), e);
                return;
            }
        } else if (dir.isDirectory()) {
            if (dir.canWrite()) {
                DirectoryManager.setIgvDirectory(dir);
            } else {
                log.error("IGV directory '" + dir.getAbsolutePath() + "'is not writable");
            }
        } else {
            log.error("'" + dir.getAbsolutePath() + "' is not a directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkDotIgvDirectory() {
        File argsFile;
        String userHome = System.getProperty("user.home");
        File dir = new File(userHome, ".igv");
        if (!dir.exists()) {
            try {
                dir.mkdir();
            }
            catch (Exception e) {
                return;
            }
        }
        if (dir.isDirectory() && !(argsFile = new File(dir, "java_arguments")).exists()) {
            try (FileWriter argsFileWriter = new FileWriter(argsFile);){
                argsFileWriter.append("# See https://raw.githubusercontent.com/igvteam/igv/master/scripts/readme.txt for tips on using this file.");
                argsFileWriter.append(System.lineSeparator());
                argsFileWriter.append("# Uncomment the following line for an 8 GB memory spec for IGV.");
                argsFileWriter.append(System.lineSeparator());
                argsFileWriter.append("# -Xmx8G");
                argsFileWriter.append(System.lineSeparator());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void initApplication(IGVArgs igvArgs) {
        int MB;
        long mem = RuntimeUtils.getAvailableMemory();
        if (mem < (long)(400 * (MB = 1000000))) {
            int mb = (int)(mem / (long)MB);
            JOptionPane.showMessageDialog(null, "Warning: IGV is running with low available memory (" + mb + " mb)");
        }
        DirectoryManager.initializeLog();
        log.info("Startup  " + Globals.applicationString());
        log.info("Java " + System.getProperty("java.version") + " (build " + System.getProperty("java.vm.version") + ") " + System.getProperty("java.version.date", ""));
        log.info("Java Vendor: " + System.getProperty("java.vendor") + " " + System.getProperty("java.vendor.url", ""));
        log.info("JVM: " + System.getProperty("java.vm.name", "") + " " + System.getProperty("java.vendor.version", "") + "   " + System.getProperty("java.compiler", ""));
        log.info("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        log.info("IGV Directory: " + DirectoryManager.getIgvDirectory().getAbsolutePath());
        System.setProperty("http.agent", Globals.applicationString());
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        Main.updateTooltipSettings();
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
    }

    public static void updateTooltipSettings() {
        ToolTipManager.sharedInstance().setEnabled(true);
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        ToolTipManager.sharedInstance().setInitialDelay(prefMgr.getAsInt("TOOLTIP.INITIAL_DELAY"));
        ToolTipManager.sharedInstance().setReshowDelay(prefMgr.getAsInt("TOOLTIP.RESHOW_DELAY"));
        ToolTipManager.sharedInstance().setDismissDelay(prefMgr.getAsInt("TOOLTIP.DISMISS_DELAY"));
    }

    public static void open(Frame frame) {
        Main.open(frame, new IGVArgs(new String[0]));
    }

    public static void open(Frame frame, IGVArgs igvArgs) {
        if (!(frame instanceof JFrame)) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getComponent().setVisible(false);
                }
            });
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ToolTipManager.sharedInstance().setEnabled(true);
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                this.windowActivated(windowEvent);
            }
        });
        Main.initializeLookAndFeel();
        if (igvArgs.getPropertyOverrides() != null) {
            PreferencesManager.loadOverrides(igvArgs.getPropertyOverrides());
        }
        if (igvArgs.getDataServerURL() != null) {
            PreferencesManager.getPreferences().overrideDataServerURL(igvArgs.getDataServerURL());
        }
        if (igvArgs.getGenomeServerURL() != null) {
            PreferencesManager.getPreferences().overrideGenomeServerURL(igvArgs.getGenomeServerURL());
        }
        SeekableStreamFactory.setInstance((ISeekableStreamFactory)IGVSeekableStreamFactory.getInstance());
        IGV igv = IGV.createInstance(frame, igvArgs);
        igv.startUp(igvArgs);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(GlobalKeyDispatcher.getInstance());
    }

    private static void initializeLookAndFeel() {
        try {
            String lnf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lnf);
        }
        catch (Exception e) {
            log.error("Error setting look and feel", e);
        }
        double resolutionScale = Toolkit.getDefaultToolkit().getScreenResolution() / 96;
        if (resolutionScale != 1.0) {
            log.info("Resoluction scale = " + resolutionScale);
        }
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        if (resolutionScale > 1.5) {
            if (prefMgr.getAsBoolean("SCALE_FONTS")) {
                FontManager.scaleFontSize(resolutionScale);
            } else if (prefMgr.hasExplicitValue("DEFAULT_FONT_SIZE")) {
                int fs = prefMgr.getAsInt("DEFAULT_FONT_SIZE");
                FontManager.updateSystemFontSize(fs);
            }
        }
        if (Globals.IS_LINUX) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                UIManager.put("JideSplitPane.dividerSize", 5);
                UIManager.put("JideSplitPaneDivider.background", Color.darkGray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        LookAndFeelFactory.installJideExtension();
    }

    public static class IGVArgs {
        private String batchFile = null;
        private String sessionFile = null;
        private List<String> dataFileStrings = null;
        private String locusString = null;
        private String propertyOverrides = null;
        private String genomeId = null;
        private String port = null;
        private String dataServerURL = null;
        private String genomeServerURL = null;
        private String indexFile = null;
        private String coverageFile = null;
        private String name = null;
        public String igvDirectory = null;
        public Collection<String> httpHeader = null;

        IGVArgs(String[] args) {
            if (args != null) {
                this.parseArgs(args);
            }
        }

        private void parseArgs(String[] args) {
            String igvDirectoryPath;
            String coverageFilePath;
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option<String> propertyFileOption = parser.addStringOption('o', "preferences");
            CmdLineParser.Option<String> batchFileOption = parser.addStringOption('b', "batch");
            CmdLineParser.Option<String> portOption = parser.addStringOption('p', "port");
            CmdLineParser.Option<String> genomeOption = parser.addStringOption('g', "genome");
            CmdLineParser.Option<String> dataServerOption = parser.addStringOption('d', "dataServerURL");
            CmdLineParser.Option<String> genomeServerOption = parser.addStringOption('u', "genomeServerURL");
            CmdLineParser.Option<String> indexFileOption = parser.addStringOption('i', "indexFile");
            CmdLineParser.Option<String> coverageFileOption = parser.addStringOption('c', "coverageFile");
            CmdLineParser.Option<String> nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option<String> locusOption = parser.addStringOption('l', "locus");
            CmdLineParser.Option<String> igvDirectoryOption = parser.addStringOption("igvDirectory");
            CmdLineParser.Option<Boolean> versionOption = parser.addBooleanOption("version");
            CmdLineParser.Option<Boolean> helpOption = parser.addBooleanOption("help");
            CmdLineParser.Option<String> headerOption = parser.addStringOption('H', "header");
            try {
                parser.parse(args);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error parsing command line arguments: " + e.getMessage());
                return;
            }
            this.propertyOverrides = this.getDecodedValue(parser, propertyFileOption);
            this.batchFile = this.getDecodedValue(parser, batchFileOption);
            this.port = parser.getOptionValue(portOption);
            this.genomeId = parser.getOptionValue(genomeOption);
            this.dataServerURL = this.getDecodedValue(parser, dataServerOption);
            this.genomeServerURL = this.getDecodedValue(parser, genomeServerOption);
            this.name = parser.getOptionValue(nameOption);
            this.locusString = parser.getOptionValue(locusOption);
            this.httpHeader = parser.getOptionValues(headerOption);
            String indexFilePath = parser.getOptionValue(indexFileOption);
            if (indexFilePath != null) {
                this.indexFile = this.maybeDecodePath(indexFilePath);
            }
            if ((coverageFilePath = parser.getOptionValue(coverageFileOption)) != null) {
                this.coverageFile = this.maybeDecodePath(coverageFilePath);
            }
            if ((igvDirectoryPath = parser.getOptionValue(igvDirectoryOption)) != null) {
                this.igvDirectory = this.maybeDecodePath(igvDirectoryPath);
            }
            String[] nonOptionArgs = parser.getRemainingArgs();
            if (parser.getOptionValue(versionOption) != null) {
                System.out.println(Globals.VERSION);
                System.exit(0);
            }
            if (parser.getOptionValue(helpOption) != null) {
                this.printHelp();
                System.exit(0);
            }
            if (nonOptionArgs.length > 0) {
                nonOptionArgs = (String[])Arrays.stream(nonOptionArgs).filter(s -> !s.isEmpty()).toArray(String[]::new);
            }
            if (nonOptionArgs != null && nonOptionArgs.length > 0) {
                if (this.locusString != null || nonOptionArgs.length > 2) {
                    this.decodeNonOptionArgs(nonOptionArgs);
                } else if (nonOptionArgs.length == 1) {
                    this.decodeNonOptionArgsLegacy(nonOptionArgs);
                } else {
                    String secondArg = this.maybeDecodePath(nonOptionArgs[1]);
                    if (FileUtils.isRemote(secondArg) || new File(secondArg).exists()) {
                        this.decodeNonOptionArgs(nonOptionArgs);
                    } else {
                        this.decodeNonOptionArgsLegacy(nonOptionArgs);
                    }
                }
            }
        }

        private void decodeNonOptionArgsLegacy(String[] nonOptionArgs) {
            this.dataFileStrings = new ArrayList<String>();
            String firstArg = this.maybeDecodePath(nonOptionArgs[0]);
            if (firstArg != null) {
                log.info("Loading: " + firstArg);
                if (firstArg.endsWith(".xml") || firstArg.endsWith(".php") || firstArg.endsWith(".php3") || firstArg.endsWith(".session")) {
                    this.sessionFile = firstArg;
                } else {
                    String[] paths;
                    for (String p : paths = firstArg.split(",")) {
                        this.dataFileStrings.add(p);
                    }
                }
            }
            if (nonOptionArgs.length == 2) {
                this.locusString = nonOptionArgs[1];
            }
        }

        private void decodeNonOptionArgs(String[] nonOptionArgs) {
            this.dataFileStrings = new ArrayList<String>();
            for (String arg : nonOptionArgs) {
                this.dataFileStrings.add(this.maybeDecodePath(arg));
            }
        }

        private String maybeDecodePath(String path) {
            if (new File(path).exists()) {
                return path;
            }
            if (FileUtils.isRemote(path)) {
                return URLDecoder.decode(path);
            }
            if (path.contains("%2C") || path.contains("%3F") || path.contains("%2B") || path.contains("%2F")) {
                return URLDecoder.decode(path);
            }
            return path;
        }

        private String getDecodedValue(CmdLineParser parser, CmdLineParser.Option option) {
            String value = (String)parser.getOptionValue(option);
            if (value == null) {
                return null;
            }
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(e);
                return value;
            }
        }

        public String getBatchFile() {
            return this.batchFile;
        }

        public String getSessionFile() {
            return this.sessionFile;
        }

        public List<String> getDataFileStrings() {
            return this.dataFileStrings;
        }

        public String getLocusString() {
            return this.locusString;
        }

        public String getPropertyOverrides() {
            return this.propertyOverrides;
        }

        public String getGenomeId() {
            return this.genomeId;
        }

        public String getPort() {
            return this.port;
        }

        public String getDataServerURL() {
            return this.dataServerURL;
        }

        public String getGenomeServerURL() {
            return this.genomeServerURL;
        }

        public String getIndexFile() {
            return this.indexFile;
        }

        public String getCoverageFile() {
            return this.coverageFile;
        }

        public String getName() {
            return this.name;
        }

        public Collection<String> getHttpHeader() {
            return this.httpHeader;
        }

        private void printHelp() {
            System.out.println("Command line options:");
            System.out.println("Space delimited list of data files to load");
            System.out.println("--preferences, -o  Path or URL to a preference property file");
            System.out.println("--batch. -b  Path or url to a batch command file");
            System.out.println("--port, -p  IGV command port number (defaults to 60151)");
            System.out.println("--genome, -g  Genome ID (e.g hg19) or path or url to .genome or indexed fasta file");
            System.out.println("--dataServerURL, -d  Path or url to a data server registry file");
            System.out.println("--genomeServerURL, -u  Path or url to a genome server registry file");
            System.out.println("--indexFile, -i  Index file or comma delimited list of index files corresponding to data files");
            System.out.println("--coverageFile, -c  Coverage file or comma delimited list of coverage files corresponding to data files");
            System.out.println("--name, -n  Name or comma-delimited list of names for tracks corresponding to data files");
            System.out.println("--locus, -l  Initial locus");
            System.out.println("--header, -H http header to include with all requests for list of data files");
            System.out.println("--igvDirectory Path to the local igv directory.  Defaults to <user home>/igv");
            System.out.println("--version  Print the IGV version and exit");
            System.out.println("--help Print this output and exit");
        }
    }

    public static class Version {
        private int major;
        private int minor;
        private int build;

        public static Version getVersion(String versionString) {
            String[] tokens = versionString.split("\\.");
            if (tokens.length < 2) {
                return null;
            }
            try {
                int major = Integer.parseInt(tokens[0]);
                int minor = Integer.parseInt(tokens[1]);
                int build = tokens.length <= 2 ? 0 : Integer.parseInt(tokens[2]);
                return new Version(major, minor, build);
            }
            catch (NumberFormatException e) {
                log.error("Error parsing version string");
                return null;
            }
        }

        private Version(int major, int minor, int build) {
            this.major = major;
            this.minor = minor;
            this.build = build;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getBuild() {
            return this.build;
        }

        public boolean lessThan(Version anotherVersion) {
            if (anotherVersion.major > this.major) {
                return true;
            }
            if (anotherVersion.major < this.major) {
                return false;
            }
            if (anotherVersion.minor > this.minor) {
                return true;
            }
            if (anotherVersion.minor < this.minor) {
                return false;
            }
            return anotherVersion.build > this.build;
        }
    }
}

