/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

public class SMRTKineticsDecoder {
    private static final int base = 64;
    private final short[] frameCounts = new short[256];

    public SMRTKineticsDecoder() {
        for (int i = 0; i < 256; ++i) {
            this.frameCounts[i] = SMRTKineticsDecoder.decodeFrameCount((byte)i);
        }
    }

    public short lookupFrameCount(byte val) {
        return this.frameCounts[val & 0xFF];
    }

    private static short decodeFrameCount(byte val) {
        int mantissa = val & 0x3F;
        int exponent = (val & 0xC0) >> 6;
        int exponentVal = 1 << exponent;
        return (short)(64 * (exponentVal - 1) + exponentVal * mantissa);
    }
}

