/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import com.google.common.base.Predicate;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.KeyClass;
import org.broad.igv.feature.Strand;

public class FeatureUtils {
    public static final Comparator<Feature> FEATURE_START_COMPARATOR = (o1, o2) -> o1.getStart() - o2.getStart();
    public static final Comparator<Feature> FEATURE_END_COMPARATOR = (o1, o2) -> o1.getEnd() - o2.getEnd();
    public static final Comparator<Feature> FEATURE_CENTER_COMPARATOR = (o1, o2) -> o1.getStart() - o2.getStart() + o1.getEnd() - o2.getEnd();

    public static Predicate<Feature> getOverlapPredicate(String chr, int start, int end) {
        return object -> chr.equals(object.getChr()) && object.getStart() <= end && object.getEnd() > start;
    }

    public static void sortFeatureList(List<? extends Feature> features) {
        Collections.sort(features, FEATURE_START_COMPARATOR);
    }

    public static <T extends Feature> T getFeatureAt(double position, int buffer, List<? extends T> features) {
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            int idx = (startIdx + endIdx) / 2;
            Feature feature = (Feature)features.get(idx);
            int effectiveStart = feature.getStart();
            int effectiveEnd = feature.getEnd();
            if (position >= (double)(effectiveStart - buffer)) {
                if (position <= (double)(effectiveEnd + buffer)) {
                    return (T)((Feature)features.get(idx));
                }
                if (idx == startIdx) {
                    return null;
                }
                startIdx = idx;
                continue;
            }
            endIdx = idx;
        }
        return null;
    }

    public static Feature getFeatureStartsAfter(double position, List<? extends Feature> features) {
        if (features.size() == 0 || (double)features.get(features.size() - 1).getStart() <= position) {
            return null;
        }
        int idxBefore = FeatureUtils.getIndexBefore(position, features);
        if (idxBefore >= features.size() - 1) {
            return null;
        }
        for (Feature feature : features) {
            if (!((double)feature.getStart() > position)) continue;
            return feature;
        }
        return null;
    }

    public static Feature getFeatureEndsBefore(double position, List<? extends Feature> features) {
        Feature prevFeature = null;
        for (int index = FeatureUtils.getIndexBefore(position, features); index >= 0; --index) {
            Feature f = features.get(index);
            if (!((double)f.getEnd() < position)) continue;
            if (prevFeature == null) {
                prevFeature = f;
                continue;
            }
            if (f.getStart() != prevFeature.getStart()) break;
            if (f.getEnd() >= prevFeature.getEnd()) continue;
            prevFeature = f;
        }
        return prevFeature;
    }

    public static Feature getFeatureCenteredAfter(double position, List<? extends Feature> features) {
        if (features.size() == 0 || FeatureUtils.center(features.get(features.size() - 1)) <= position) {
            return null;
        }
        int idx = FeatureUtils.getIndexCenterAfter(position, features);
        if (idx < 0 || idx > features.size() - 1) {
            return null;
        }
        return features.get(idx);
    }

    public static Feature getFeatureCenteredBefore(double position, List<? extends Feature> features) {
        if (features.size() == 0) {
            return null;
        }
        if (FeatureUtils.center(features.get(0)) >= position) {
            return null;
        }
        int idx = FeatureUtils.getIndexCenterAfter(position, features);
        if (idx < 0) {
            return null;
        }
        --idx;
        while (idx >= 0) {
            if (FeatureUtils.center(features.get(idx)) < position) {
                return features.get(idx);
            }
            --idx;
        }
        return null;
    }

    public static Feature getFeatureClosest(double position, List<? extends Feature> features) {
        Comparator<Feature> closestComparator = Comparator.comparing(f -> FeatureUtils.getDistance((int)position, f)).thenComparing(f -> Math.abs(position - (double)f.getStart())).thenComparing(Locatable::getLengthOnReference);
        return Collections.min(features, closestComparator);
    }

    private static int getDistance(int position, Feature f) {
        int end = f.getEnd();
        int start = f.getStart();
        if (position >= start && position < end) {
            return 0;
        }
        if (position >= end) {
            return position - end + 1;
        }
        return start - position;
    }

    public static int getIndexBefore(double position, List<? extends Feature> features) {
        if (features == null || features.size() == 0) {
            return -1;
        }
        if ((double)features.get(features.size() - 1).getStart() <= position) {
            return features.size() - 1;
        }
        if ((double)features.get(0).getStart() >= position) {
            return -1;
        }
        KeyClass key = new KeyClass(position);
        int idx = Collections.binarySearch(features, key, FEATURE_START_COMPARATOR);
        if (idx < 0) {
            idx = -1 * idx;
        }
        for (idx = Math.min(features.size() - 1, idx); idx > 0 && !((double)features.get(idx).getStart() < position); --idx) {
        }
        return idx;
    }

    private static int getIndexCenterAfter(double position, List<? extends Feature> features) {
        Feature first = features.get(0);
        Feature last = features.get(features.size() - 1);
        if (FeatureUtils.center(first) > position) {
            return 0;
        }
        KeyClass key = new KeyClass(position);
        int idx = Collections.binarySearch(features, key, FEATURE_CENTER_COMPARATOR);
        if (idx < 0) {
            idx = -1 * idx - 1;
        }
        return idx;
    }

    public static int getIndexCenterBefore(double position, List<? extends Feature> features) {
        if (features == null || features.size() == 0) {
            return -1;
        }
        Feature first = features.get(0);
        Feature last = features.get(features.size() - 1);
        if (FeatureUtils.center(first) < position) {
            return 0;
        }
        if (FeatureUtils.center(last) >= position) {
            return features.size();
        }
        KeyClass key = new KeyClass(position);
        int idx = Collections.binarySearch(features, key, FEATURE_CENTER_COMPARATOR);
        if (idx < 0) {
            idx = -1 * idx;
        }
        idx = Math.min(features.size() - 1, idx);
        return idx;
    }

    private static double center(Feature f) {
        return (double)(f.getStart() + f.getEnd()) / 2.0;
    }

    public static int getIndexBeforeOld(double position, List<? extends Feature> features) {
        int idx;
        if (features == null || features.size() == 0) {
            return -1;
        }
        if ((double)features.get(features.size() - 1).getStart() <= position) {
            return features.size() - 1;
        }
        if ((double)features.get(0).getStart() >= position) {
            return -1;
        }
        int startIdx = 0;
        int endIdx = features.size() - 1;
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        if ((double)features.get(endIdx).getStart() >= position) {
            for (idx = endIdx; idx >= 0; --idx) {
                if (!((double)features.get(idx).getStart() < position)) continue;
                return idx;
            }
        } else {
            for (idx = endIdx + 1; idx < features.size(); ++idx) {
                if (!((double)features.get(idx).getStart() >= position)) continue;
                return idx - 1;
            }
        }
        return -1;
    }

    public static List<Feature> getAllFeaturesAt(double position, double maxLength, double minWidth, List<? extends Feature> features) {
        int startIdx;
        Feature feature;
        double start;
        ArrayList<Feature> returnList = null;
        double adjustedPosition = Math.max(0.0, position - maxLength);
        for (int idx = startIdx = Math.max(0, FeatureUtils.getIndexBefore(adjustedPosition, features)); idx < features.size() && !((start = (double)(feature = features.get(idx)).getStart() - minWidth / 2.0) > position); ++idx) {
            double end = (double)feature.getEnd() + minWidth / 2.0;
            if (!(position >= start) || !(position <= end)) continue;
            if (returnList == null) {
                returnList = new ArrayList<Feature>();
            }
            returnList.add(feature);
        }
        return returnList;
    }

    public static void computeReadingFrames(IGVFeature gene) {
        List<Exon> exons = gene.getExons();
        if (exons.size() == 0) {
            return;
        }
        int startIndex = gene.getStrand() == Strand.POSITIVE ? 0 : exons.size() - 1;
        int endIndex = gene.getStrand() == Strand.POSITIVE ? exons.size() : -1;
        int increment = gene.getStrand() == Strand.POSITIVE ? 1 : -1;
        int cds = 0;
        int exonNumber = 1;
        for (int i = startIndex; i != endIndex; i += increment) {
            int modCds;
            Exon exon = exons.get(i);
            exon.setNumber(exonNumber++);
            if (exon.getCodingLength() <= 0 && cds <= 0) continue;
            int frame = modCds = cds % 3;
            exon.setReadingFrame(frame);
            cds += exon.getCodingLength();
        }
    }
}

