/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackPanelScrollPane;

public class IGVPanel
extends JPanel
implements Paintable {
    Logger log = LogManager.getLogger(IGVPanel.class);
    MainPanel mainPanel;

    public IGVPanel(MainPanel mainPanel) {
        this.setLayout(null);
        this.mainPanel = mainPanel;
    }

    public int getViewportHeight() {
        Container parent = this.getParent();
        return parent == null ? 0 : parent.getHeight();
    }

    public TrackPanelScrollPane getScrollPane() {
        TrackPanelScrollPane scollpane = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            scollpane = (TrackPanelScrollPane)((Object)((JViewport)parent).getParent());
        }
        return scollpane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int h = this.getHeight();
            Component[] children = this.getComponents();
            int nw = this.mainPanel.getNamePanelWidth();
            Component namePanel = children[0];
            Component attributePanel = children[1];
            Component dataPanel = children[2];
            namePanel.setBounds(this.mainPanel.getNamePanelX(), 0, nw, h);
            attributePanel.setBounds(this.mainPanel.getAttributePanelX(), 0, this.mainPanel.getAttributePanelWidth(), h);
            dataPanel.setBounds(this.mainPanel.getDataPanelX(), 0, this.mainPanel.getDataPanelWidth(), h);
            dataPanel.doLayout();
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect, boolean batch) {
        Component[] children;
        g.setColor(Color.black);
        for (Component component : children = this.getComponents()) {
            if (!(component instanceof Paintable) || component.getWidth() <= 0) continue;
            Rectangle clipRect = new Rectangle(0, rect.y, component.getWidth(), rect.height);
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.translate(component.getX(), component.getY());
            ((Paintable)((Object)component)).paintOffscreen(graphics, clipRect, batch);
            graphics.dispose();
        }
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        return this.getHeight();
    }
}

