/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.ByteSubarray;

public class BisulfiteCounts {
    public static final AlignmentTrack.BisulfiteContext[] NOMESEQ_CONTEXTS = new AlignmentTrack.BisulfiteContext[]{AlignmentTrack.BisulfiteContext.HCG, AlignmentTrack.BisulfiteContext.GCH};
    Genome genome;
    AlignmentTrack.BisulfiteContext bisulfiteContext;
    Map<Integer, Count> counts = new HashMap<Integer, Count>();

    public BisulfiteCounts(AlignmentTrack.BisulfiteContext bisulfiteContext, Genome genome) {
        this.bisulfiteContext = bisulfiteContext;
        this.genome = genome;
    }

    public void incrementCounts(Alignment baseAlignment) {
        if (baseAlignment.getAlignmentBlocks() == null) {
            return;
        }
        String chrname = this.genome.getCanonicalChrName(baseAlignment.getChr());
        boolean flipRead = baseAlignment.isPaired() ? baseAlignment.isPaired() && baseAlignment.isNegativeStrand() ^ baseAlignment.isSecondOfPair() : baseAlignment.isNegativeStrand();
        for (AlignmentBlock block : baseAlignment.getAlignmentBlocks()) {
            int end;
            int start;
            byte[] inReference;
            if (block.isSoftClip() || block.getBases() == null || (inReference = this.genome.getSequence(chrname, start = block.getStart(), end = block.getEnd())) == null) continue;
            byte[] reference = flipRead ? AlignmentUtils.reverseComplementCopy(inReference) : inReference;
            ByteSubarray inRead = block.getBases();
            ByteSubarray read = flipRead ? AlignmentUtils.reverseComplementCopy(inRead) : inRead;
            int alignmentLen = inRead.length;
            int idxEnd = alignmentLen - 1;
            for (int idxFw = 0; idxFw < alignmentLen; ++idxFw) {
                boolean matchesContext;
                int idx;
                int n = idx = flipRead ? idxEnd - idxFw : idxFw;
                if (idx < 0 || idx >= reference.length) continue;
                byte refbase = reference[idx];
                if (refbase > 90) {
                    refbase = (byte)(refbase - 32);
                }
                if (refbase != 67) continue;
                byte readbase = read.getByte(idx);
                if (readbase == 61) {
                    readbase = refbase;
                }
                if (readbase > 90) {
                    readbase = (byte)(readbase - 32);
                }
                if (!AlignmentUtils.compareBases((byte)67, readbase) && !AlignmentUtils.compareBases((byte)84, readbase)) continue;
                AlignmentTrack.BisulfiteContext matchingContext = this.contextIsMatching(reference, read, idx, this.bisulfiteContext);
                boolean bl = matchesContext = matchingContext != null;
                if (!matchesContext) continue;
                int extension = 0;
                int step = flipRead ? -1 : 1;
                for (int i = 0; i <= extension; ++i) {
                    int position = start + idxFw + step * i;
                    Count count = this.counts.get(position);
                    if (count == null) {
                        count = new Count();
                        this.counts.put(position, count);
                    }
                    if (AlignmentUtils.compareBases((byte)84, readbase)) {
                        count.increment(false);
                        continue;
                    }
                    if (!AlignmentUtils.compareBases((byte)67, readbase)) continue;
                    count.increment(true);
                }
            }
        }
    }

    public Count getCount(int position) {
        Count c = this.counts.get(position);
        if (c == null) {
            c = new Count();
            this.counts.put(position, c);
        }
        return c;
    }

    protected AlignmentTrack.BisulfiteContext contextIsMatching(byte[] reference, ByteSubarray read, int idx, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        return bisulfiteContext.getMatchingBisulfiteContext(reference, read, idx);
    }

    protected int getBisulfiteSymmetricCytosineExtension(AlignmentTrack.BisulfiteContext item) {
        int out;
        switch (item) {
            case CG: 
            case HCG: 
            case WCG: {
                out = 1;
                break;
            }
            case CHG: {
                out = 2;
                break;
            }
            case GCH: {
                out = -1;
                break;
            }
            default: {
                out = 0;
            }
        }
        return out;
    }

    public static class Count {
        int methylatedCount;
        int unmethylatedCount;

        public void increment(boolean methylated) {
            if (methylated) {
                ++this.methylatedCount;
            } else {
                ++this.unmethylatedCount;
            }
        }
    }
}

