/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import htsjdk.samtools.util.SequenceUtil;
import java.util.Map;

public class BaseModificationSet {
    char base;
    char strand;
    String modification;
    Map<Integer, Byte> likelihoods;

    public BaseModificationSet(char base, char strand, String modification, Map<Integer, Byte> likelihoods) {
        this.base = base;
        this.modification = modification;
        this.strand = strand;
        this.likelihoods = likelihoods;
    }

    public char getBase() {
        return this.base;
    }

    public char getCanonicalBase() {
        return this.strand == '+' ? this.base : (char)SequenceUtil.complement((byte)((byte)this.base));
    }

    public String getModification() {
        return this.modification;
    }

    public char getStrand() {
        return this.strand;
    }

    public Map<Integer, Byte> getLikelihoods() {
        return this.likelihoods;
    }

    public boolean containsPosition(Integer pos) {
        return this.likelihoods.containsKey(pos);
    }

    public boolean is5mC() {
        return this.modification.equals("m") && (this.base == 'C' && this.strand == '+' || this.base == 'G' && this.strand == '-');
    }
}

