/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public final class LZMAExternalCompressor
extends ExternalCompressor {
    public LZMAExternalCompressor() {
        super(BlockCompressionMethod.LZMA);
    }

    @Override
    public byte[] compress(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(data.length * 2);
        try (XZCompressorOutputStream xzCompressorOutputStream = new XZCompressorOutputStream((OutputStream)byteArrayOutputStream);){
            xzCompressorOutputStream.write(data);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] uncompress(byte[] data) {
        try (XZCompressorInputStream xzCompressorInputStream = new XZCompressorInputStream((InputStream)new ByteArrayInputStream(data));){
            byte[] byArray = InputStreamUtils.readFully((InputStream)xzCompressorInputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

