/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.broad.igv.Globals;
import org.broad.igv.aws.IGVS3Object;
import org.broad.igv.google.OAuthProvider;
import org.broad.igv.google.OAuthUtils;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.util.AmazonS3URI;
import org.broad.igv.util.JWTParser;
import org.broad.igv.util.S3Presigner;
import org.broad.igv.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClientBuilder;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenResponse;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.Credentials;

public class AmazonUtils {
    private static Logger log = LogManager.getLogger(AmazonUtils.class);
    private static S3Client s3Client;
    private static List<String> bucketsFinalList;
    private static CognitoIdentityClient cognitoIdentityClient;
    private static Region AWSREGION;
    private static Boolean awsCredentialsPresent;
    private static Map<String, String> s3ToPresignedMap;
    private static Map<String, String> presignedToS3Map;
    private static JsonObject CognitoConfig;

    public static void setCognitoConfig(JsonObject json) {
        CognitoConfig = json;
        awsCredentialsPresent = CognitoConfig.get("auth_provider").getAsString().contains("Amazon");
        if (IGVMenuBar.getInstance() != null) {
            IGVMenuBar.getInstance().updateAWSMenu();
        }
    }

    public static JsonObject GetCognitoConfig() {
        return CognitoConfig;
    }

    public static boolean isAwsProviderPresent() {
        block8: {
            if (awsCredentialsPresent == null) {
                if (AmazonUtils.GetCognitoConfig() != null) {
                    try {
                        if (AmazonUtils.GetCognitoConfig().get("auth_provider").getAsString().contains("Amazon")) {
                            log.info("AWS configuration found. AWS support enabled.");
                            awsCredentialsPresent = true;
                            break block8;
                        }
                        log.info("AWS configuration not found.");
                        awsCredentialsPresent = false;
                    }
                    catch (NullPointerException np) {
                        awsCredentialsPresent = false;
                    }
                } else {
                    try {
                        DefaultCredentialsProvider.create().resolveCredentials();
                        log.info("AWS default credentials found. AWS support enabled.");
                        awsCredentialsPresent = true;
                    }
                    catch (Exception e) {
                        awsCredentialsPresent = false;
                    }
                }
            }
        }
        return awsCredentialsPresent;
    }

    private static Region getAWSREGION() {
        if (AWSREGION == null) {
            if (AmazonUtils.GetCognitoConfig() != null) {
                AWSREGION = Region.of((String)AmazonUtils.GetCognitoConfig().get("aws_region").getAsString());
            } else {
                try {
                    AWSREGION = new DefaultAwsRegionProviderChain().getRegion();
                }
                catch (Exception e) {
                    AWSREGION = Region.US_EAST_1;
                }
            }
        }
        return AWSREGION;
    }

    public static Credentials GetCognitoAWSCredentials() {
        OAuthProvider provider = OAuthUtils.getInstance().getProvider("Amazon");
        JsonObject igv_oauth_conf = AmazonUtils.GetCognitoConfig();
        JsonObject response = provider.getResponse();
        if (response == null) {
            AmazonUtils.checkLogin();
            response = provider.getResponse();
        }
        JsonObject payload = JWTParser.getPayload(response.get("id_token").getAsString());
        log.debug("JWT payload id token: " + payload);
        String idTokenStr = response.get("id_token").getAsString();
        String idProvider = payload.get("iss").toString().replace("https://", "").replace("\"", "");
        String email = payload.get("email").getAsString();
        String federatedPoolId = igv_oauth_conf.get("aws_cognito_fed_pool_id").getAsString();
        String cognitoRoleARN = igv_oauth_conf.get("aws_cognito_role_arn").getAsString();
        HashMap<String, String> logins = new HashMap<String, String>();
        logins.put(idProvider, idTokenStr);
        AnonymousCredentialsProvider anoCredProv = AnonymousCredentialsProvider.create();
        CognitoIdentityClientBuilder cognitoIdentityBuilder = CognitoIdentityClient.builder();
        ((CognitoIdentityClientBuilder)cognitoIdentityBuilder.region(AmazonUtils.getAWSREGION())).credentialsProvider((AwsCredentialsProvider)anoCredProv);
        cognitoIdentityClient = (CognitoIdentityClient)cognitoIdentityBuilder.build();
        GetIdRequest.Builder idrequest = GetIdRequest.builder().identityPoolId(federatedPoolId).logins(logins);
        GetIdResponse idResult = cognitoIdentityClient.getId((GetIdRequest)idrequest.build());
        GetOpenIdTokenRequest.Builder openidrequest = GetOpenIdTokenRequest.builder().logins(logins).identityId(idResult.identityId());
        GetOpenIdTokenResponse openId = cognitoIdentityClient.getOpenIdToken((GetOpenIdTokenRequest)openidrequest.build());
        AssumeRoleWithWebIdentityRequest.Builder webidrequest = AssumeRoleWithWebIdentityRequest.builder().webIdentityToken(openId.token()).roleSessionName(email).roleArn(cognitoRoleARN);
        AssumeRoleWithWebIdentityResponse stsClientResponse = ((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)anoCredProv)).region(AmazonUtils.getAWSREGION())).build()).assumeRoleWithWebIdentity((AssumeRoleWithWebIdentityRequest)webidrequest.build());
        return stsClientResponse.credentials();
    }

    public static void updateS3Client(Credentials credentials) {
        Region region = AmazonUtils.getAWSREGION();
        if (credentials == null) {
            s3Client = (S3Client)((S3ClientBuilder)S3Client.builder().region(region)).build();
        } else {
            AwsSessionCredentials creds = AwsSessionCredentials.create((String)credentials.accessKeyId(), (String)credentials.secretAccessKey(), (String)credentials.sessionToken());
            StaticCredentialsProvider s3CredsProvider = StaticCredentialsProvider.create((AwsCredentials)creds);
            s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)s3CredsProvider)).region(region)).build();
        }
    }

    public static List<String> ListBucketsForUser() {
        if (bucketsFinalList.isEmpty()) {
            if (AmazonUtils.GetCognitoConfig() != null) {
                OAuthUtils.getInstance().getProvider("Amazon").getAccessToken();
                AmazonUtils.updateS3Client(AmazonUtils.GetCognitoAWSCredentials());
            } else {
                AmazonUtils.updateS3Client(null);
            }
            ArrayList<String> bucketsList = new ArrayList<String>();
            ListBucketsRequest listBucketsRequest = (ListBucketsRequest)ListBucketsRequest.builder().build();
            ListBucketsResponse listBucketsResponse = s3Client.listBuckets(listBucketsRequest);
            listBucketsResponse.buckets().stream().forEach(x -> bucketsList.add(x.name()));
            bucketsFinalList = AmazonUtils.getReadableBuckets(bucketsList);
        }
        return bucketsFinalList;
    }

    public static HeadObjectResponse getObjectMetadata(String bucket, String key) {
        HeadObjectRequest HeadObjReq = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(key).build();
        HeadObjectResponse HeadObjRes = s3Client.headObject(HeadObjReq);
        log.debug("getObjectMetadata(): " + HeadObjRes.toString());
        return HeadObjRes;
    }

    public static s3ObjectAccessResult isObjectAccessible(String bucket, String key) {
        s3ObjectAccessResult res = new s3ObjectAccessResult();
        res.setObjAvailable(true);
        HeadObjectResponse s3Meta = AmazonUtils.getObjectMetadata(bucket, key);
        if (s3Meta.storageClass() == null) {
            res.setErrorReason("Object is in an accessible tier, no errors are expected");
            res.setObjAvailable(true);
            return res;
        }
        String s3ObjectStorageClass = s3Meta.storageClass().toString();
        String archived = "Amazon S3 object is in " + s3ObjectStorageClass + " storage tier, not accessible at this moment. Please contact your local system administrator about object: s3://" + bucket + "/" + key;
        String restoreInProgress = "Amazon S3 object is in " + s3ObjectStorageClass + " and being restored right now, please be patient, this can take up to 48h. For further enquiries about this dataset, please use the following path when communicating with your system administrator: s3://" + bucket + "/" + key;
        if (s3ObjectStorageClass.contains("DEEP_ARCHIVE") || s3ObjectStorageClass.contains("GLACIER")) {
            String s3ObjectStorageStatus;
            try {
                s3ObjectStorageStatus = ((List)s3Meta.sdkHttpResponse().headers().get("x-amz-restore")).toString();
            }
            catch (NullPointerException npe) {
                res.setObjAvailable(false);
                res.setErrorReason(archived);
                return res;
            }
            if (s3ObjectStorageStatus.contains("ongoing-request=\"true\"")) {
                res.setObjAvailable(false);
                res.setErrorReason(restoreInProgress);
            } else if (s3ObjectStorageStatus.contains("ongoing-request=\"false\"") && s3ObjectStorageStatus.contains("expiry-date=")) {
                res.setObjAvailable(true);
            } else {
                res.setObjAvailable(false);
                res.setErrorReason(archived);
            }
        }
        return res;
    }

    private static List<String> getReadableBuckets(List<String> buckets) {
        List futures = buckets.stream().map(bucket -> {
            CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
                if (AmazonUtils.ListBucketObjects(bucket, "").size() > 0) {
                    return bucket;
                }
                return null;
            });
            return future;
        }).collect(Collectors.toList());
        List<String> result = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        result.removeAll(Collections.singleton(null));
        return result;
    }

    public static ArrayList<IGVS3Object> ListBucketObjects(String bucketName, String prefix) {
        ArrayList<IGVS3Object> objects = new ArrayList<IGVS3Object>();
        log.debug("Listing objects for bucketName: " + bucketName);
        if (AmazonUtils.GetCognitoConfig() != null) {
            OAuthUtils.getInstance().getProvider("Amazon").getAccessToken();
            AmazonUtils.updateS3Client(AmazonUtils.GetCognitoAWSCredentials());
        } else {
            AmazonUtils.updateS3Client(null);
        }
        try {
            ListObjectsV2Request listReq = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).prefix(prefix).delimiter("/").build();
            ListObjectsV2Response response = s3Client.listObjectsV2(listReq);
            ListObjectsV2Iterable resultIt = s3Client.listObjectsV2Paginator(listReq);
            do {
                for (CommonPrefix folder : resultIt.commonPrefixes()) {
                    log.debug("S3 Bucket folder: " + folder);
                    String folder_prefix = folder.prefix().substring(0, folder.prefix().length() - 1);
                    objects.add(new IGVS3Object(folder_prefix.replace(prefix, ""), true, "STANDARD"));
                }
                for (S3Object content : response.contents()) {
                    log.debug("S3 Bucket key: " + content.key());
                    objects.add(new IGVS3Object(content.key().replace(prefix, ""), false, content.storageClassAsString()));
                }
                String token = response.nextContinuationToken();
                log.debug("Next S3 bucket pagination continuation Token: " + token);
                response.continuationToken();
            } while (response.isTruncated().booleanValue());
        }
        catch (SdkClientException | SdkServiceException e) {
            log.debug("AccessDenied for ListBucket " + bucketName + " with prefix " + prefix);
        }
        return objects;
    }

    public static String getBucketFromS3URL(String s3URL) {
        AmazonS3URI s3URI = new AmazonS3URI(s3URL);
        return s3URI.getBucket();
    }

    public static String getKeyFromS3URL(String s3URL) {
        AmazonS3URI s3URI = new AmazonS3URI(s3URL);
        return s3URI.getKey();
    }

    private static String createPresignedURL(String s3Path) throws IOException {
        S3Presigner s3Presigner;
        if (AmazonUtils.GetCognitoConfig() != null) {
            OAuthProvider provider = OAuthUtils.getInstance().getProvider("Amazon");
            provider.getAccessToken();
            Credentials credentials = AmazonUtils.GetCognitoAWSCredentials();
            AwsSessionCredentials creds = AwsSessionCredentials.create((String)credentials.accessKeyId(), (String)credentials.secretAccessKey(), (String)credentials.sessionToken());
            StaticCredentialsProvider awsCredsProvider = StaticCredentialsProvider.create((AwsCredentials)creds);
            s3Presigner = S3Presigner.builder().expiration(provider.getExpirationTime()).awsCredentials((AwsCredentialsProvider)awsCredsProvider).region(AmazonUtils.getAWSREGION()).build();
        } else {
            s3Presigner = S3Presigner.builder().build();
        }
        String bucket = AmazonUtils.getBucketFromS3URL(s3Path);
        String key = AmazonUtils.getKeyFromS3URL(s3Path);
        URI presigned = s3Presigner.presignS3DownloadLink(bucket, key);
        log.debug("AWS presigned URL from translateAmazonCloudURL is: " + presigned);
        return presigned.toString();
    }

    public static String translateAmazonCloudURL(String s3UrlString) throws IOException {
        String presignedUrl = s3ToPresignedMap.get(s3UrlString);
        if (presignedUrl == null || !AmazonUtils.isPresignedURLValid(new URL(presignedUrl))) {
            presignedUrl = AmazonUtils.createPresignedURL(s3UrlString);
            s3ToPresignedMap.put(s3UrlString, presignedUrl);
            presignedToS3Map.put(presignedUrl, s3UrlString);
        }
        return presignedUrl;
    }

    public static Boolean isAwsS3Path(String path) {
        return path.startsWith("s3://");
    }

    public static boolean isPresignedURL(String urlString) {
        return presignedToS3Map.containsKey(urlString);
    }

    public static String updatePresignedURL(String urlString) throws IOException {
        String s3UrlString = presignedToS3Map.get(urlString);
        if (s3UrlString == null) {
            throw new RuntimeException("Unrecognized presigned url: " + urlString);
        }
        return AmazonUtils.translateAmazonCloudURL(s3UrlString);
    }

    public static void checkLogin() {
        if (AmazonUtils.GetCognitoConfig() != null && !OAuthUtils.getInstance().getProvider("Amazon").isLoggedIn()) {
            OAuthUtils.getInstance().getProvider("Amazon").doSecureLogin();
        }
    }

    private static boolean isPresignedURLValid(URL url) {
        boolean isValidSignedUrl;
        try {
            long presignedTime = AmazonUtils.signedURLValidity(url);
            isValidSignedUrl = presignedTime - System.currentTimeMillis() - (long)Globals.TOKEN_EXPIRE_GRACE_TIME > 0L;
        }
        catch (ParseException e) {
            log.error("The AWS signed URL date parameter X-Amz-Date has incorrect formatting");
            isValidSignedUrl = false;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            isValidSignedUrl = false;
        }
        return isValidSignedUrl;
    }

    private static long signedURLValidity(URL url) throws ParseException, UnsupportedEncodingException {
        Map<String, String> params = StringUtils.splitQuery(url);
        String amzDateStr = params.get("X-Amz-Date");
        long amzExpires = Long.parseLong(params.get("X-Amz-Expires"));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date amzDate = formatter.parse(amzDateStr);
        long timeOfExpirationMillis = amzDate.getTime() + amzExpires * 1000L;
        log.debug("The date of expiration is " + amzDate + ", expires after " + amzExpires + " seconds for url: " + url);
        return timeOfExpirationMillis;
    }

    static {
        bucketsFinalList = new ArrayList<String>();
        awsCredentialsPresent = null;
        s3ToPresignedMap = new HashMap<String, String>();
        presignedToS3Map = new HashMap<String, String>();
    }

    public static class s3ObjectAccessResult {
        private boolean objAvailable;
        private String errorReason;

        public boolean isObjectAvailable() {
            return this.objAvailable;
        }

        public void setObjAvailable(boolean objAvailable) {
            this.objAvailable = objAvailable;
        }

        public String getErrorReason() {
            return this.errorReason;
        }

        public void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }
    }
}

