/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.mods.BaseModificationSet;

public class BaseModificationCounts {
    LinkedHashSet<Key> allModifications = new LinkedHashSet();
    Map<Key, Map<Integer, Integer>> counts = new HashMap<Key, Map<Integer, Integer>>();
    Map<Key, Map<Integer, Integer>> likelihoodSums = new HashMap<Key, Map<Integer, Integer>>();

    public void incrementCounts(Alignment alignment) {
        if (alignment.getAlignmentBlocks() == null) {
            return;
        }
        List<BaseModificationSet> baseModificationSets = alignment.getBaseModificationSets();
        if (baseModificationSets != null) {
            for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                for (int i = block.getBases().startOffset; i < block.getBases().startOffset + block.getBases().length; ++i) {
                    for (BaseModificationSet bmset : baseModificationSets) {
                        Key key = new Key(bmset.getBase(), bmset.getStrand(), bmset.getModification());
                        Map<Integer, Byte> likelihoods = bmset.getLikelihoods();
                        if (bmset.containsPosition(i)) {
                            Map<Integer, Integer> modLikelihoods;
                            int lh = Byte.toUnsignedInt(likelihoods.get(i));
                            Map<Integer, Integer> modCounts = this.counts.get(key);
                            if (modCounts == null) {
                                modCounts = new HashMap<Integer, Integer>();
                                this.counts.put(key, modCounts);
                            }
                            if ((modLikelihoods = this.likelihoodSums.get(key)) == null) {
                                modLikelihoods = new HashMap<Integer, Integer>();
                                this.likelihoodSums.put(key, modLikelihoods);
                            }
                            int blockIdx = i - block.getBases().startOffset;
                            int position = block.getStart() + blockIdx;
                            int c = modCounts.containsKey(position) ? modCounts.get(position) + 1 : 1;
                            int l = modLikelihoods.containsKey(position) ? modLikelihoods.get(position) + lh : lh;
                            modCounts.put(position, c);
                            modLikelihoods.put(position, l);
                        }
                        this.allModifications.add(key);
                    }
                }
            }
        }
    }

    public int getCount(int position, Key key, AlignmentTrack.ColorOption colorOption) {
        Map<Integer, Integer> modCounts = this.counts.get(key);
        if (modCounts != null && modCounts.containsKey(position)) {
            return modCounts.get(position);
        }
        return 0;
    }

    public int getLikelhoodSum(int position, Key key) {
        Map<Integer, Integer> modLikelihoods = this.likelihoodSums.get(key);
        if (modLikelihoods != null && modLikelihoods.containsKey(position)) {
            return modLikelihoods.get(position);
        }
        return this.getCount(position, key, null) * 255;
    }

    public Collection<Key> getAllModifications() {
        return this.allModifications;
    }

    public String getValueString(int position, AlignmentTrack.ColorOption colorOption) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<Key, Map<Integer, Integer>> entry : this.counts.entrySet()) {
            String modification = entry.getKey().modification;
            Map<Integer, Integer> modCounts = entry.getValue();
            if (!modCounts.containsKey(position)) continue;
            buffer.append("Modification: " + modification + " (" + modCounts.get(position) + ")<br>");
        }
        return buffer.toString();
    }

    public void dump() {
        for (Map.Entry<Key, Map<Integer, Integer>> entry : this.counts.entrySet()) {
            String modification = entry.getKey().toString();
            Map<Integer, Integer> modCounts = entry.getValue();
            System.out.println("Modification: " + modification);
            for (Map.Entry<Integer, Integer> modKey : modCounts.entrySet()) {
                System.out.println(modKey.getKey() + "  " + modKey.getValue());
            }
        }
    }

    public static class Key {
        char base;
        char strand;
        String modification;

        public Key(char base, char strand, String modification) {
            this.base = base;
            this.strand = strand;
            this.modification = modification;
        }

        public char getBase() {
            return this.base;
        }

        public char getStrand() {
            return this.strand;
        }

        public String getModification() {
            return this.modification;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.base == key.base && this.strand == key.strand && this.modification.equals(key.modification);
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.base), Character.valueOf(this.strand), this.modification);
        }

        public String toString() {
            return "" + this.base + this.strand + this.modification;
        }
    }
}

