/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSortOrderChecker;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.ProgressLoggerInterface;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.io.StringWriter;

public abstract class SAMFileWriterImpl
implements SAMFileWriter {
    private static int DEAFULT_MAX_RECORDS_IN_RAM = 500000;
    private int maxRecordsInRam = DEAFULT_MAX_RECORDS_IN_RAM;
    private SAMFileHeader.SortOrder sortOrder;
    private SAMFileHeader header;
    private SortingCollection<SAMRecord> alignmentSorter;
    private File tmpDir = new File(System.getProperty("java.io.tmpdir"));
    private ProgressLoggerInterface progressLogger = null;
    private boolean isClosed = false;
    private boolean presorted;
    private SAMSortOrderChecker sortOrderChecker;

    public static void setDefaultMaxRecordsInRam(int maxRecordsInRam) {
        DEAFULT_MAX_RECORDS_IN_RAM = maxRecordsInRam;
    }

    public static int getDefaultMaxRecordsInRam() {
        return DEAFULT_MAX_RECORDS_IN_RAM;
    }

    @Override
    public void setProgressLogger(ProgressLoggerInterface progress) {
        this.progressLogger = progress;
    }

    public void setSortOrder(SAMFileHeader.SortOrder sortOrder, boolean presorted) {
        if (this.header != null) {
            throw new IllegalStateException("Cannot call SAMFileWriterImpl.setSortOrder after setHeader for " + this.getFilename());
        }
        this.sortOrder = sortOrder;
        this.presorted = presorted;
        this.setSortOrderChecking(this.sortOrderChecker != null);
    }

    @Override
    public void setSortOrderChecking(boolean check) {
        boolean doCheck = check && this.presorted && this.sortOrder != SAMFileHeader.SortOrder.unsorted && this.sortOrder != SAMFileHeader.SortOrder.unknown;
        this.sortOrderChecker = doCheck ? new SAMSortOrderChecker(this.sortOrder) : null;
    }

    protected SAMFileHeader.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    protected void setMaxRecordsInRam(int maxRecordsInRam) {
        if (this.header != null) {
            throw new IllegalStateException("setMaxRecordsInRam must be called before setHeader()");
        }
        this.maxRecordsInRam = maxRecordsInRam;
    }

    protected int getMaxRecordsInRam() {
        return this.maxRecordsInRam;
    }

    protected void setTempDirectory(File tmpDir) {
        if (tmpDir != null) {
            this.tmpDir = tmpDir;
        }
    }

    protected File getTempDirectory() {
        return this.tmpDir;
    }

    public void setHeader(SAMFileHeader header) {
        if (null == header) {
            throw new IllegalArgumentException("A non-null SAMFileHeader is required for a writer");
        }
        this.header = header;
        if (this.sortOrder == null) {
            this.sortOrder = SAMFileHeader.SortOrder.unsorted;
        }
        header.setSortOrder(this.sortOrder);
        this.writeHeader(header);
        if (this.presorted) {
            if (this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
                this.presorted = false;
            }
            this.setSortOrderChecking(true);
        } else if (!this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
            this.alignmentSorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(header), this.sortOrder.getComparatorInstance(), this.maxRecordsInRam, this.tmpDir);
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.header;
    }

    @Override
    public void addAlignment(SAMRecord alignment) {
        alignment.setHeaderStrict(this.header);
        if (this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
            this.writeAlignment(alignment);
        } else if (this.presorted) {
            this.assertPresorted(alignment);
            this.writeAlignment(alignment);
        } else {
            this.alignmentSorter.add(alignment);
        }
    }

    private void assertPresorted(SAMRecord alignment) {
        if (this.sortOrderChecker != null && !this.sortOrderChecker.isSorted(alignment)) {
            SAMRecord prev = this.sortOrderChecker.getPreviousRecord();
            throw new IllegalArgumentException("Alignments added out of order in SAMFileWriterImpl.addAlignment for " + this.getFilename() + ". Sort order is " + (Object)((Object)this.sortOrder) + ". Offending records are at [" + this.sortOrderChecker.getSortKey(prev) + "] and [" + this.sortOrderChecker.getSortKey(alignment) + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        block8: {
            try {
                if (this.isClosed) break block8;
                if (this.alignmentSorter != null) {
                    try {
                        for (SAMRecord alignment : this.alignmentSorter) {
                            this.writeAlignment(alignment);
                            if (this.progressLogger == null) continue;
                            this.progressLogger.record(alignment);
                        }
                    }
                    finally {
                        this.alignmentSorter.cleanup();
                    }
                }
                this.finish();
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    protected abstract void writeAlignment(SAMRecord var1);

    @Deprecated
    protected abstract void writeHeader(String var1);

    protected void writeHeader(SAMFileHeader header) {
        StringWriter headerTextBuffer = new StringWriter();
        new SAMTextHeaderCodec().encode(headerTextBuffer, header);
        this.writeHeader(headerTextBuffer.toString());
    }

    protected abstract void finish();

    protected abstract String getFilename();
}

