/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.BundleResourceBase;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.io.IOPath;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Optional;

public class IOPathResource
extends BundleResourceBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IOPath ioPath;

    public IOPathResource(IOPath ioPath, String contentType) {
        this(ioPath, contentType, null);
    }

    public IOPathResource(IOPath ioPath, String contentType, String format) {
        super(ValidationUtils.nonNull(ioPath, "ioPath").getRawInputString(), contentType, format);
        this.ioPath = ioPath;
    }

    @Override
    public Optional<IOPath> getIOPath() {
        return Optional.of(this.ioPath);
    }

    @Override
    public Optional<InputStream> getInputStream() {
        return Optional.of(this.ioPath.getInputStream());
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        return Optional.of(this.ioPath.getOutputStream());
    }

    @Override
    public boolean hasInputType() {
        return true;
    }

    @Override
    public boolean hasOutputType() {
        return true;
    }

    @Override
    public boolean hasSeekableStream() {
        return this.ioPath.hasFileSystemProvider();
    }

    @Override
    public Optional<SeekableStream> getSeekableStream() {
        if (!this.hasSeekableStream()) {
            throw new IllegalArgumentException(String.format("A SeekableStream cannot be obtained for a URI (%s) for which no file system provider is installed", this.getIOPath().get().getURI()));
        }
        try {
            return Optional.of(new SeekablePathStream(this.getIOPath().get().toPath()));
        }
        catch (IOException e) {
            throw new HtsjdkIOException(this.toString(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SignatureStream getSignatureStream(int signatureProbeLength) {
        ValidationUtils.validateArg(signatureProbeLength > 0, "signature probe length size must be > 0");
        try (InputStream inputStream = this.getInputStream().get();){
            byte[] signaturePrefix = new byte[signatureProbeLength];
            inputStream.read(signaturePrefix);
            SignatureStream signatureStream = new SignatureStream(signatureProbeLength, signaturePrefix);
            return signatureStream;
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Error getting a signature probe stream with probe length %d", signatureProbeLength), e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IOPathResource that = (IOPathResource)o;
        return this.ioPath.equals(that.ioPath);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ioPath.hashCode();
        return result;
    }
}

