/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGVDialog;
import org.jdesktop.layout.GroupLayout;

public class DataRangeDialog
extends IGVDialog {
    private boolean canceled;
    private float min;
    private float base;
    private float max;
    private boolean isLog;
    private JTextField baseTextField;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField maxTextField;
    private JTextField minTextField;
    private JButton okButton;
    private JCheckBox isLogCheckBox;
    private JLabel isLogLabel;

    public DataRangeDialog(Frame parent, DataRange axisDefinition) {
        super(parent, true);
        this.setLocationRelativeTo(parent);
        this.initComponents();
        if (axisDefinition != null) {
            this.min = axisDefinition.getMinimum();
            this.base = axisDefinition.getBaseline();
            this.max = axisDefinition.getMaximum();
            this.isLogCheckBox.setSelected(axisDefinition.isLog());
            this.minTextField.setText(String.valueOf(this.min));
            this.baseTextField.setText(String.valueOf(this.base));
            this.maxTextField.setText(String.valueOf(this.max));
        }
    }

    public void setHideMid(boolean hideMid) {
        this.baseTextField.setVisible(!hideMid);
        this.jLabel3.setVisible(!hideMid);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.minTextField = new JTextField();
        this.baseTextField = new JTextField();
        this.maxTextField = new JTextField();
        this.okButton = new JButton();
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton();
        this.isLogCheckBox = new JCheckBox();
        this.isLogLabel = new JLabel("Log scale");
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Range");
        this.jLabel1.setFont(FontManager.getFont(1, 12));
        this.jLabel1.setText("Data Range");
        this.jLabel2.setText("Min");
        this.jLabel3.setText("Mid");
        this.jLabel4.setText("Max");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataRangeDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataRangeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(38, 38, 38).add((Component)this.jLabel1, -2, 299, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(77, 77, 77).add((Component)this.cancelButton).add(31, 31, 31).add((Component)this.okButton)).add((GroupLayout.Group)layout.createSequentialGroup().add(63, 63, 63).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4).add((Component)this.isLogLabel)).add(83, 83, 83).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.maxTextField, -2, 97, -2).add((Component)this.baseTextField, -2, 97, -2).add((Component)this.minTextField, -2, 97, -2).add((Component)this.isLogCheckBox, -2, 97, -2))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 27, -2).add(33, 33, 33).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).add(18, 18, 18).add((Component)this.jLabel3)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.minTextField, -2, -1, -2).addPreferredGap(0).add((Component)this.baseTextField, -2, -1, -2))).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.maxTextField, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.isLogLabel).add((Component)this.isLogCheckBox, -2, -1, -2)).addPreferredGap(0, 77, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.okButton)).add(54, 54, 54)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.convertParms()) {
            this.setVisible(false);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.setVisible(false);
    }

    private boolean convertParms() {
        try {
            this.min = Float.valueOf(this.minTextField.getText()).floatValue();
            this.max = Float.valueOf(this.maxTextField.getText()).floatValue();
            this.base = Float.valueOf(this.baseTextField.getText()).floatValue();
            this.isLog = this.isLogCheckBox.isSelected();
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Min, base, and max must be numeric values");
            return false;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataRangeDialog dialog = new DataRangeDialog((Frame)new JFrame(), null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public float getMin() {
        return this.min;
    }

    public float getBase() {
        return this.base;
    }

    public float getMax() {
        return this.max;
    }

    public boolean isLog() {
        return this.isLog;
    }

    public DataRange.Type getDataRangeType() {
        return this.isLog() ? DataRange.Type.LOG : DataRange.Type.LINEAR;
    }
}

