/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.HttpUtils;

public class GenomeDescriptor {
    public static final String GENOME_ARCHIVE_VERSION_KEY = "version";
    public static final String GENOME_ARCHIVE_PROPERTY_FILE_NAME = "property.txt";
    public static final String GENOME_ARCHIVE_ID_KEY = "id";
    public static final String GENOME_ARCHIVE_NAME_KEY = "name";
    public static final String GENOME_ORDERED_KEY = "ordered";
    public static final String GENOME_GENETRACK_NAME = "geneTrackName";
    public static final String GENOME_URL_KEY = "url";
    public static final String GENOME_ARCHIVE_CYTOBAND_FILE_KEY = "cytobandFile";
    public static final String GENOME_ARCHIVE_GENE_FILE_KEY = "geneFile";
    public static final String GENOME_ARCHIVE_SEQUENCE_FILE_LOCATION_KEY = "sequenceLocation";
    public static final String COMPRESSED_SEQUENCE_PATH = "compressedSequencePath";
    public static final String GENOME_CHR_ALIAS_FILE_KEY = "chrAliasFile";
    public static final String SEQUENCE_MAP_FILE = "sequenceMap.txt";
    private static Logger log = LogManager.getLogger(GenomeDescriptor.class);
    private Map<String, ZipEntry> zipEntries;
    private ZipFile genomeZipFile;
    private String id;
    private String name;
    protected String cytoBandFileName;
    protected String geneFileName;
    protected String chrAliasFileName;
    private String geneTrackName;
    private String url;
    private String sequencePath;
    private String compressedSequencePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenomeDescriptor parseGenomeArchiveFile(File archiveFile) throws IOException {
        if (!archiveFile.exists()) {
            throw new FileNotFoundException("Genome file: " + archiveFile.getAbsolutePath() + " does not exist.");
        }
        GenomeDescriptor genomeDescriptor = null;
        HashMap<String, ZipEntry> zipEntries = new HashMap<String, ZipEntry>();
        ZipFile zipFile = new ZipFile(archiveFile);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(archiveFile);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                zipEntries.put(zipEntryName, zipEntry);
                zipEntry = zipInputStream.getNextEntry();
            }
            zipEntry = (ZipEntry)zipEntries.get(GENOME_ARCHIVE_PROPERTY_FILE_NAME);
            if (zipEntry != null) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Properties properties = new Properties();
                properties.load(inputStream);
                String sequencePath = properties.getProperty(GENOME_ARCHIVE_SEQUENCE_FILE_LOCATION_KEY);
                String compressedSequencePath = properties.getProperty(COMPRESSED_SEQUENCE_PATH);
                if (sequencePath != null && !HttpUtils.isRemoteURL(sequencePath)) {
                    sequencePath = GenomeDescriptor.getFullPath(archiveFile, sequencePath);
                }
                if (compressedSequencePath != null && !HttpUtils.isRemoteURL(compressedSequencePath)) {
                    compressedSequencePath = GenomeDescriptor.getFullPath(archiveFile, sequencePath);
                }
                genomeDescriptor = new GenomeDescriptor();
                genomeDescriptor.name = properties.getProperty(GENOME_ARCHIVE_NAME_KEY);
                genomeDescriptor.id = properties.getProperty(GENOME_ARCHIVE_ID_KEY);
                genomeDescriptor.cytoBandFileName = properties.getProperty(GENOME_ARCHIVE_CYTOBAND_FILE_KEY);
                genomeDescriptor.geneFileName = properties.getProperty(GENOME_ARCHIVE_GENE_FILE_KEY);
                genomeDescriptor.chrAliasFileName = properties.getProperty(GENOME_CHR_ALIAS_FILE_KEY);
                genomeDescriptor.geneTrackName = properties.getProperty(GENOME_GENETRACK_NAME, "Gene");
                genomeDescriptor.sequencePath = sequencePath;
                genomeDescriptor.compressedSequencePath = compressedSequencePath;
                genomeDescriptor.zipEntries = zipEntries;
                genomeDescriptor.genomeZipFile = zipFile;
                genomeDescriptor.url = properties.getProperty(GENOME_URL_KEY);
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing imported genome zip stream!", ex);
            }
        }
        return genomeDescriptor;
    }

    static String getFullPath(File f, String sequencePath) throws IOException {
        boolean isAbsolutePath;
        File sequenceFolder = null;
        sequenceFolder = new File(sequencePath);
        boolean bl = isAbsolutePath = sequenceFolder.isAbsolute() || sequencePath.startsWith("/") || sequencePath.startsWith("\\");
        if (!isAbsolutePath) {
            sequenceFolder = new File(f.getParent(), sequencePath);
        }
        sequencePath = sequenceFolder.getCanonicalPath();
        sequencePath.replace('\\', '/');
        return sequencePath;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getGeneFileName() {
        return this.geneFileName;
    }

    public String getGeneTrackName() {
        return this.geneTrackName;
    }

    public String getSequencePath() {
        return this.compressedSequencePath == null ? this.sequencePath : this.compressedSequencePath;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasCytobands() {
        return this.cytoBandFileName != null && this.cytoBandFileName.length() > 0;
    }

    public InputStream getCytoBandStream() throws IOException {
        String fileName = this.cytoBandFileName;
        if (fileName == null) {
            return null;
        }
        boolean isGZipped = fileName.toLowerCase().endsWith(".gz");
        InputStream is = this.genomeZipFile.getInputStream(this.zipEntries.get(fileName));
        return isGZipped ? new GZIPInputStream(is) : is;
    }

    public InputStream getGeneStream() throws IOException {
        if (this.geneFileName == null) {
            return null;
        }
        InputStream is = this.genomeZipFile.getInputStream(this.zipEntries.get(this.geneFileName));
        return this.geneFileName.endsWith(".gz") ? new GZIPInputStream(is) : is;
    }

    public InputStream getChrAliasStream() throws IOException {
        String fileName = this.chrAliasFileName;
        if (fileName == null || !this.zipEntries.containsKey(fileName)) {
            return null;
        }
        return this.genomeZipFile.getInputStream(this.zipEntries.get(fileName));
    }

    public void close() {
        try {
            this.genomeZipFile.close();
        }
        catch (IOException e) {
            log.error("Error closing genomeZipFile", e);
        }
    }
}

