/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BedData;
import org.broad.igv.bbfile.BigBedDataBlock;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;

public class BigBedIterator
implements Iterator<BedData> {
    private static Logger log = LogManager.getLogger(BigBedIterator.class);
    private BBFileHeader header;
    private RPChromosomeRegion selectionRegion;
    private boolean contained;
    private SeekableStream fis;
    private BPTree chromIDTree;
    private RPTree chromDataTree;
    private Map<Integer, String> chromosomeMap;
    List<BedData> features;
    int currentIdx = 0;

    public BigBedIterator(SeekableStream fis, BBFileHeader header, BPTree chromIDTree, RPTree chromDataTree, RPChromosomeRegion selectionRegion, boolean contained) {
        if (selectionRegion == null) {
            throw new RuntimeException("Error: BigBedIterator selection region is null\n");
        }
        this.header = header;
        this.fis = fis;
        this.chromIDTree = chromIDTree;
        this.chromDataTree = chromDataTree;
        this.selectionRegion = selectionRegion;
        this.contained = contained;
        ArrayList<RPTreeLeafNodeItem> leafNodeItems = chromDataTree.getChromosomeDataHits(selectionRegion, contained);
        this.features = new ArrayList<BedData>(512 * leafNodeItems.size());
        for (RPTreeLeafNodeItem item : leafNodeItems) {
            this.features.addAll(this.readBedDataBlock(item));
        }
    }

    public BigBedIterator() {
        this.features = Collections.emptyList();
    }

    @Override
    public boolean hasNext() {
        return this.currentIdx < this.features.size();
    }

    @Override
    public BedData next() {
        BedData retvalue = this.features.get(this.currentIdx);
        ++this.currentIdx;
        return retvalue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove iterator item is not supported yet.");
    }

    public boolean isContained() {
        return this.contained;
    }

    private List<BedData> readBedDataBlock(RPTreeLeafNodeItem leafHitItem) {
        int startChromID = leafHitItem.getChromosomeBounds().getStartChromID();
        int endChromID = leafHitItem.getChromosomeBounds().getEndChromID();
        this.chromosomeMap = this.chromIDTree.getChromosomeIDMap(startChromID, endChromID);
        boolean isLowToHigh = this.chromDataTree.isIsLowToHigh();
        int uncompressBufSize = this.chromDataTree.getUncompressBuffSize();
        BigBedDataBlock bedDataBlock = new BigBedDataBlock(this.fis, this.header, leafHitItem, this.chromosomeMap, isLowToHigh, uncompressBufSize);
        return bedDataBlock.getBedData(this.selectionRegion, this.contained);
    }
}

