/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.htsget;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.broad.igv.htsget.HtsgetUtils;
import org.broad.igv.util.HttpUtils;

class HtsgetReader {
    private String url;
    private String format;

    static HtsgetReader getReader(HtsgetUtils.Metadata metadata) {
        String format = metadata.getFormat();
        return new HtsgetReader(metadata.getUrl(), format);
    }

    HtsgetReader(String url, String format) {
        this.url = url;
        this.format = format.toUpperCase();
    }

    byte[] readHeader() throws IOException {
        URL headerURL = HtsgetUtils.addQueryString(this.url, "class=header&format=" + this.format);
        String ticketString = HttpUtils.getInstance().getContentsAsJSON(headerURL);
        JsonParser parser = new JsonParser();
        JsonObject ticket = parser.parse(ticketString).getAsJsonObject();
        return this.loadURLs(ticket);
    }

    byte[] readData(String chr, int start, int end) throws IOException {
        String queryString = "format=" + this.format + "&referenceName=" + chr + "&start=" + start + "&end=" + end;
        URL queryURL = HtsgetUtils.addQueryString(this.url, queryString);
        String ticketString = HttpUtils.getInstance().getContentsAsJSON(queryURL);
        JsonParser parser = new JsonParser();
        JsonObject ticket = parser.parse(ticketString).getAsJsonObject();
        return this.loadURLs(ticket);
    }

    private byte[] loadURLs(JsonObject ticket) throws IOException {
        JsonObject container = ticket.getAsJsonObject("htsget");
        JsonArray urls = container.get("urls").getAsJsonArray();
        Iterator iter = urls.iterator();
        byte[] bytes = null;
        while (iter.hasNext()) {
            JsonObject next = ((JsonElement)iter.next()).getAsJsonObject();
            String urlString = next.get("url").getAsString();
            if (urlString.startsWith("data:")) {
                throw new RuntimeException("Data URLs are not currently supported");
            }
            URL url = new URL(urlString);
            HashMap<String, String> headers = new HashMap<String, String>();
            JsonObject headerObj = next.getAsJsonObject("headers");
            if (headerObj != null) {
                for (String key : headerObj.keySet()) {
                    headers.put(key, headerObj.get(key).getAsString());
                }
            }
            byte[] b = HttpUtils.getInstance().getContentsAsBytes(url, headers);
            if (bytes == null) {
                bytes = b;
                continue;
            }
            byte[] newBytes = new byte[bytes.length + b.length];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            System.arraycopy(b, 0, newBytes, bytes.length, b.length);
            bytes = newBytes;
        }
        return bytes;
    }
}

