/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Feature;
import htsjdk.tribble.TribbleException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broad.igv.event.DataLoadedEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.tools.motiffinder.MotifFinderSource;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrackUtils;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.variant.VariantTrack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FeatureTrack
extends AbstractTrack
implements IGVEventObserver {
    private static Logger log = LogManager.getLogger(FeatureTrack.class);
    public static final int MINIMUM_FEATURE_SPACING = 5;
    public static final int DEFAULT_MARGIN = 5;
    public static final int NO_FEATURE_ROW_SELECTED = -1;
    protected static final Color SELECTED_FEATURE_ROW_COLOR = new Color(100, 100, 100, 30);
    private static final int DEFAULT_EXPANDED_HEIGHT = 35;
    private static final int DEFAULT_SQUISHED_HEIGHT = 12;
    private int expandedRowHeight = 35;
    private int squishedRowHeight = 12;
    boolean fatalLoadError = false;
    Track.DisplayMode lastFeatureMode = null;
    protected Map<String, PackedFeatures<Feature>> packedFeaturesMap = Collections.synchronizedMap(new HashMap());
    protected Renderer renderer;
    private DataRenderer coverageRenderer;
    private boolean showFeatures = true;
    public FeatureSource source;
    protected int selectedFeatureRowIndex = -1;
    protected IGVFeature selectedFeature = null;
    int margin = 5;
    private static boolean drawBorder = true;
    private boolean alternateExonColor = false;
    private String trackLine = null;
    private boolean groupByStrand = false;

    public FeatureTrack() {
    }

    public FeatureTrack(ResourceLocator locator, String id, String name) {
        super(locator, id, name);
        this.setSortable(false);
    }

    public FeatureTrack(String id, String name, FeatureSource source) {
        super(null, id, name);
        this.init(null, source);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, String id, String name, FeatureSource source) {
        super(locator, id, name);
        this.init(locator, source);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, FeatureSource source) {
        super(locator);
        this.init(locator, source);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, String id, FeatureSource source) {
        super(locator, id, locator.getTrackName());
        this.init(locator, source);
    }

    public FeatureTrack(FeatureTrack featureTrack) {
        this(featureTrack.getId(), featureTrack.getName(), featureTrack.source);
    }

    protected void init(ResourceLocator locator, FeatureSource source) {
        Integer vizWindow;
        this.source = source;
        this.setMinimumHeight(10);
        this.coverageRenderer = new BarChartRenderer();
        Integer n = vizWindow = locator == null ? null : locator.getVisibilityWindow();
        if (vizWindow != null) {
            this.visibilityWindow = vizWindow;
        } else {
            int sourceFeatureWindowSize = source.getFeatureWindowSize();
            int defVisibilityWindow = PreferencesManager.getPreferences().getAsInt("DEFAULT_VISIBILITY_WINDOW");
            this.visibilityWindow = sourceFeatureWindowSize > 0 && defVisibilityWindow > 0 ? defVisibilityWindow * 1000 : sourceFeatureWindowSize;
        }
        this.renderer = locator != null && locator.getPath().endsWith("junctions.bed") ? new SpliceJunctionRenderer() : new IGVFeatureRenderer();
        IGVEventBus.getInstance().subscribe(DataLoadedEvent.class, this);
    }

    @Override
    public void unload() {
        super.unload();
        if (this.source != null) {
            this.source.close();
        }
    }

    @Override
    public void receiveEvent(Object e) {
        if (!(e instanceof DataLoadedEvent)) {
            log.warn("Unknown event type: " + e.getClass());
        }
    }

    @Override
    public int getHeight() {
        if (!this.isVisible()) {
            return 0;
        }
        int rowHeight = this.getDisplayMode() == Track.DisplayMode.SQUISHED ? this.squishedRowHeight : this.expandedRowHeight;
        int minHeight = this.margin + rowHeight * Math.max(1, this.getNumberOfFeatureLevels());
        return Math.max(minHeight, super.getHeight());
    }

    public int getExpandedRowHeight() {
        return this.expandedRowHeight;
    }

    public void setExpandedRowHeight(int expandedRowHeight) {
        this.expandedRowHeight = expandedRowHeight;
    }

    public int getSquishedRowHeight() {
        return this.squishedRowHeight;
    }

    public void setSquishedRowHeight(int squishedRowHeight) {
        this.squishedRowHeight = squishedRowHeight;
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            this.renderer = (Renderer)rc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            log.error("Error instatiating renderer ", ex);
        }
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    @Override
    public void setProperties(TrackProperties trackProperties) {
        super.setProperties(trackProperties);
        if (trackProperties.getFeatureVisibilityWindow() >= 0) {
            this.setVisibilityWindow(trackProperties.getFeatureVisibilityWindow());
        }
        this.alternateExonColor = trackProperties.isAlternateExonColor();
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    public int getNumberOfFeatureLevels() {
        if (this.packedFeaturesMap.size() > 0) {
            int n = 0;
            for (PackedFeatures<Feature> pf : this.packedFeaturesMap.values()) {
                if (pf == null) continue;
                n = Math.max(n, pf.getRowCount());
            }
            return n;
        }
        return 1;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType scoreType, String frameName) {
        try {
            Iterator features = this.source.getFeatures(chr, start, end);
            if (features != null) {
                if (scoreType == RegionScoreType.MUTATION_COUNT && this.getTrackType() == TrackType.MUTATION) {
                    Feature f;
                    int count = 0;
                    while (features.hasNext() && (f = (Feature)features.next()).getStart() <= end) {
                        if (f.getEnd() < start) continue;
                        ++count;
                    }
                    return count;
                }
                if (scoreType == RegionScoreType.SCORE) {
                    float regionScore = 0.0f;
                    int nValues = 0;
                    while (features.hasNext()) {
                        Feature f = (Feature)features.next();
                        if (!(f instanceof IGVFeature) || f.getEnd() < start || f.getStart() > end) continue;
                        float value = ((IGVFeature)f).getScore();
                        regionScore += value;
                        ++nValues;
                    }
                    if (nValues == 0) {
                        return -3.4028235E38f;
                    }
                    return regionScore / (float)nValues;
                }
            }
        }
        catch (IOException e) {
            log.error("Error counting features.", e);
        }
        return -3.4028235E38f;
    }

    @Override
    public Renderer getRenderer() {
        if (this.renderer == null) {
            this.setRendererClass(IGVFeatureRenderer.class);
        }
        return this.renderer;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        if (this.showFeatures) {
            List<Feature> allFeatures = this.getAllFeatureAt(position, mouseY, frame);
            if (allFeatures == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            boolean firstFeature = true;
            int maxNumber = 100;
            int n = 1;
            for (Feature feature : allFeatures) {
                if (feature != null && feature instanceof IGVFeature) {
                    String url;
                    if (!firstFeature) {
                        buf.append("<hr><br>");
                    }
                    IGVFeature igvFeature = (IGVFeature)feature;
                    String vs = igvFeature.getValueString(position, mouseX, null);
                    buf.append(vs);
                    if (IGV.getInstance().isShowDetailsOnClick() && (url = this.getFeatureURL(igvFeature)) != null) {
                        buf.append("<br/><a href=\"" + url + "\">" + url + "</a>");
                    }
                    firstFeature = false;
                    if (n > maxNumber) {
                        buf.append("...");
                        break;
                    }
                }
                ++n;
            }
            return buf.toString();
        }
        int zoom = Math.max(0, frame.getZoom());
        if (this.source == null) {
            return null;
        }
        List<LocusScore> scores = this.source.getCoverageScores(chr, (int)position - 10, (int)position + 10, zoom);
        if (scores == null) {
            return "";
        }
        double bpPerPixel = frame.getScale();
        int minWidth = (int)(2.0 * bpPerPixel);
        LocusScore score = FeatureUtils.getFeatureAt(position, minWidth, scores);
        return score == null ? null : "Mean count: " + score.getScore();
    }

    private String getFeatureURL(IGVFeature igvFeature) {
        String trackURL;
        String url = igvFeature.getURL();
        if (url == null && (trackURL = this.getUrl()) != null && igvFeature.getIdentifier() != null) {
            String encodedID = StringUtils.encodeURL(igvFeature.getIdentifier());
            url = trackURL.replaceAll("\\$\\$", encodedID);
        }
        return url;
    }

    public List<Feature> getFeatures(String chr, int start, int end) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        try {
            Iterator iter = this.source.getFeatures(chr, start, end);
            while (iter.hasNext()) {
                features.add((Feature)iter.next());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return features;
    }

    protected List<Feature> getAllFeatureAt(double position, int y, ReferenceFrame frame) {
        int featureRow = this.getFeatureRow(y);
        return this.getFeaturesAtPositionInFeatureRow(position, featureRow, frame);
    }

    private int getFeatureRow(int y) {
        int rowHeight;
        Track.DisplayMode mode = this.getDisplayMode();
        switch (mode) {
            case SQUISHED: {
                rowHeight = this.getSquishedRowHeight();
                break;
            }
            case EXPANDED: {
                rowHeight = this.getExpandedRowHeight();
                break;
            }
            default: {
                rowHeight = this.getHeight();
            }
        }
        return Math.max(0, (y - this.getY() - this.margin) / rowHeight);
    }

    public List<Feature> getFeaturesAtPositionInFeatureRow(double position, int featureRow, ReferenceFrame frame) {
        PackedFeatures<Feature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        if (packedFeatures == null) {
            return null;
        }
        List<PackedFeatures.FeatureRow> rows = packedFeatures.getRows();
        if (featureRow < 0 || featureRow >= rows.size()) {
            return null;
        }
        List<Object> possFeatures = this.getDisplayMode() == Track.DisplayMode.COLLAPSED ? packedFeatures.getFeatures() : rows.get(featureRow).getFeatures();
        List<Feature> featureList = null;
        if (possFeatures != null) {
            double bpPerPixel = frame.getScale();
            double minWidth = Math.max(0.5, 5.0 * bpPerPixel);
            int maxFeatureLength = packedFeatures.getMaxFeatureLength();
            featureList = FeatureUtils.getAllFeaturesAt(position, maxFeatureLength, minWidth, possFeatures);
        }
        return featureList;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return WindowFunction.count;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED) {
            int i = this.getFeatureRow(e.getY());
            if (i == this.selectedFeatureRowIndex) {
                this.setSelectedFeatureRowIndex(-1);
            } else {
                this.setSelected(true);
                this.setSelectedFeatureRowIndex(i);
            }
        }
        this.selectedFeature = null;
        Feature f = this.getFeatureAtMousePosition(te);
        if (f != null && f instanceof IGVFeature) {
            IGVFeature igvFeature = (IGVFeature)f;
            this.selectedFeature = this.selectedFeature != null && igvFeature.contains(this.selectedFeature) && this.selectedFeature.contains(igvFeature) ? null : igvFeature;
            if (IGV.getInstance().isShowDetailsOnClick()) {
                this.openTooltipWindow(te);
            } else {
                String url = this.getFeatureURL(igvFeature);
                if (url != null) {
                    try {
                        BrowserLauncher.openURL(url);
                    }
                    catch (IOException e1) {
                        log.error("Error launching url: " + url);
                    }
                    e.consume();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Feature getFeatureAtMousePosition(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        ReferenceFrame referenceFrame = te.getFrame();
        if (referenceFrame != null) {
            double location = referenceFrame.getChromosomePosition(e.getX());
            List<Feature> features = this.getAllFeatureAt(location, e.getY(), referenceFrame);
            return features != null && features.size() > 0 ? features.get(0) : null;
        }
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
        this.renderFeatures(context, rect);
    }

    @Override
    public void setDisplayMode(Track.DisplayMode mode) {
        this.lastFeatureMode = null;
        for (PackedFeatures<Feature> pf : this.packedFeaturesMap.values()) {
            pf.pack(mode, this.groupByStrand);
        }
        super.setDisplayMode(mode);
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        if (!this.isShowFeatures(frame)) {
            this.packedFeaturesMap.clear();
            return true;
        }
        PackedFeatures<Feature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        return packedFeatures != null && packedFeatures.containsInterval(chr, start, end);
    }

    @Override
    public void load(ReferenceFrame frame) {
        this.loadFeatures(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd(), frame.getName());
    }

    protected void loadFeatures(String chr, int start, int end, String frame) {
        if (this.source == null) {
            return;
        }
        try {
            Iterator iter;
            Chromosome c;
            Genome genome;
            int expandedEnd;
            int expandedStart;
            int vw = this.getVisibilityWindow();
            if (vw > 0) {
                int delta = Math.max(end - start, vw) / 2;
                int center = start / 2 + end / 2;
                expandedStart = center - delta;
                expandedEnd = center + delta;
                if (expandedEnd < 0) {
                    expandedEnd = Integer.MAX_VALUE;
                }
            } else {
                expandedStart = 0;
                expandedEnd = Integer.MAX_VALUE;
            }
            if (start >= 0) {
                expandedStart = Math.max(0, expandedStart);
            }
            if ((genome = GenomeManager.getInstance().getCurrentGenome()) != null && (c = genome.getChromosome(chr)) != null && end < c.getLength()) {
                expandedEnd = Math.min(c.getLength(), expandedEnd);
            }
            if ((iter = this.source.getFeatures(chr, expandedStart, expandedEnd)) == null) {
                PackedFeatures pf = new PackedFeatures(chr, expandedStart, expandedEnd);
                this.packedFeaturesMap.put(frame, pf);
            } else {
                PackedFeatures pf = new PackedFeatures(chr, expandedStart, expandedEnd, iter, this.getDisplayMode(), this.groupByStrand);
                this.packedFeaturesMap.put(frame, pf);
            }
        }
        catch (Exception e) {
            PackedFeatures pf = new PackedFeatures(chr, start, end);
            this.packedFeaturesMap.put(frame, pf);
            String msg = "Error loading features for interval: " + chr + ":" + start + "-" + end + " <br>" + e.toString();
            MessageUtils.showMessage(msg);
            log.error(msg, e);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        Rectangle renderRect = new Rectangle(rect);
        renderRect.y += this.margin;
        renderRect.height -= this.margin;
        this.showFeatures = this.isShowFeatures(context.getReferenceFrame());
        if (this.showFeatures) {
            if (this.lastFeatureMode != null) {
                super.setDisplayMode(this.lastFeatureMode);
                this.lastFeatureMode = null;
            }
            this.renderFeatures(context, renderRect);
        } else if (this.coverageRenderer != null) {
            if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED && !(this instanceof VariantTrack)) {
                this.lastFeatureMode = this.getDisplayMode();
                super.setDisplayMode(Track.DisplayMode.COLLAPSED);
            }
            this.renderCoverage(context, renderRect);
        }
        if (drawBorder) {
            Graphics2D borderGraphics = context.getGraphic2DForColor(UIConstants.TRACK_BORDER_GRAY);
            borderGraphics.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            borderGraphics.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        }
    }

    protected boolean isShowFeatures(ReferenceFrame frame) {
        if (frame.getChrName().equals("All")) {
            return false;
        }
        double windowSize = frame.getEnd() - frame.getOrigin();
        int vw = this.getVisibilityWindow();
        return vw <= 0 || windowSize <= (double)vw;
    }

    protected void renderCoverage(RenderContext context, Rectangle inputRect) {
        List<LocusScore> scores;
        String chr = context.getChr();
        List<LocusScore> list = scores = this.source != null && chr.equals("All") ? this.source.getCoverageScores(chr, (int)context.getOrigin(), (int)context.getEndLocation(), context.getZoom()) : null;
        if (scores == null) {
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            Rectangle textRect = new Rectangle(inputRect);
            textRect.height = Math.min(inputRect.height, 20);
            String message = this.getZoomInMessage(chr);
            GraphicUtils.drawCenteredText(message, textRect, g);
        } else {
            float max = this.getMaxEstimate(scores);
            ContinuousColorScale cs = this.getColorScale();
            if (cs != null) {
                cs.setPosEnd(max);
            }
            if (this.dataRange == null) {
                this.setDataRange(new DataRange(0.0f, 0.0f, max));
            } else {
                this.dataRange.maximum = max;
            }
            this.coverageRenderer.render(scores, context, inputRect, (Track)this);
        }
    }

    protected String getZoomInMessage(String chr) {
        return chr.equals("All") ? "Zoom in to see features." : "Zoom in to see features, or right-click to increase Feature Visibility Window.";
    }

    private float getMaxEstimate(List<LocusScore> scores) {
        float max = 0.0f;
        int n = Math.min(200, scores.size());
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, scores.get(i).getScore());
        }
        return max;
    }

    protected void renderFeatures(RenderContext context, Rectangle inputRect) {
        block5: {
            PackedFeatures<Feature> packedFeatures;
            if (log.isTraceEnabled()) {
                String msg = String.format("renderFeatures: %s frame: %s", this.getName(), context.getReferenceFrame().getName());
                log.trace(msg);
            }
            if ((packedFeatures = this.packedFeaturesMap.get(context.getReferenceFrame().getName())) == null || !packedFeatures.overlapsInterval(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation() + 1)) {
                return;
            }
            try {
                this.renderFeatureImpl(context, inputRect, packedFeatures);
            }
            catch (TribbleException e) {
                log.error("Tribble error", e);
                if (this.fatalLoadError) break block5;
                this.fatalLoadError = true;
                boolean unload = MessageUtils.confirm("<html> Error loading features: " + e.getMessage() + "<br>Unload track " + this.getName() + "?");
                if (unload) {
                    List<Track> tmp = Arrays.asList(this);
                    IGV.getInstance().deleteTracks(tmp);
                    IGV.getInstance().repaint();
                }
                this.fatalLoadError = false;
            }
        }
    }

    protected void renderFeatureImpl(RenderContext context, Rectangle inputRect, PackedFeatures packedFeatures) {
        Renderer renderer = this.getRenderer();
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            List features = packedFeatures.getFeatures();
            if (features != null) {
                renderer.render(features, context, inputRect, this);
            }
        } else {
            List<PackedFeatures.FeatureRow> rows = packedFeatures.getRows();
            if (rows != null && rows.size() > 0) {
                double h = this.getDisplayMode() == Track.DisplayMode.SQUISHED ? (double)this.squishedRowHeight : (double)this.expandedRowHeight;
                Rectangle rect = new Rectangle(inputRect.x, inputRect.y, inputRect.width, (int)h);
                int i = 0;
                if (renderer instanceof FeatureRenderer) {
                    ((FeatureRenderer)renderer).reset();
                }
                for (PackedFeatures.FeatureRow row : rows) {
                    renderer.render(row.features, context, new Rectangle(rect), this);
                    if (this.selectedFeatureRowIndex == i) {
                        Graphics2D fontGraphics = context.getGraphic2DForColor(SELECTED_FEATURE_ROW_COLOR);
                        fontGraphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                    }
                    rect.y = (int)((double)rect.y + h);
                    ++i;
                }
            }
        }
    }

    public Feature nextFeature(String chr, double center, boolean forward, ReferenceFrame frame) throws IOException {
        Feature f = null;
        boolean canScroll = forward && !frame.windowAtEnd() || !forward && frame.getOrigin() > 0.0;
        PackedFeatures<Feature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        double buffer = Math.max(1.0, frame.getScale());
        if (packedFeatures != null && packedFeatures.containsInterval(chr, (int)center - 1, (int)center + 1) && packedFeatures.getFeatures().size() > 0 && canScroll) {
            List<Feature> centerSortedFeatures = packedFeatures.getCenterSortedFeatures();
            Feature feature = f = forward ? FeatureUtils.getFeatureCenteredAfter(center + buffer, centerSortedFeatures) : FeatureUtils.getFeatureCenteredBefore(center - buffer, centerSortedFeatures);
        }
        if (f == null) {
            int searchBuferSize = (int)(frame.getScale() * 1000.0);
            f = FeatureTrackUtils.nextFeature(this.source, chr, packedFeatures.getStart(), packedFeatures.getEnd(), center, searchBuferSize, forward);
        }
        return f;
    }

    @Override
    public void setVisibilityWindow(int windowSize) {
        super.setVisibilityWindow(windowSize);
        this.packedFeaturesMap.clear();
    }

    public int getSelectedFeatureRowIndex() {
        return this.selectedFeatureRowIndex;
    }

    public void setSelectedFeatureRowIndex(int selectedFeatureRowIndex) {
        this.selectedFeatureRowIndex = selectedFeatureRowIndex;
    }

    public IGVFeature getSelectedFeature() {
        return this.selectedFeature;
    }

    public static boolean isDrawBorder() {
        return drawBorder;
    }

    public static void setDrawBorder(boolean drawBorder) {
        FeatureTrack.drawBorder = drawBorder;
    }

    public boolean isAlternateExonColor() {
        return this.alternateExonColor;
    }

    public void updateTrackReferences(List<Track> allTracks) {
    }

    public void clearPackedFeatures() {
        this.packedFeaturesMap.clear();
    }

    public List<Feature> getVisibleFeatures(ReferenceFrame frame) {
        PackedFeatures<Feature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        if (packedFeatures == null) {
            return Collections.emptyList();
        }
        Range currentRange = frame.getCurrentRange();
        return packedFeatures.getFeatures().stream().filter(igvFeature -> igvFeature.getEnd() >= currentRange.getStart() && igvFeature.getStart() <= currentRange.getEnd() && igvFeature.getChr().equals(currentRange.getChr())).collect(Collectors.toList());
    }

    public void setTrackLine(String trackLine) {
        this.trackLine = trackLine;
    }

    public String getExportTrackLine() {
        return this.trackLine;
    }

    public void setGroupByStrand(boolean selected) {
        this.groupByStrand = selected;
        for (PackedFeatures<Feature> pf : this.packedFeaturesMap.values()) {
            pf.pack(this.getDisplayMode(), this.groupByStrand);
        }
    }

    public boolean isGroupByStrand() {
        return this.groupByStrand;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        element.setAttribute("groupByStrand", String.valueOf(this.groupByStrand));
        super.marshalXML(document, element);
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        this.groupByStrand = "true".equals(element.getAttribute("groupByStrand"));
        NodeList tmp = element.getElementsByTagName("SequenceMatchSource");
        if (tmp.getLength() > 0) {
            Element sourceElement = (Element)tmp.item(0);
            MotifFinderSource source = new MotifFinderSource();
            source.unmarshalXML(sourceElement, version);
            this.source = source;
        }
    }
}

