/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.awt.Color;
import java.util.List;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.util.collections.MultiMap;

public interface IGVFeature
extends LocusScore,
NamedFeature {
    public String getType();

    default public String getIdentifier() {
        return null;
    }

    public String getDescription();

    default public Strand getStrand() {
        return Strand.NONE;
    }

    default public int getLength() {
        return this.getEnd() - this.getStart();
    }

    default public MultiMap<String, String> getAttributes() {
        return null;
    }

    default public boolean contains(IGVFeature feature) {
        if (feature == null) {
            return false;
        }
        if (!this.getChr().equals(feature.getChr()) || this.getStrand() != feature.getStrand()) {
            return false;
        }
        return feature.getStart() >= this.getStart() && feature.getEnd() <= this.getEnd();
    }

    default public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    default public List<Exon> getExons() {
        return null;
    }

    public Color getColor();

    default public String getURL() {
        return null;
    }
}

