/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import htsjdk.tribble.Feature;
import java.awt.Color;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.collections.MultiMap;

public abstract class AbstractFeature
implements IGVFeature,
Feature {
    private static Logger log = LogManager.getLogger(AbstractFeature.class);
    protected Strand strand = Strand.NONE;
    protected String chr;
    protected int start = -1;
    protected int end = -1;
    protected String type = "";
    protected Color color;
    protected String description;
    protected MultiMap<String, String> attributes;
    protected String name = "";
    protected int readingFrame = -1;

    public AbstractFeature() {
    }

    public AbstractFeature(String chr, int start, int end, Strand strand) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.strand = strand;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean hasExons() {
        return false;
    }

    @Override
    public float getScore() {
        return Float.NaN;
    }

    public String getChr() {
        return this.chr;
    }

    public String getContig() {
        return this.chr;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand strand) {
        this.strand = strand;
    }

    public boolean hasStrand() {
        return this.strand != null && this.strand != Strand.NONE;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String[] rgb, int nTokens) {
        try {
            if (nTokens < 3) {
                if (rgb[0].equals(".")) {
                    return;
                }
                this.color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[0]), Integer.parseInt(rgb[0]));
            } else {
                this.color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description == null ? this.getName() : this.description;
    }

    @Override
    public MultiMap<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(MultiMap<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new MultiMap();
        }
        this.attributes.put(key, value);
    }

    public boolean overlaps(Feature anotherFeature) {
        return this.end >= anotherFeature.getStart() && this.start <= anotherFeature.getEnd() && this.chr.equals(anotherFeature.getChr());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setChr(String chromosome) {
        this.chr = chromosome;
    }

    public String getLocusString() {
        return this.getChr() + ":" + (this.getStart() + 1) + "-" + this.getEnd();
    }

    protected String getAttributeString() {
        StringBuffer buf = new StringBuffer();
        int max = IGV.getInstance().isShowDetailsOnClick() ? 10000 : 30;
        this.attributes.printHtml(buf, max);
        return buf.toString();
    }

    public void setReadingFrame(int frame) {
        this.readingFrame = frame;
    }

    public int getReadingFrame() {
        return this.readingFrame;
    }
}

