/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile.codecs;

import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.codecs.BBBedCodec;
import org.broad.igv.feature.EncodePeakFeature;
import org.broad.igv.feature.Strand;

public class BBNarowPeakCodec
extends BBBedCodec {
    public BBNarowPeakCodec(int standardFieldCount) {
        super(standardFieldCount);
    }

    @Override
    public EncodePeakFeature decode(BedFeature feat) {
        int strandChar;
        EncodePeakFeature feature = new EncodePeakFeature(feat.getChromosome(), feat.getStartBase(), feat.getEndBase());
        String[] restOfFields = feat.getRestOfFields();
        feature.setName(restOfFields[0]);
        feature.setScore(Float.parseFloat(restOfFields[1]));
        String strandString = restOfFields[2].trim();
        int n = strandChar = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        Strand strand = strandChar == 45 ? Strand.NEGATIVE : (strandChar == 43 ? Strand.POSITIVE : Strand.NONE);
        feature.setStrand(strand);
        feature.setSignal((float)Double.parseDouble(restOfFields[3]));
        feature.setPValue((float)Double.parseDouble(restOfFields[4]));
        feature.setQValue((float)Double.parseDouble(restOfFields[5]));
        feature.setPeakPosition(Integer.parseInt(restOfFields[6]));
        return feature;
    }
}

