/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.expression;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.data.expression.ProbeToLocusMap;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.session.Session;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ParsingUtils;

public class GeneToLocusHelper {
    private static Logger log = LogManager.getLogger(GeneToLocusHelper.class);
    static String LOCUS_START_DELIMITER = "|@";
    static String LOCUS_END_DELIMITER = "|";
    Map<String, List<Locus>> probeLocusMap;

    public GeneToLocusHelper(String probeResource) throws IOException {
        String userMappingFile;
        boolean use_probe_mf;
        if (probeResource != null && probeResource.trim().length() > 0) {
            this.loadProbeMap(probeResource);
        }
        if (!Globals.isHeadless()) {
            Session session = IGV.getInstance().getSession();
            use_probe_mf = session.getPreferenceAsBoolean("USE_PROBE_MAPPING_FILE");
            userMappingFile = session.getPreference("PROBE_MAPPING_FILE");
        } else {
            use_probe_mf = PreferencesManager.getPreferences().getAsBoolean("USE_PROBE_MAPPING_FILE");
            userMappingFile = PreferencesManager.getPreferences().get("PROBE_MAPPING_FILE");
        }
        if (use_probe_mf && userMappingFile != null && userMappingFile.trim().length() > 0) {
            this.loadProbeMap(userMappingFile);
        }
    }

    public List<Locus> getLoci(String probeId, String description, String genomeId) {
        String[] locusStrings;
        if (this.probeLocusMap != null) {
            return this.probeLocusMap.get(probeId);
        }
        if (description != null && description.length() > 3 && (locusStrings = this.getExplicitLocusStrings(description)) != null) {
            ArrayList<Locus> loci = new ArrayList<Locus>(locusStrings.length);
            for (String ls : locusStrings) {
                Locus locus = this.getLocus(ls = ls.trim());
                if (locus == null || !locus.isValid()) continue;
                loci.add(locus);
            }
            return loci;
        }
        Locus locus = this.getLocus(probeId);
        if (locus != null && locus.isValid()) {
            return Arrays.asList(locus);
        }
        String[] genes = ProbeToLocusMap.getInstance().getLociForProbe(probeId, genomeId);
        if (genes != null) {
            ArrayList<Locus> loci = new ArrayList<Locus>(genes.length);
            for (String g : genes) {
                locus = this.getLocus(g);
                if (locus == null) continue;
                loci.add(locus);
            }
            return loci;
        }
        return null;
    }

    private String[] getExplicitLocusStrings(String description) {
        int startIndex = description.indexOf(LOCUS_START_DELIMITER);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = description.indexOf(LOCUS_END_DELIMITER, (startIndex += 2) + 1);
        if (endIndex < 0) {
            endIndex = description.length();
        }
        if (endIndex > startIndex + 3) {
            String locusString = description.substring(startIndex, endIndex);
            if (locusString.contains(",")) {
                return locusString.split(",");
            }
            return new String[]{locusString};
        }
        return null;
    }

    Locus getLocus(String geneOrLocusString) {
        Locus locus = Locus.fromString(geneOrLocusString);
        if (locus != null && locus.isValid()) {
            return locus;
        }
        NamedFeature gene = FeatureDB.getFeature(geneOrLocusString);
        if (gene != null) {
            return new Locus(gene.getChr(), gene.getStart(), gene.getEnd());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProbeMap(String probeResource) {
        BufferedReader reader = null;
        try {
            String nextLine;
            this.probeLocusMap = new HashMap<String, List<Locus>>(50000);
            int maxErrors = 10;
            int errorCount = 0;
            reader = ParsingUtils.openBufferedReader(probeResource);
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                if (nextLine.startsWith("#") || nextLine.startsWith("browser") || nextLine.startsWith("track") || (tokens = Globals.tabPattern.split(nextLine, -1)).length <= 3) continue;
                try {
                    String chr = tokens[0];
                    int start = (int)Double.parseDouble(tokens[1]);
                    int end = (int)Double.parseDouble(tokens[2]);
                    String probe = tokens[3];
                    Locus locus = new Locus(chr, start, end);
                    this.probeLocusMap.put(probe, Arrays.asList(locus));
                }
                catch (NumberFormatException e) {
                    log.warn("Skipping line: " + nextLine);
                    if (++errorCount <= maxErrors) continue;
                    this.probeLocusMap = null;
                    log.warn("Too many errors.  Aborting.");
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

