/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile.codecs;

import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.codecs.BBBedCodec;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;

public class BBGenePredCodec
extends BBBedCodec {
    public BBGenePredCodec(int standardFieldCount) {
        super(standardFieldCount);
    }

    @Override
    public BasicFeature decode(BedFeature feat) {
        BasicFeature feature = super.decode(feat);
        String[] restOfFields = feat.getRestOfFields();
        String exonFrames = restOfFields[12];
        String[] frameBuffer = Globals.commaPattern.split(exonFrames);
        List<Exon> exons = feature.getExons();
        for (int i = 0; i < frameBuffer.length; ++i) {
            int exonFrame = Integer.parseInt(frameBuffer[i].trim());
            if (exonFrame == -1) {
                exons.get(i).setNonCoding(true);
                continue;
            }
            exons.get(i).setReadingFrame(exonFrame);
        }
        return feature;
    }
}

