/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.broad.igv.DirectoryManager;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;

public class RemoveGenomesDialog
extends JDialog {
    private static Logger log = LogManager.getLogger(RemoveGenomesDialog.class);
    private List<GenomeListItem> allListItems;
    private boolean haveLocalSequence = false;
    private static final String LOCAL_SEQUENCE_CHAR = "*";
    private JPanel dialogPane;
    private JTextArea label1;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JList<GenomeListItem> genomeList;
    private JLabel label2;
    private JPanel panel1;
    private JPanel addRemBar;
    private JSeparator separator1;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public RemoveGenomesDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.initData();
        this.genomeList.setCellRenderer(new GenomeCellRenderer());
    }

    private void initData() {
        this.allListItems = new ArrayList<GenomeListItem>(GenomeListManager.getInstance().getGenomeListItems());
        for (GenomeListItem item : this.allListItems) {
            GenomeManager.getInstance();
            if (GenomeManager.getLocalFasta(item.getId()) == null) continue;
            this.haveLocalSequence = true;
            break;
        }
        this.buildList();
        this.label2.setVisible(this.haveLocalSequence);
    }

    private void buildList() {
        String currentId = GenomeManager.getInstance().getGenomeId();
        List<GenomeListItem> filteredList = this.allListItems.stream().filter(item -> !item.getId().equals(currentId)).collect(Collectors.toList());
        this.genomeList.setListData((GenomeListItem[])filteredList.toArray(new GenomeListItem[0]));
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void saveButtonActionPerformed(ActionEvent event) {
        Runnable runnable = () -> {
            List<GenomeListItem> selectedValuesList = this.genomeList.getSelectedValuesList();
            if (selectedValuesList != null && !selectedValuesList.isEmpty()) {
                try {
                    this.deleteDownloadedGenomes(selectedValuesList);
                }
                catch (IOException e) {
                    log.error("Error deleting genome files", e);
                    MessageUtils.showErrorMessage("Error deleting genome files", e);
                }
                String lastGenomeKey = PreferencesManager.getPreferences().get("DEFAULT_GENOME_KEY");
                for (GenomeListItem item : selectedValuesList) {
                    if (!lastGenomeKey.equals(item.getId())) continue;
                    PreferencesManager.getPreferences().remove("DEFAULT_GENOME_KEY");
                    break;
                }
            }
            if (selectedValuesList.size() > 0) {
                IGVEventBus.getInstance().post(new GenomeResetEvent());
            }
        };
        LongRunningTask.submit(runnable);
        this.setVisible(false);
    }

    public void deleteDownloadedGenomes(List<GenomeListItem> removedValuesList) throws IOException {
        for (GenomeListItem item : removedValuesList) {
            String loc = item.getPath();
            File genFile = new File(loc);
            if (DirectoryManager.isChildOf(DirectoryManager.getGenomeCacheDirectory(), genFile)) {
                genFile.delete();
            }
            GenomeManager.getInstance();
            File localFasta = GenomeManager.getLocalFasta(item.getId());
            if (localFasta == null) continue;
            GenomeManager.getInstance();
            GenomeManager.removeLocalFasta(item.getId());
            if (!DirectoryManager.isChildOf(DirectoryManager.getGenomeCacheDirectory(), localFasta) || !MessageUtils.confirm("Delete fasta file: " + localFasta.getAbsolutePath() + "?")) continue;
            localFasta.delete();
            File indexFile = new File(localFasta.getAbsolutePath() + ".fai");
            if (!indexFile.exists()) continue;
            indexFile.delete();
        }
        GenomeListManager.getInstance().removeAllItems(removedValuesList);
    }

    private void removeSelected() {
        List<GenomeListItem> selectedValuesList = this.genomeList.getSelectedValuesList();
        this.allListItems.removeAll(selectedValuesList);
        this.buildList();
    }

    private void genomeListKeyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
            this.removeSelected();
        }
    }

    private void removeButtonActionPerformed(ActionEvent e) {
        this.removeSelected();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.label1 = new JTextArea();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.genomeList = new JList();
        this.label2 = new JLabel();
        this.panel1 = new JPanel();
        this.addRemBar = new JPanel();
        this.separator1 = new JSeparator();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle("Remove Genomes");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(270, 400));
        this.dialogPane.setLayout(new BorderLayout());
        this.label1.setRows(2);
        this.label1.setEditable(false);
        this.label1.setBackground(UIManager.getColor("Button.background"));
        this.label1.setWrapStyleWord(true);
        this.label1.setLineWrap(true);
        this.dialogPane.add((Component)this.label1, "North");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.genomeList.setMaximumSize(new Dimension(39, 5000));
        this.genomeList.setDropMode(DropMode.INSERT);
        this.genomeList.setDragEnabled(true);
        this.genomeList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                RemoveGenomesDialog.this.genomeListKeyReleased(e);
            }
        });
        this.scrollPane1.setViewportView(this.genomeList);
        this.contentPanel.add(this.scrollPane1);
        this.label2.setText("Sequence on local machine");
        this.label2.setLabelFor(this.genomeList);
        this.label2.setAlignmentX(1.0f);
        this.label2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.label2.setPreferredSize(new Dimension(400, 16));
        this.label2.setMaximumSize(new Dimension(400, 16));
        this.label2.setMinimumSize(new Dimension(100, 16));
        this.label2.setText(LOCAL_SEQUENCE_CHAR + this.label2.getText());
        this.contentPanel.add(this.label2);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.panel1.setLayout(new BoxLayout(this.panel1, 1));
        this.addRemBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.addRemBar.setPreferredSize(new Dimension(196, 51));
        this.addRemBar.setMinimumSize(new Dimension(201, 51));
        this.addRemBar.setLayout(new FlowLayout(4, 1, 5));
        this.panel1.add(this.addRemBar);
        this.panel1.add(this.separator1);
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setPreferredSize(new Dimension(196, 51));
        this.buttonBar.setLayout(new FlowLayout(4));
        this.okButton.setText("Remove");
        this.okButton.setMaximumSize(new Dimension(93, 29));
        this.okButton.setMinimumSize(new Dimension(93, 29));
        this.okButton.setPreferredSize(new Dimension(93, 29));
        this.okButton.addActionListener(e -> this.saveButtonActionPerformed(e));
        this.buttonBar.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(93, 29));
        this.cancelButton.setPreferredSize(new Dimension(93, 29));
        this.cancelButton.setMaximumSize(new Dimension(93, 29));
        this.cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        this.buttonBar.add(this.cancelButton);
        this.panel1.add(this.buttonBar);
        this.dialogPane.add((Component)this.panel1, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class GenomeCellRenderer
    implements ListCellRenderer {
        private GenomeCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = new JLabel(value.toString());
            GenomeListItem item = (GenomeListItem)value;
            Object displayableName = item.getDisplayableName();
            comp.setToolTipText(item.getPath());
            if (isSelected) {
                comp.setBackground(RemoveGenomesDialog.this.genomeList.getSelectionBackground());
                comp.setForeground(RemoveGenomesDialog.this.genomeList.getSelectionForeground());
                comp.setOpaque(isSelected);
            }
            GenomeManager.getInstance();
            if (GenomeManager.getLocalFasta(item.getId()) != null) {
                displayableName = (String)displayableName + RemoveGenomesDialog.LOCAL_SEQUENCE_CHAR;
            }
            comp.setText((String)displayableName);
            return comp;
        }
    }
}

