/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.broad.igv.DirectoryManager;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.GenomeServerException;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.commandbar.GenomeSelectionDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.LongRunningTask;

public class GenomeComboBox
extends JComboBox<GenomeListItem> {
    private static Logger log = LogManager.getLogger(GenomeComboBox.class);

    public GenomeComboBox() {
        this.setRenderer(new ComboBoxRenderer());
        this.addActionListener(new GenomeBoxActionListener());
    }

    public void refreshGenomeListComboBox() {
        this.setModel(this.getModelForGenomeListComboBox());
        String curId = GenomeManager.getInstance().getGenomeId();
        GenomeListItem item = GenomeListManager.getInstance().getLoadedGenomeListItemById(curId);
        if (item != null) {
            this.setSelectedItem(item);
        }
    }

    public boolean hasItem(Object item) {
        int c = this.getItemCount();
        for (int i = 0; i < c; ++i) {
            if (!item.equals(this.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    private DefaultComboBoxModel getModelForGenomeListComboBox() {
        Collection<GenomeListItem> genomes;
        try {
            genomes = GenomeListManager.getInstance().getGenomeItemMap().values();
        }
        catch (IOException e) {
            log.error("Error reading genome list ", e);
            genomes = new ArrayList<GenomeListItem>();
            MessageUtils.showErrorMessage("Error reading genome list ", e);
        }
        Vector<GenomeListItem> vector = new Vector<GenomeListItem>(genomes);
        vector.sort(Comparator.comparing(GenomeListItem::getDisplayableName));
        vector.add(GenomeListItem.DOWNLOAD_ITEM);
        return new DefaultComboBoxModel<GenomeListItem>(vector);
    }

    public static void loadGenomeFromServer() {
        Runnable showDialog = () -> {
            List<GenomeListItem> inputListItems = GenomeListManager.getInstance().getServerGenomeList();
            if (inputListItems == null) {
                return;
            }
            GenomeSelectionDialog dialog = new GenomeSelectionDialog(IGV.getInstance().getMainFrame(), inputListItems);
            UIUtilities.invokeAndWaitOnEventThread(() -> dialog.setVisible(true));
            if (dialog.isCanceled()) {
                IGVEventBus.getInstance().post(new GenomeResetEvent());
            } else {
                List<GenomeListItem> selectedValueList = dialog.getSelectedValues();
                GenomeListItem firstItem = null;
                for (GenomeListItem selectedValue : selectedValueList) {
                    boolean success;
                    if (selectedValue == null || !(success = GenomeManager.getInstance().downloadGenome(selectedValue, dialog.downloadSequence()))) continue;
                    GenomeListManager.getInstance().addServerGenomeItem(selectedValue);
                    firstItem = selectedValue;
                }
                if (firstItem != null) {
                    try {
                        GenomeManager.getInstance().loadGenome(firstItem.getPath(), null);
                        GenomeListManager.getInstance().removeUserDefinedGenome(firstItem.getId());
                        if (firstItem.getPath().endsWith(".json")) {
                            GenomeComboBox.removeDotGenomeFile(firstItem.getId());
                        }
                    }
                    catch (IOException e) {
                        GenomeListManager.getInstance().removeGenomeListItem(firstItem);
                        MessageUtils.showErrorMessage("Error loading genome " + firstItem.getDisplayableName(), e);
                        log.error("Error loading genome " + firstItem.getDisplayableName(), e);
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            LongRunningTask.submit(showDialog);
        } else {
            showDialog.run();
        }
    }

    public static void removeDotGenomeFile(String id) {
        try {
            File dotGenomeFile = new File(DirectoryManager.getGenomeCacheDirectory(), id + ".genome");
            if (dotGenomeFile.exists()) {
                dotGenomeFile.delete();
            }
        }
        catch (Exception e) {
            log.error("Error deleting .genome file", e);
        }
    }

    static class ComboBoxRenderer
    implements ListCellRenderer {
        JSeparator separator = new JSeparator(0);

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value == null ? "" : value.toString();
            JLabel renderer = null;
            if ("--SEPARATOR--".equals(text)) {
                return this.separator;
            }
            if (text.equals("Remove Imported Genomes...")) {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            } else {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                label.setSize(label.getWidth() + 10, label.getHeight());
                renderer = label;
            }
            if (list != null) {
                if (isSelected) {
                    ((Component)renderer).setBackground(list.getSelectionBackground());
                    ((Component)renderer).setForeground(list.getSelectionForeground());
                } else {
                    ((Component)renderer).setBackground(list.getBackground());
                    ((Component)renderer).setForeground(list.getForeground());
                }
                ((Component)renderer).setFont(list.getFont());
            }
            return renderer;
        }
    }

    class GenomeBoxActionListener
    implements ActionListener {
        GenomeBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object selItem = GenomeComboBox.this.getSelectedItem();
            if (!(selItem instanceof GenomeListItem)) {
                return;
            }
            GenomeListItem genomeListItem = (GenomeListItem)selItem;
            this.loadGenomeListItem(genomeListItem);
        }

        private void loadGenomeListItem(final GenomeListItem genomeListItem) {
            if (genomeListItem.getId().equalsIgnoreCase(GenomeManager.getInstance().getGenomeId())) {
                return;
            }
            Runnable runnable = new Runnable(){
                ProgressMonitor monitor;
                ProgressBar.ProgressDialog progressDialog;

                @Override
                public void run() {
                    if (genomeListItem != null && genomeListItem.getPath() != null) {
                        if (genomeListItem == GenomeListItem.DOWNLOAD_ITEM) {
                            GenomeComboBox.loadGenomeFromServer();
                            return;
                        }
                        UIUtilities.invokeAndWaitOnEventThread(() -> {
                            this.monitor = new ProgressMonitor();
                            this.progressDialog = ProgressBar.showProgressDialog(IGV.getInstance().getMainFrame(), "Loading Genome...", this.monitor, false);
                        });
                        try {
                            GenomeManager.getInstance().loadGenomeById(genomeListItem.getId());
                        }
                        catch (GenomeServerException e) {
                            log.error("Error loading genome: " + genomeListItem.getId() + "  " + genomeListItem.getPath(), e);
                            JOptionPane.showMessageDialog(IGV.getInstance().getMainFrame(), "Error loading genome: " + genomeListItem.getDisplayableName());
                        }
                        catch (Exception e) {
                            log.error(e);
                            int choice = JOptionPane.showConfirmDialog(IGV.getInstance().getMainFrame(), "The genome [" + genomeListItem.getId() + "] could not be read. Would you like to remove the selected entry?", "", 2);
                            if (choice == 0) {
                                GenomeListManager.getInstance().removeGenomeListItem(genomeListItem);
                                GenomeComboBox.this.refreshGenomeListComboBox();
                                log.error("Error initializing genome", e);
                            }
                        }
                        finally {
                            if (this.progressDialog != null) {
                                UIUtilities.invokeOnEventThread(() -> this.progressDialog.setVisible(false));
                            }
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                LongRunningTask.submit(runnable);
            } else {
                runnable.run();
            }
        }
    }
}

