/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.aa.AminoAcidSequence;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.util.collections.MultiMap;

public class Mutation
implements IGVFeature {
    private static Logger log = LogManager.getLogger(Mutation.class);
    private static Map<String, Color> colors;
    private String sampleId;
    private String chr;
    private int start;
    private int end;
    private String name;
    private String omaName;
    private String mutationType;
    private Color color;
    String refAllele;
    String altAllele1;
    String altAllele2;
    private MultiMap<String, String> attributes;
    private String valueString;

    public Mutation(String runId, String chromosome, int start, int end, String type) {
        this.sampleId = runId;
        this.chr = chromosome;
        this.start = start;
        this.end = end;
        this.mutationType = type;
    }

    public Mutation(Mutation mutation) {
        this.sampleId = mutation.sampleId;
        this.chr = mutation.chr;
        this.start = mutation.start;
        this.end = mutation.end;
        this.mutationType = mutation.mutationType;
        this.color = mutation.color;
        this.name = mutation.getName();
        this.omaName = mutation.getOMAName();
    }

    private String getOMAName() {
        if (this.refAllele == null) {
            return null;
        }
        if (this.omaName == null) {
            String altAllele = this.altAllele1;
            if (this.refAllele.equals(this.altAllele1)) {
                altAllele = this.altAllele2;
            }
            String omaChr = this.chr.replace("chr", "");
            this.omaName = omaChr + "," + (this.start + 1) + "," + this.refAllele + "," + altAllele;
        }
        return this.omaName;
    }

    public String getOMAUrl() {
        if (this.refAllele == null) {
            return null;
        }
        String genome = IGV.getInstance().getGenomeManager().getGenomeId();
        String url = "http://mutationassessor.org/r3/?cm=var&var=" + genome + "," + this.getOMAName();
        return url;
    }

    public String getCravatLink() {
        String genomeID = IGV.getInstance().getGenomeManager().getGenomeId();
        if ("hg38".equals(genomeID) || "GRCh38".equals(genomeID)) {
            if (this.refAllele == null) {
                return null;
            }
            String altAllele = this.altAllele1;
            if (this.refAllele.equals(this.altAllele1)) {
                altAllele = this.altAllele2;
            }
            Object cravatChr = this.chr.startsWith("chr") ? this.chr : "chr" + this.chr;
            int position = this.start + 1;
            return "<a target='_blank' href='http://www.cravat.us/CRAVAT/variant.html?variant=" + (String)cravatChr + "_" + position + "_+_" + this.refAllele + "_" + altAllele + "'>Cravat " + this.refAllele + "->" + altAllele + "</a>";
        }
        return null;
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Mutation copy() {
        return new Mutation(this);
    }

    public String getSampleId() {
        return this.sampleId;
    }

    @Override
    public String getType() {
        return "mutation";
    }

    public String getMutationType() {
        return this.mutationType;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            StringBuffer buffer = new StringBuffer();
            DecimalFormat format = new DecimalFormat();
            String posString = format.format(this.start + 1);
            buffer.append(this.chr + ":" + posString);
            if (this.end > this.start + 1) {
                buffer.append("-" + this.end);
            }
            if (this.refAllele != null && this.altAllele1 != null) {
                if (!this.altAllele1.equals(this.refAllele)) {
                    buffer.append(" " + this.refAllele + ">" + this.altAllele1);
                }
                if (!this.altAllele1.equals(this.altAllele2) && !this.refAllele.equals(this.altAllele2)) {
                    buffer.append(" " + this.refAllele + ">" + this.altAllele2);
                }
            }
            this.name = buffer.toString();
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        StringBuffer desc = new StringBuffer();
        desc.append(this.getName());
        desc.append("<br>");
        desc.append(this.mutationType);
        return desc.toString();
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction ignored) {
        if (this.valueString == null) {
            String cravatLink;
            StringBuffer buf = new StringBuffer();
            buf.append("Type: ");
            buf.append(this.mutationType);
            if (this.attributes != null) {
                this.attributes.printHtml(buf, 100);
            }
            if (this.getOMAName() != null) {
                buf.append("<br/><a href=\"" + this.getOMAUrl() + "\">Mutation Assessor</a>");
            }
            if ((cravatLink = this.getCravatLink()) != null) {
                buf.append("<br/>" + cravatLink);
            }
            this.valueString = buf.toString();
        }
        return this.valueString;
    }

    public boolean hasScore() {
        return false;
    }

    @Override
    public Strand getStrand() {
        return Strand.NONE;
    }

    public boolean overlaps(IGVFeature track) {
        return false;
    }

    public String getChr() {
        return this.chr;
    }

    public String getContig() {
        return this.chr;
    }

    public void setColor(Color color) {
    }

    @Override
    public Color getColor() {
        PaletteColorTable colorTable = PreferencesManager.getPreferences().getMutationColorScheme();
        Color c = colorTable.get(this.getMutationType());
        return c;
    }

    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public float getScore() {
        return 0.0f;
    }

    @Override
    public boolean contains(IGVFeature feature) {
        if (feature == null || !this.getChr().equals(feature.getChr())) {
            return false;
        }
        return feature.getStart() >= this.getStart() && feature.getEnd() <= this.getEnd();
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.start && location <= (double)this.end;
    }

    @Override
    public String getURL() {
        return null;
    }

    public Exon getExonAt(double location) {
        return null;
    }

    @Override
    public List<Exon> getExons() {
        return null;
    }

    @Override
    public String getIdentifier() {
        return null;
    }

    public AminoAcidSequence getAminoAcidSequence(int exonIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getCdEnd() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getCdStart() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getLength() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MultiMap<String, String> getAttributes() {
        return null;
    }

    public void setAttributes(MultiMap<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setRefAllele(String refAllele) {
        this.refAllele = refAllele;
    }

    public void setAltAllele1(String altAllele1) {
        this.altAllele1 = altAllele1;
    }

    public void setAltAllele2(String altAllele2) {
        this.altAllele2 = altAllele2;
    }
}

