/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class LoadFromDatabaseAction
extends MenuAction {
    static Logger log = LogManager.getLogger(LoadFromDatabaseAction.class);
    IGV mainFrame;

    public LoadFromDatabaseAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Load tracks or sample information from a server");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                String host = PreferencesManager.getPreferences().get("DB_HOST");
                if (host == null || host.trim().length() == 0) {
                    MessageUtils.showMessage("Please set database configuration in user preferences (View > Preferences)");
                    return null;
                }
                IGVPreferences preferenceManager = PreferencesManager.getPreferences();
                String db = preferenceManager.get("DB_NAME");
                String port = preferenceManager.get("DB_PORT");
                String url = "jdbc:mysql://" + host;
                if (!port.equals("-1")) {
                    url = url + ":" + port;
                }
                url = url + "/" + db;
                String table2 = "SAMPLE_INFO";
                ResourceLocator loc2 = new ResourceLocator(url, table2);
                loc2.setDescription("SELECT * FROM " + table2);
                String table1 = "CNV";
                ResourceLocator loc1 = new ResourceLocator(url, table1);
                String query = "SELECT  Sample Sample, `Probe Median` Value, Chromosome chr,  Start start, Stop end, CONCAT('<br>Event: ', Event,'<br>% CNV Overlap = ', `% of CNV Overlap`) description  FROM CNV  WHERE Event = 'CN Gain' OR Event = 'CN Loss' OR Event = 'High Copy Gain'";
                loc1.setDescription(query);
                loc1.setFormat(".seg");
                LoadFromDatabaseAction.this.mainFrame.loadTracks(Arrays.asList(loc1, loc2));
                return null;
            }

            @Override
            protected void done() {
                LoadFromDatabaseAction.this.mainFrame.showLoadedTrackCount();
            }
        };
        worker.execute();
    }
}

