/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.sprite;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.feature.sprite.Cluster;
import org.broad.igv.util.ParsingUtils;

public class ClusterParser {
    private static Logger log = LogManager.getLogger(ClusterParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterSet parse(String file) throws IOException {
        int binSize = 1;
        ArrayList<Cluster> features = new ArrayList<Cluster>();
        try (BufferedReader br = null;){
            String nextLine;
            br = ParsingUtils.openBufferedReader(file);
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = ParsingUtils.TAB_PATTERN.split(nextLine);
                if (tokens[0].startsWith("#")) {
                    if (!tokens[0].startsWith("#binSize")) continue;
                    String[] t = ParsingUtils.EQ_PATTERN.split(tokens[0]);
                    binSize = Integer.parseInt(t[1].trim());
                }
                if (tokens.length < 2) {
                    log.info("Skipping line: " + nextLine);
                    continue;
                }
                String name = tokens[0];
                HashMap<String, List<Integer>> positions = new HashMap<String, List<Integer>>();
                for (int i = 1; i < tokens.length; ++i) {
                    String[] l = tokens[i].split(":");
                    String chr = l[0];
                    Integer position = Integer.parseInt(l[1]);
                    ArrayList<Integer> posList = (ArrayList<Integer>)positions.get(chr);
                    if (posList == null) {
                        posList = new ArrayList<Integer>();
                        positions.put(chr, posList);
                    }
                    posList.add(position);
                }
                for (List posList : positions.values()) {
                    Collections.sort(posList);
                }
                features.add(new Cluster(name, positions));
            }
            ClusterSet clusterSet = new ClusterSet(binSize, features);
            return clusterSet;
        }
    }

    public static class ClusterSet {
        int binSize;
        List<Cluster> clusters;

        public ClusterSet(int binSize, List<Cluster> clusters) {
            this.binSize = binSize;
            this.clusters = clusters;
        }
    }
}

