/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.SequenceOntology;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.aa.AminoAcid;
import org.broad.igv.feature.aa.Codon;
import org.broad.igv.feature.aa.CodonTable;
import org.broad.igv.feature.aa.CodonTableManager;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.WindowFunction;

public class BasicFeature
extends AbstractFeature {
    private static Logger log = LogManager.getLogger(BasicFeature.class);
    String representation;
    protected List<Exon> exons;
    protected int level = 1;
    protected float score = Float.NaN;
    protected float confidence;
    String identifier;
    private int thickEnd;
    private int thickStart;
    String[] parentIds;
    String link;

    public BasicFeature() {
    }

    public BasicFeature(String chr, int start, int end) {
        this(chr, start, end, Strand.NONE);
        this.thickStart = start;
        this.thickEnd = end;
    }

    public BasicFeature(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
        this.thickStart = start;
        this.thickEnd = end;
    }

    public BasicFeature(BasicFeature feature) {
        super(feature.getChr(), feature.getStart(), feature.getEnd(), feature.getStrand());
        super.setName(feature.getName());
        this.confidence = feature.confidence;
        this.color = feature.color;
        this.description = feature.description;
        this.exons = feature.exons;
        this.level = feature.level;
        this.score = feature.score;
        this.identifier = feature.identifier;
        this.type = feature.type;
        this.link = feature.link;
        this.thickStart = feature.thickStart;
        this.thickEnd = feature.thickEnd;
        this.attributes = feature.attributes;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(String representation) {
        this.representation = representation;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setParentIds(String[] parentIds) {
        this.parentIds = parentIds;
    }

    public String[] getParentIds() {
        return this.parentIds;
    }

    @Override
    public void setStart(int start) {
        super.setStart(start);
        this.thickStart = start;
    }

    @Override
    public void setEnd(int end) {
        super.setEnd(end);
        this.thickEnd = end;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction ignored) {
        StringBuffer valueString = new StringBuffer();
        String name = this.getName();
        if (name != null && name.length() > 0) {
            valueString.append("<b>" + name + "</b><br>");
        }
        valueString.append(this.getLocusString());
        if (this.strand == Strand.POSITIVE) {
            valueString.append(" (+)");
        } else if (this.strand == Strand.NEGATIVE) {
            valueString.append(" (-)");
        }
        if (this.type != null && this.type.length() > 0) {
            valueString.append("<br>Type = " + this.type);
        }
        if (!(this.identifier == null || name != null && name.length() != 0 && name.equals(this.identifier))) {
            valueString.append("<br>id = " + this.identifier);
        }
        if (!Float.isNaN(this.score)) {
            valueString.append("<br>Score = " + this.score);
        }
        if (this.description != null) {
            valueString.append("<br>" + this.description);
        }
        if (this.attributes != null) {
            valueString.append(this.getAttributeString());
        }
        int posZero = (int)position;
        if (this.exons != null) {
            for (Exon exon : this.exons) {
                String exonString;
                if (posZero < exon.getStart() || posZero >= exon.getEnd() || (exonString = exon.getValueString(position, mouseX, ignored)) == null || exonString.length() <= 0) continue;
                valueString.append("<br>--------------<br>");
                valueString.append(exonString);
            }
        }
        return valueString.toString();
    }

    public void setScore(float score) {
        this.score = score;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public List<Exon> getExons() {
        return this.exons;
    }

    @Override
    public boolean hasExons() {
        return this.exons != null && this.exons.size() > 0;
    }

    public void sortExons() {
        if (this.exons != null) {
            Collections.sort(this.exons, new Comparator<IGVFeature>(){

                @Override
                public int compare(IGVFeature arg0, IGVFeature arg1) {
                    return arg0.getStart() - arg1.getStart();
                }
            });
        }
    }

    public void addExon(Exon region) {
        if (this.exons == null) {
            this.exons = new ArrayList<Exon>();
        }
        this.setStart(Math.min(this.getStart(), region.getStart()));
        this.setEnd(Math.max(this.getEnd(), region.getEnd()));
        this.exons.add(region);
    }

    public void addUTRorCDS(BasicFeature bf) {
        boolean found = false;
        if (this.exons == null) {
            this.exons = new ArrayList<Exon>();
        }
        String exonType = bf.getType();
        for (Exon exon : this.exons) {
            if (!exon.contains(bf)) continue;
            exon.setAttributes(bf.getAttributes());
            if (SequenceOntology.cdsTypes.contains(exonType)) {
                exon.setNonCoding(false);
                exon.setCodingStart(bf.getStart());
                exon.setCodingEnd(bf.getEnd());
                exon.setReadingFrame(bf.getReadingFrame());
            } else if (SequenceOntology.utrTypes.contains(exonType)) {
                boolean rhs;
                exon.setNonCoding(true);
                boolean bl = rhs = SequenceOntology.fivePrimeUTRTypes.contains(exonType) && bf.getStrand() == Strand.POSITIVE || SequenceOntology.threePrimeUTRTypes.contains(exonType) && bf.getStrand() == Strand.NEGATIVE;
                if (rhs) {
                    exon.setCodingStart(bf.getEnd());
                    exon.setCodingEnd(bf.getEnd());
                } else {
                    exon.setCodingEnd(bf.getStart());
                    exon.setCodingStart(bf.getStart());
                }
            }
            found = true;
            break;
        }
        if (!found) {
            Exon exon = new Exon(bf);
            exon.setNonCoding(!SequenceOntology.cdsTypes.contains(bf.getType()));
            this.addExon(exon);
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public int getExonCount() {
        return this.exons == null ? 0 : this.exons.size();
    }

    public void setURL(String link) {
        this.link = link;
    }

    @Override
    public String getURL() {
        return this.link;
    }

    public int getThickEnd() {
        return this.thickEnd;
    }

    public void setThickEnd(int thickEnd) {
        this.thickEnd = thickEnd;
    }

    public int getThickStart() {
        return this.thickStart;
    }

    public void setThickStart(int thickStart) {
        this.thickStart = thickStart;
    }

    public Codon getCodon(Genome genome, String chr, int proteinPosition) {
        int startTranscriptPosition = (proteinPosition - 1) * 3;
        int[] featurePositions = new int[]{startTranscriptPosition, startTranscriptPosition + 1, startTranscriptPosition + 2};
        int[] genomePositions = this.featureToGenomePosition(featurePositions);
        Codon codonInfo = new Codon(this.getChr(), proteinPosition, this.getStrand());
        for (int gp : genomePositions) {
            codonInfo.setNextGenomePosition(gp);
        }
        if (!codonInfo.isGenomePositionsSet()) {
            return null;
        }
        codonInfo.calcSequence(genome);
        CodonTable codonTable = CodonTableManager.getInstance().getCodonTableForChromosome(chr);
        AminoAcid aa = codonTable.getAminoAcid(codonInfo.getSequence());
        if (aa != null) {
            codonInfo.setAminoAcid(aa);
            return codonInfo;
        }
        return null;
    }

    int[] featureToGenomePosition(int[] featurePositions) {
        List<Exon> exons = this.getExons();
        int[] genomePositions = new int[featurePositions.length];
        Arrays.fill(genomePositions, -1);
        if (exons != null) {
            if (this.getStrand() == Strand.NONE) {
                throw new IllegalStateException("Exon not on a strand");
            }
            boolean positive = this.getStrand() == Strand.POSITIVE;
            int posIndex = 0;
            int all_exon_counter = 0;
            int current_exon_end = 0;
            for (int exnum = 0; exnum < exons.size(); ++exnum) {
                int incr;
                Exon exon = positive ? exons.get(exnum) : exons.get(exons.size() - 1 - exnum);
                int exon_length = exon.getCodingLength();
                int genomePosition = positive ? exon.getCdStart() : exon.getCdEnd() - 1;
                current_exon_end += exon_length;
                int n = incr = positive ? 1 : -1;
                while (featurePositions[posIndex] < current_exon_end) {
                    int interval = featurePositions[posIndex] - all_exon_counter;
                    all_exon_counter = featurePositions[posIndex];
                    genomePositions[posIndex] = genomePosition += interval * incr;
                    if (++posIndex < featurePositions.length) continue;
                    return genomePositions;
                }
                all_exon_counter = current_exon_end;
            }
        }
        return genomePositions;
    }
}

