/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.util.collections.LRUCache;

public abstract class AbstractCacher {
    private static Logger log = LogManager.getLogger(AbstractCacher.class);
    protected int binSize = Integer.MAX_VALUE;
    protected LRUCache<String, Bin> cache;

    public AbstractCacher(int binCount, int binSize) {
        this.cache = new LRUCache(binCount);
        this.setBinSize(binSize);
    }

    protected abstract Iterator<Feature> queryRaw(String var1, int var2, int var3) throws IOException;

    public void setBinSize(int newSize) {
        this.binSize = newSize == 0 ? Integer.MAX_VALUE : newSize;
        this.cache.clear();
    }

    public void close() throws IOException {
        this.cache.clear();
    }

    public Iterator<Feature> queryCached(String chr, int start, int end) throws IOException {
        int startBin = start / this.binSize;
        int endBin = end / this.binSize;
        List<Bin> tiles = this.getBins(chr, startBin, endBin);
        if (tiles.size() == 0) {
            return Collections.emptyList().iterator();
        }
        int recordCount = tiles.get(0).getOverlappingRecords().size();
        for (Bin t : tiles) {
            recordCount += t.getContainedRecords().size();
        }
        ArrayList<Feature> features = new ArrayList<Feature>(recordCount);
        features.addAll(tiles.get(0).getOverlappingRecords());
        for (Bin t : tiles) {
            features.addAll(t.getContainedRecords());
        }
        return new BinIterator(start, end, features);
    }

    private synchronized List<Bin> getBins(String seq, int startBin, int endBin) {
        ArrayList<Bin> tiles = new ArrayList<Bin>(endBin - startBin + 1);
        ArrayList<Bin> tilesToLoad = new ArrayList<Bin>(endBin - startBin + 1);
        for (int t = startBin; t <= endBin; ++t) {
            String key = seq + "_" + t;
            Bin tile = this.cache.get(key);
            if (tile == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Tile cache miss: " + t);
                }
                int start = t * this.binSize;
                int end = start + this.binSize;
                tile = new Bin(t, start, end);
                this.cache.put(key, tile);
            }
            tiles.add(tile);
            if (tile.isLoaded()) {
                if (tilesToLoad.size() > 0 && !this.loadTiles(seq, tilesToLoad)) {
                    return tiles;
                }
                tilesToLoad.clear();
                continue;
            }
            tilesToLoad.add(tile);
        }
        if (tilesToLoad.size() > 0) {
            this.loadTiles(seq, tilesToLoad);
        }
        return tiles;
    }

    private boolean loadTiles(String seq, List<Bin> tiles) {
        int end;
        assert (tiles.size() > 0);
        if (log.isDebugEnabled()) {
            int first = tiles.get(0).getBinNumber();
            end = tiles.get(tiles.size() - 1).getBinNumber();
            log.debug("Loading tiles: " + first + "-" + end);
        }
        int start = tiles.get((int)0).start + 1;
        end = tiles.get((int)(tiles.size() - 1)).end;
        Iterator<Feature> iter = null;
        int featureCount = 0;
        long t0 = System.currentTimeMillis();
        try {
            iter = this.queryRaw(seq, start, end);
            while (iter != null && iter.hasNext()) {
                Feature record = iter.next();
                int aStart = record.getStart();
                int aEnd = record.getEnd();
                int idx0 = 0;
                int idx1 = 0;
                if (this.binSize > 0) {
                    idx0 = Math.max(0, (aStart - start) / this.binSize);
                    idx1 = Math.min(tiles.size() - 1, (aEnd - start) / this.binSize);
                }
                for (int i = idx0; i <= idx1; ++i) {
                    Bin t = tiles.get(i);
                    if (this.binSize == 0 || aStart >= t.start && aStart < t.end) {
                        t.containedRecords.add(record);
                        continue;
                    }
                    if (aEnd < t.start || aStart >= t.start) continue;
                    t.overlappingRecords.add(record);
                }
            }
            for (Bin t : tiles) {
                t.setLoaded(true);
            }
            if (log.isDebugEnabled()) {
                long dt = System.currentTimeMillis() - t0;
                long rate = dt == 0L ? Long.MAX_VALUE : (long)featureCount / dt;
                log.debug("Loaded " + featureCount + " reads in " + dt + "ms.  (" + rate + " reads/ms)");
            }
            boolean dt = true;
            return dt;
        }
        catch (IOException e) {
            log.error("IOError loading feature data", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (iter != null) {
                // empty if block
            }
        }
    }

    private class BinIterator
    implements CloseableTribbleIterator {
        Iterator<Feature> currentFeatureIterator;
        int end;
        Feature nextRecord;
        int start;
        List<Feature> features;

        BinIterator(int start, int end, List<Feature> features) {
            this.features = features;
            this.start = start;
            this.end = end;
            this.currentFeatureIterator = features.iterator();
            this.advanceToFirstRecord();
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.nextRecord != null;
        }

        public Feature next() {
            Feature ret = this.nextRecord;
            this.advanceToNextRecord();
            return ret;
        }

        public void remove() {
        }

        private void advanceToFirstRecord() {
            this.advanceToNextRecord();
        }

        private void advanceToNextRecord() {
            this.advance();
            while (this.nextRecord != null && this.nextRecord.getEnd() < this.start) {
                this.advance();
            }
        }

        private void advance() {
            if (this.currentFeatureIterator.hasNext()) {
                this.nextRecord = this.currentFeatureIterator.next();
                if (this.nextRecord.getStart() > this.end) {
                    this.nextRecord = null;
                }
            } else {
                this.nextRecord = null;
            }
        }

        public Iterator iterator() {
            return this;
        }
    }

    private static class Bin {
        private boolean loaded = false;
        private int start;
        private int end;
        private int binNumber;
        private List<Feature> containedRecords;
        private List<Feature> overlappingRecords;

        Bin(int binNumber, int start, int end) {
            this.binNumber = binNumber;
            this.start = start;
            this.end = end;
            this.containedRecords = new ArrayList<Feature>(1000);
            this.overlappingRecords = new ArrayList<Feature>(100);
        }

        public int getBinNumber() {
            return this.binNumber;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public List<Feature> getContainedRecords() {
            return this.containedRecords;
        }

        public List<Feature> getOverlappingRecords() {
            return this.overlappingRecords;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }
    }
}

