/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class SAMRecordPrefetchingIterator
implements CloseableIterator<SAMRecord> {
    private final PeekableIterator<SAMRecord> inner;
    private final BlockingQueue<Either> queue;
    private final int basePrefetchLimit;
    private final AtomicInteger basesAllowed;
    private Thread backgroundThread;

    public SAMRecordPrefetchingIterator(CloseableIterator<SAMRecord> iterator, int basePrefetchLimit) {
        this.inner = new PeekableIterator<SAMRecord>(iterator);
        this.queue = new LinkedBlockingQueue<Either>();
        this.basePrefetchLimit = basePrefetchLimit;
        this.basesAllowed = new AtomicInteger(this.basePrefetchLimit);
        this.backgroundThread = new Thread(this::prefetch, SAMRecordPrefetchingIterator.class.getSimpleName() + "Thread");
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetch() {
        while (this.inner.hasNext() && !Thread.currentThread().isInterrupted()) {
            SAMRecord next = this.inner.peek();
            int bases = next.getReadLength();
            try {
                Object object = this.basesAllowed;
                synchronized (object) {
                    int basesAllowed = this.basesAllowed.get();
                    while (basesAllowed < bases && basesAllowed < this.basePrefetchLimit) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        this.basesAllowed.wait();
                        basesAllowed = this.basesAllowed.get();
                    }
                    this.basesAllowed.addAndGet(-bases);
                }
                object = this;
                synchronized (object) {
                    this.inner.next();
                    this.queue.add(new Either(next));
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable t) {
                if (t instanceof Error) {
                    t.printStackTrace();
                }
                this.queue.add(new Either(t));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.backgroundThread == null) {
            return;
        }
        AtomicInteger atomicInteger = this.basesAllowed;
        synchronized (atomicInteger) {
            this.backgroundThread.interrupt();
        }
        try {
            this.backgroundThread.join();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Interrupted waiting for background thread to complete", ie);
        }
        finally {
            this.inner.close();
            this.backgroundThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (this.backgroundThread == null) {
            throw new IllegalStateException("iterator has been closed");
        }
        SAMRecordPrefetchingIterator sAMRecordPrefetchingIterator = this;
        synchronized (sAMRecordPrefetchingIterator) {
            return this.inner.hasNext() || !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAMRecord next() {
        Either next;
        if (!this.hasNext()) {
            throw new NoSuchElementException("SAMRecordPrefetchingIterator is empty");
        }
        try {
            next = this.queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for prefetching thread", e);
        }
        if (next.record != null) {
            AtomicInteger e = this.basesAllowed;
            synchronized (e) {
                this.basesAllowed.getAndAdd(next.record.getReadLength());
                this.basesAllowed.notify();
            }
            return next.record;
        }
        Throwable t = next.error;
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    protected int readsInQueue() {
        return this.basePrefetchLimit - this.basesAllowed.get();
    }

    private static class Either {
        private final SAMRecord record;
        private final Throwable error;

        public Either(SAMRecord record) {
            this.record = record;
            this.error = null;
        }

        public Either(Throwable error) {
            this.record = null;
            this.error = error;
        }
    }
}

