/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.LRUCache;

public class FeatureDirSource
implements FeatureSource {
    static Logger log = Logger.getLogger(FeatureDirSource.class);
    LRUCache<String, List<Feature>> featureCache;
    Properties fileMap;
    String rootDir;
    ResourceLocator rootLocator;
    Genome genome;

    public FeatureDirSource(ResourceLocator locator, Genome genome) throws IOException {
        this.genome = genome;
        this.featureCache = new LRUCache(3);
        this.rootLocator = locator;
        this.setRootDir(locator.getPath());
        this.fileMap = new Properties();
        InputStream propStream = ParsingUtils.openInputStreamGZ(locator);
        this.fileMap.load(propStream);
        propStream.close();
    }

    public Class getFeatureClass() {
        return IGVFeature.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Feature> getFeatures(String chr) {
        String filename;
        List<Feature> features = this.featureCache.get(chr);
        if (features == null && (filename = this.fileMap.getProperty(chr)) != null) {
            BufferedReader reader = null;
            String path = this.rootDir + "/" + filename;
            try {
                ResourceLocator loc = new ResourceLocator(path);
                FeatureParser fp = AbstractFeatureParser.getInstanceFor(loc, this.genome);
                reader = ParsingUtils.openBufferedReader(loc);
                features = fp.loadFeatures(reader, this.genome);
                this.featureCache.put(chr, features);
            }
            catch (IOException ex) {
                MessageUtils.showMessage("Error loading file: " + path + " (" + ex.toString() + ")");
                log.error((Object)("Error loading feature file: " + filename), (Throwable)ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.featureCache.get(chr);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int i, int i1, int zoom) {
        return null;
    }

    public Iterator<Feature> getFeatures(String chr, int start, int end) {
        List<Feature> features = this.getFeatures(chr);
        return features == null ? Collections.emptyList().iterator() : features.iterator();
    }

    private void setRootDir(String path) {
        if (HttpUtils.isRemoteURL(path)) {
            int idx = path.lastIndexOf(47);
            this.rootDir = path.substring(0, idx);
        } else {
            this.rootDir = new File(path).getParent();
        }
    }
}

