/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.expression;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.data.expression.ExpressionDataset;
import org.broad.igv.data.expression.GeneToLocusHelper;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tools.StatusMonitor;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MagetabSignalDialog;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class ExpressionFileParser {
    private static Logger log = Logger.getLogger(ExpressionFileParser.class);
    private static final int MAX_ERROR_COUNT = 200;
    ResourceLocator dataFileLocator;
    FileType type;
    Genome genome;
    Map<String, Integer> longestProbeMap;
    Map<String, List<Row>> rowMap = new HashMap<String, List<Row>>();
    StatusMonitor statusMonitor;
    GeneToLocusHelper locusHelper;
    Map<String, Integer> dataColumnIndexMap;
    int errorCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGCT(String path) throws IOException {
        try (BufferedReader reader = null;){
            reader = ParsingUtils.openBufferedReader(path);
            String firstLine = reader.readLine();
            boolean bl = firstLine != null && firstLine.trim().equals("#1.2");
            return bl;
        }
    }

    public ExpressionFileParser(ResourceLocator resFile, String probeFile, Genome genome) throws IOException {
        this.dataFileLocator = resFile;
        this.type = ExpressionFileParser.determineType(resFile);
        this.genome = genome;
        this.longestProbeMap = new HashMap<String, Integer>();
        this.locusHelper = new GeneToLocusHelper(probeFile);
    }

    public ExpressionFileParser(File resFile, String probeFile, Genome genome) throws IOException {
        this(new ResourceLocator(resFile.getAbsolutePath()), probeFile, genome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parsableMAGE_TAB(ResourceLocator file) throws IOException {
        try (AsciiLineReader reader = null;){
            reader = ParsingUtils.openAsciiReader(file);
            String nextLine = null;
            reader.readLine();
            nextLine = reader.readLine();
            if (nextLine != null && (nextLine.contains("Reporter REF") || nextLine.contains("Composite Element REF") || nextLine.contains("Term Source REF") || nextLine.contains("CompositeElement REF") || nextLine.contains("TermSource REF") || nextLine.contains("Coordinates REF"))) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public ExpressionDataset createDataset() {
        ExpressionDataset dataset = new ExpressionDataset(this.genome);
        this.parse(dataset);
        return dataset;
    }

    public static FileType determineType(ResourceLocator dataFileLocator) {
        String format = dataFileLocator.getFormat();
        FileType type = format.equals("res") ? FileType.RES : (format.equals("gct") ? FileType.GCT : (format.equals("mapped") ? FileType.MAPPED : (format.equals("met") ? FileType.MET : (format.equals("dchip") ? FileType.DCHIP : ("mage-tab".equals(format) || "MAGE_TAB".equals(dataFileLocator.getDescription()) ? FileType.MAGE_TAB : FileType.TAB)))));
        return type;
    }

    public void parse(ExpressionDataset dataset) {
        dataset.setType(TrackType.GENE_EXPRESSION);
        BufferedReader reader = null;
        String nextLine = null;
        int lineCount = 0;
        try {
            reader = ParsingUtils.openBufferedReader(this.dataFileLocator);
            FormatDescriptor formatDescriptor = ExpressionFileParser.parseHeader(reader, this.type, dataset);
            int probeColumn = formatDescriptor.probeColumn;
            int descriptionColumn = formatDescriptor.descriptionColumn;
            int nDataColumns = formatDescriptor.dataColumns.length;
            dataset.setColumnHeadings(formatDescriptor.dataHeaders);
            this.dataColumnIndexMap = new HashMap<String, Integer>();
            for (int i = 0; i < formatDescriptor.dataHeaders.length; ++i) {
                this.dataColumnIndexMap.put(formatDescriptor.dataHeaders[i], i);
            }
            while ((nextLine = reader.readLine()) != null) {
                String description;
                String[] tokens = Globals.tabPattern.split(nextLine, -1);
                int nTokens = tokens.length;
                String probeId = new String(tokens[probeColumn]);
                float[] values = new float[nDataColumns];
                String string = description = descriptionColumn >= 0 ? tokens[descriptionColumn] : null;
                if (this.type == FileType.MAGE_TAB && probeId.startsWith("cg")) {
                    dataset.setType(TrackType.DNA_METHYLATION);
                }
                for (int i = 0; i < nDataColumns; ++i) {
                    try {
                        int dataIndex = formatDescriptor.dataColumns[i];
                        if (dataIndex >= nTokens || tokens[dataIndex].length() == 0) {
                            values[i] = Float.NaN;
                            continue;
                        }
                        values[i] = Float.parseFloat(tokens[dataIndex]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        values[i] = Float.NaN;
                    }
                }
                this.addRow(probeId, description, values);
                ++lineCount;
            }
            this.sortRows();
            for (String chr : this.rowMap.keySet()) {
                dataset.setStartLocations(chr, this.getStartLocations(chr));
                dataset.setEndLocations(chr, this.getEndLocations(chr));
                dataset.setFeatureNames(chr, this.getProbes(chr));
                for (String heading : formatDescriptor.dataHeaders) {
                    dataset.setData(heading, chr, this.getData(heading, chr));
                }
            }
            dataset.setLongestFeatureMap(this.longestProbeMap);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (nextLine != null && lineCount != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, lineCount, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addRow(String probeId, String description, float[] values) {
        List<Locus> loci = this.locusHelper.getLoci(probeId, description, this.genome.getId());
        if (loci != null) {
            for (Locus locus : loci) {
                if (locus == null || !locus.isValid()) continue;
                String chr = this.genome == null ? locus.getChr() : this.genome.getCanonicalChrName(locus.getChr());
                List<Row> rows = this.rowMap.get(chr);
                if (rows == null) {
                    rows = new ArrayList<Row>();
                    this.rowMap.put(chr, rows);
                }
                int length = locus.getEnd() - locus.getStart();
                if (this.longestProbeMap.containsKey(chr)) {
                    this.longestProbeMap.put(chr, Math.max(this.longestProbeMap.get(chr), length));
                } else {
                    this.longestProbeMap.put(chr, length);
                }
                rows.add(new Row(probeId, chr, locus.getStart(), locus.getEnd(), values));
            }
        } else {
            if (this.errorCount < 200) {
                log.info((Object)("Probe: '" + probeId + "' could not be mapped to a genomic position."));
            } else if (this.errorCount == 200) {
                log.info((Object)"Maximum probe mapping warning count exceeded.  Further mapping errors will not be logged");
            }
            ++this.errorCount;
        }
    }

    private void sortRows() {
        Comparator<Row> c = new Comparator<Row>(){

            @Override
            public int compare(Row arg0, Row arg1) {
                return arg0.start - arg1.start;
            }
        };
        for (List<Row> rows : this.rowMap.values()) {
            Collections.sort(rows, c);
        }
    }

    public String[] getProbes(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        String[] labels = new String[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            labels[i] = rows.get((int)i).feature;
        }
        return labels;
    }

    public int[] getStartLocations(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        int[] startLocations = new int[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            startLocations[i] = rows.get((int)i).start;
        }
        return startLocations;
    }

    public int[] getEndLocations(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        int[] endLocations = new int[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            endLocations[i] = rows.get((int)i).end;
        }
        return endLocations;
    }

    public float[] getData(String heading, String chr) {
        int columnIndex = this.dataColumnIndexMap.get(heading);
        List<Row> rows = this.rowMap.get(chr);
        float[] data = new float[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            data[i] = rows.get((int)i).values[columnIndex];
        }
        return data;
    }

    private static void parseComment(String comment, ExpressionDataset dataset) {
        if (dataset == null) {
            return;
        }
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            dataset.setTrackLine(tmp);
        } else {
            String[] tokens = tmp.split("=");
            if (tokens.length != 2) {
                return;
            }
            String key = tokens[0].trim().toLowerCase();
            if (key.equals("name")) {
                dataset.setName(tokens[1].trim());
            } else if (key.equals("type")) {
                try {
                    dataset.setType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static FormatDescriptor parseHeader(BufferedReader reader, FileType type, ExpressionDataset dataset) throws IOException {
        int descriptionColumn = -1;
        int dataStartColumn = -1;
        int probeColumn = 0;
        switch (type) {
            case RES: {
                dataStartColumn = 2;
                probeColumn = 1;
                descriptionColumn = 0;
                break;
            }
            case GCT: {
                dataStartColumn = 2;
                probeColumn = 0;
                descriptionColumn = 1;
                break;
            }
            case MAPPED: {
                dataStartColumn = 4;
                probeColumn = 0;
                break;
            }
            case MET: {
                dataStartColumn = 4;
                probeColumn = 0;
                break;
            }
            case DCHIP: {
                dataStartColumn = 1;
                probeColumn = 0;
                descriptionColumn = -1;
                break;
            }
            case MAGE_TAB: {
                descriptionColumn = -1;
                probeColumn = 0;
                break;
            }
            case TAB: {
                dataStartColumn = 1;
                probeColumn = 0;
            }
        }
        String headerLine = ExpressionFileParser.findHeaderLine(reader, type, dataset);
        String[] firstHeaderRowTokens = headerLine.split("\t");
        ArrayList<String> dataHeadingList = new ArrayList<String>(firstHeaderRowTokens.length);
        ArrayList<Integer> dataColumnList = new ArrayList<Integer>(firstHeaderRowTokens.length);
        if (type != FileType.MAGE_TAB) {
            int skip = type == FileType.RES ? 2 : 1;
            for (int i = dataStartColumn; i < firstHeaderRowTokens.length; i += skip) {
                String heading = firstHeaderRowTokens[i].replace('\"', ' ').trim();
                dataHeadingList.add(heading);
                dataColumnList.add(i);
            }
        } else {
            String nextLine = reader.readLine();
            String[] secondHeaderRowTokens = nextLine.split("\t");
            for (int i = 1; i < firstHeaderRowTokens.length; ++i) {
                if (firstHeaderRowTokens[i].trim().length() <= 0) continue;
                dataStartColumn = i;
                break;
            }
            String[] dataHeaderColumns = new String[secondHeaderRowTokens.length - dataStartColumn];
            System.arraycopy(secondHeaderRowTokens, dataStartColumn, dataHeaderColumns, 0, dataHeaderColumns.length);
            String qCol = ExpressionFileParser.findSignalColumnHeading(dataHeaderColumns);
            for (int i = 0; i < secondHeaderRowTokens.length; ++i) {
                String heading = secondHeaderRowTokens[i].replace('\"', ' ').trim();
                if (!heading.toLowerCase().contains(qCol.toLowerCase())) continue;
                dataHeadingList.add(firstHeaderRowTokens[i]);
                dataColumnList.add(i);
            }
        }
        String[] dataHeaders = dataHeadingList.toArray(new String[dataHeadingList.size()]);
        int[] dataColumns = new int[dataColumnList.size()];
        for (int i = 0; i < dataColumnList.size(); ++i) {
            dataColumns[i] = (Integer)dataColumnList.get(i);
        }
        if (type == FileType.RES) {
            reader.readLine();
            reader.readLine();
        }
        return new FormatDescriptor(probeColumn, descriptionColumn, dataColumns, dataHeaders, firstHeaderRowTokens.length);
    }

    private static String findHeaderLine(BufferedReader reader, FileType type, ExpressionDataset dataset) throws IOException {
        String headerLine;
        if (type == FileType.GCT) {
            String nextLine = reader.readLine();
            if (nextLine.startsWith("#")) {
                ExpressionFileParser.parseComment(nextLine, dataset);
            }
            if ((nextLine = reader.readLine()).startsWith("#")) {
                ExpressionFileParser.parseComment(nextLine, dataset);
            }
            headerLine = reader.readLine();
        } else if (type != FileType.MAGE_TAB) {
            String nextLine;
            while ((nextLine = reader.readLine()).startsWith("#") && nextLine != null) {
                ExpressionFileParser.parseComment(nextLine, dataset);
            }
            headerLine = nextLine;
        } else {
            headerLine = reader.readLine();
        }
        return headerLine;
    }

    private static String findSignalColumnHeading(String[] tokens) {
        String[] signals;
        HashMap<String, String> columnHeaderSet = new HashMap<String, String>();
        for (String tok : tokens) {
            columnHeaderSet.put(tok.toLowerCase(), tok);
        }
        for (String sig : signals = new String[]{"beta_value", "beta value", "log2 signal", "signal"}) {
            if (!columnHeaderSet.containsKey(sig.toLowerCase())) continue;
            return (String)columnHeaderSet.get(sig.toLowerCase());
        }
        String qCol = null;
        HashSet<String> uniqueColumns = new HashSet<String>(Arrays.asList(tokens));
        ArrayList<String> qColumns = new ArrayList<String>(uniqueColumns);
        if (qColumns.size() == 1) {
            qCol = (String)qColumns.get(0);
        } else if (!Globals.isHeadless()) {
            Collections.sort(qColumns);
            MagetabSignalDialog msDialog = new MagetabSignalDialog(IGV.getMainFrame(), qColumns.toArray(new String[0]));
            msDialog.setVisible(true);
            if (!msDialog.isCanceled()) {
                qCol = msDialog.getQuantitationColumn();
            } else {
                throw new RuntimeException("Could not find any signal columns in the MAGE-TAB file");
            }
        }
        return qCol;
    }

    public static class FormatDescriptor {
        private int probeColumn;
        private int descriptionColumn;
        private int[] dataColumns;
        private String[] dataHeaders;
        private int totalColumnCount;

        FormatDescriptor(int probeColumn, int descriptionColumn, int[] dataColumns, String[] dataHeaders, int totalColumnCount) {
            this.probeColumn = probeColumn;
            this.descriptionColumn = descriptionColumn;
            this.dataColumns = dataColumns;
            this.dataHeaders = dataHeaders;
            this.totalColumnCount = totalColumnCount;
        }

        public int getProbeColumn() {
            return this.probeColumn;
        }

        public int getDescriptionColumn() {
            return this.descriptionColumn;
        }

        public int[] getDataColumns() {
            return this.dataColumns;
        }

        public String[] getDataHeaders() {
            return this.dataHeaders;
        }

        public int getTotalColumnCount() {
            return this.totalColumnCount;
        }
    }

    class Row {
        String feature;
        String chr;
        int start;
        int end;
        float[] values;

        Row(String feature, String chr, int start, int end, float[] values) {
            this.feature = feature;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.values = values;
        }
    }

    public static enum FileType {
        RES,
        GCT,
        MAPPED,
        TAB,
        MET,
        DCHIP,
        MAGE_TAB;

    }
}

