/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.io.BufferedReader;
import java.io.IOException;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ParsingUtils;

public class BatchRunner
implements NamedRunnable {
    private static Logger log = LogManager.getLogger(BatchRunner.class);
    private String inputFile;
    private IGV igv;

    public BatchRunner(String inputFile, IGV igv) {
        this.inputFile = inputFile;
        this.igv = igv;
    }

    @Override
    public String getName() {
        return "batchExecution";
    }

    public static void setIsBatchMode(boolean isBatchMode) {
        Globals.setSuppressMessages(isBatchMode);
        Globals.setBatch(isBatchMode);
    }

    @Override
    public void run() {
        this.runWithDefaultGenome(null);
    }

    public void runWithDefaultGenome(String genomeId) {
        BatchRunner.setIsBatchMode(true);
        CommandExecutor cmdExe = new CommandExecutor(this.igv);
        WaitCursorManager.CursorToken cursorToken = null;
        BufferedReader reader = null;
        try {
            String inLine;
            cursorToken = WaitCursorManager.showWaitCursor();
            reader = ParsingUtils.openBufferedReader(this.inputFile);
            boolean firstCommand = true;
            while ((inLine = reader.readLine()) != null) {
                if (inLine.startsWith("#") || inLine.startsWith("//")) continue;
                if (firstCommand && genomeId != null && !inLine.toLowerCase().startsWith("genome")) {
                    log.debug("Loading genome " + genomeId);
                    GenomeManager.getInstance().loadGenomeById(genomeId);
                }
                log.debug("Executing Command: " + inLine);
                cmdExe.execute(inLine);
                firstCommand = false;
            }
        }
        catch (IOException ioe) {
            throw new DataLoadException(ioe.getMessage(), this.inputFile);
        }
        finally {
            BatchRunner.setIsBatchMode(false);
            SnapshotUtilities.resetMaxPanelHeight();
            if (cursorToken != null) {
                WaitCursorManager.removeWaitCursor(cursorToken);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

