/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.ViewChange;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.AttributePanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IGVMouseInputAdapter;
import org.broad.igv.util.StringUtils;

public class RegionNavigatorDialog
extends JDialog
implements Observer,
IGVEventObserver {
    private static Logger log = LogManager.getLogger(AttributePanel.class);
    private static final int TABLE_COLINDEX_CHR = 0;
    private static final int TABLE_COLINDEX_START = 1;
    private static final int TABLE_COLINDEX_END = 2;
    private static final int TABLE_COLINDEX_DESC = 3;
    public static RegionNavigatorDialog activeInstance;
    private DefaultTableModel regionTableModel;
    private TableRowSorter<TableModel> regionTableRowSorter;
    private boolean synchingRegions = false;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel3;
    private JCheckBox checkBoxShowAllChrs;
    private JButton addButton;
    private JButton removeButton;
    private JScrollPane scrollPane1;
    private JTable regionTable;
    private JPanel panel1;
    private JPanel panel2;
    private JButton viewButton;
    private JCheckBox checkBoxZoomWhenNav;
    private JPanel panel4;
    private JLabel label1;
    private JTextField textFieldSearch;
    private JButton clearSearchButton;
    private CancelAction cancelAction;
    private AddRegionAction addAction;
    private RemoveSelectedRegionsAction actionRemoveRegions;
    private ShowAllChromosomesCheckboxAction showAllChromosomesCheckboxAction;
    private ViewSelectedAction viewAction;

    public static RegionNavigatorDialog getOrCreateInstance(Frame owner) {
        if (activeInstance == null) {
            activeInstance = new RegionNavigatorDialog(owner);
        }
        return activeInstance;
    }

    public static RegionNavigatorDialog getInstance() {
        return activeInstance;
    }

    public static boolean destroyInstance() {
        if (activeInstance == null) {
            return false;
        }
        activeInstance.dispose();
        activeInstance = null;
        return true;
    }

    private RegionNavigatorDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.postInit();
    }

    private RegionNavigatorDialog(Dialog owner) {
        super(owner);
        this.initComponents();
        this.postInit();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.synchRegions();
    }

    @Override
    public void receiveEvent(Object e) {
        this.synchRegions();
    }

    public void synchRegions() {
        this.synchingRegions = true;
        List<RegionOfInterest> regions = this.retrieveRegionsAsList();
        this.regionTableModel = (DefaultTableModel)this.regionTable.getModel();
        while (this.regionTableModel.getRowCount() > 0) {
            this.regionTableModel.removeRow(0);
        }
        this.regionTableModel.setRowCount(regions.size());
        for (int i = 0; i < regions.size(); ++i) {
            RegionOfInterest region = regions.get(i);
            this.regionTableModel.setValueAt(region.getDescription(), i, 3);
            this.regionTableModel.setValueAt(region.getDisplayStart(), i, 1);
            this.regionTableModel.setValueAt(region.getDisplayEnd(), i, 2);
            this.regionTableModel.setValueAt(region.getChr(), i, 0);
        }
        this.synchingRegions = false;
        this.regionTableModel.fireTableDataChanged();
    }

    private List<RegionOfInterest> retrieveRegionsAsList() {
        return new ArrayList<RegionOfInterest>(IGV.getInstance().getSession().getAllRegionsOfInterest());
    }

    private void postInit() {
        this.regionTableModel = (DefaultTableModel)this.regionTable.getModel();
        this.regionTable.getSelectionModel().addListSelectionListener(new RegionTableSelectionListener());
        this.regionTableModel.addTableModelListener(new RegionTableModelListener());
        this.regionTableRowSorter = new TableRowSorter<DefaultTableModel>(this.regionTableModel);
        this.regionTable.setRowSorter(this.regionTableRowSorter);
        this.regionTableRowSorter.setRowFilter(new RegionRowFilter());
        this.textFieldSearch.getDocument().addDocumentListener(new SearchFieldDocumentListener());
        this.updateChromosomeDisplayed();
        this.synchRegions();
        ReferenceFrame defFrame = FrameManager.getDefaultFrame();
        IGVEventBus.getInstance().subscribe(ViewChange.class, this);
        IGV.getInstance().getSession().getRegionsOfInterestObservable().addObserver(this);
        int newTableHeight = Math.min(this.regionTableModel.getRowCount() + 1, 5) * this.regionTable.getRowHeight();
        int extraHeight = 225;
        int newDialogHeight = newTableHeight + extraHeight;
        if (newDialogHeight < this.getHeight()) {
            this.regionTable.setPreferredScrollableViewportSize(new Dimension(this.regionTable.getPreferredSize().width, newTableHeight));
            this.setSize(this.getWidth(), newTableHeight + extraHeight);
            this.update(this.getGraphics());
        }
        this.regionTable.addMouseListener(new RegionTablePopupHandler());
        this.updateButtonsEnabled();
    }

    public void updateChromosomeDisplayed() {
        this.regionTableModel.fireTableDataChanged();
    }

    protected boolean shouldIncludeRegion(String regionChr, String regionDesc) {
        if (regionChr == null) {
            return false;
        }
        String filterStringLowercase = null;
        if (this.textFieldSearch.getText() != null) {
            filterStringLowercase = this.textFieldSearch.getText().toLowerCase();
        }
        String chr = FrameManager.getDefaultFrame().getChrName();
        if (!(filterStringLowercase == null || filterStringLowercase.isEmpty() || regionDesc != null && regionDesc.toLowerCase().contains(filterStringLowercase))) {
            return false;
        }
        if (this.checkBoxShowAllChrs.isSelected()) {
            return true;
        }
        return chr == null || chr.isEmpty() || regionChr.equals(chr);
    }

    public void updateROIsFromRegionTable() {
        for (int i = 0; i < this.regionTable.getRowSorter().getModelRowCount(); ++i) {
            this.updateROIFromRegionTable(i);
        }
    }

    public void updateROIFromRegionTable(int tableRow) {
        List<RegionOfInterest> regions = this.retrieveRegionsAsList();
        if (tableRow > this.regionTable.getRowCount() - 1) {
            return;
        }
        int rowIdx = 0;
        try {
            rowIdx = this.regionTable.getRowSorter().convertRowIndexToModel(tableRow);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return;
        }
        RegionOfInterest region = regions.get(rowIdx);
        Object descObject = this.regionTableModel.getValueAt(rowIdx, 3);
        if (descObject != null) {
            region.setDescription(descObject.toString());
        }
        int storeStartValue = Math.max(0, (Integer)this.regionTableModel.getValueAt(rowIdx, 1) - 1);
        region.setStart(storeStartValue);
        int storeEndValue = Math.max(0, (Integer)this.regionTableModel.getValueAt(rowIdx, 2));
        region.setEnd(storeEndValue);
    }

    private List<RegionOfInterest> getSelectedRegions(int[] selectedRows) {
        ArrayList<RegionOfInterest> selectedRegions = new ArrayList<RegionOfInterest>();
        List<RegionOfInterest> regions = this.retrieveRegionsAsList();
        for (int selectedRowIndex : selectedRows) {
            int selectedModelRow = this.regionTableRowSorter.convertRowIndexToModel(selectedRowIndex);
            selectedRegions.add(regions.get(selectedModelRow));
        }
        return selectedRegions;
    }

    private void regionTableMouseClicked(MouseEvent e) {
        this.updateButtonsEnabled();
    }

    private void updateButtonsEnabled() {
        boolean enableMutStates = this.regionTable.getSelectedRowCount() >= 1;
        boolean enableZoomToRegion = this.regionTable.getSelectedRowCount() == 1;
        this.removeButton.setEnabled(enableMutStates);
        this.viewButton.setEnabled(enableMutStates);
        this.checkBoxZoomWhenNav.setEnabled(enableZoomToRegion);
    }

    private void thisWindowActivated(WindowEvent e) {
        this.synchRegions();
    }

    private void thisWindowDeactivated(WindowEvent e) {
        this.updateROIsFromRegionTable();
    }

    private void thisWindowClosed(WindowEvent e) {
        IGV.getInstance().getSession().getRegionsOfInterestObservable().deleteObserver(this);
        RegionNavigatorDialog.destroyInstance();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel3 = new JPanel();
        this.checkBoxShowAllChrs = new JCheckBox();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.regionTable = new JTable();
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.viewButton = new JButton();
        this.checkBoxZoomWhenNav = new JCheckBox();
        this.panel4 = new JPanel();
        this.label1 = new JLabel();
        this.textFieldSearch = new JTextField();
        this.clearSearchButton = new JButton();
        this.cancelAction = new CancelAction();
        this.addAction = new AddRegionAction();
        this.actionRemoveRegions = new RemoveSelectedRegionsAction();
        this.showAllChromosomesCheckboxAction = new ShowAllChromosomesCheckboxAction();
        this.viewAction = new ViewSelectedAction();
        this.setTitle("Regions of Interest");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                RegionNavigatorDialog.this.thisWindowActivated(e);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                RegionNavigatorDialog.this.thisWindowClosed(e);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                RegionNavigatorDialog.this.thisWindowDeactivated(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(null);
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panel3.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.panel3.setBorder(LineBorder.createBlackLineBorder());
        this.panel3.setLayout(new FlowLayout(0));
        this.checkBoxShowAllChrs.setAction(this.showAllChromosomesCheckboxAction);
        this.checkBoxShowAllChrs.setToolTipText("View regions from all chromosomes (otherwise, current chromosome only)");
        this.checkBoxShowAllChrs.setSelected(true);
        this.panel3.add(this.checkBoxShowAllChrs);
        this.addButton.setAction(this.addAction);
        this.addButton.setText("Add");
        this.addButton.setActionCommand("Add");
        this.panel3.add(this.addButton);
        this.removeButton.setAction(this.actionRemoveRegions);
        this.removeButton.setText("Remove");
        this.panel3.add(this.removeButton);
        this.contentPanel.add((Component)this.panel3, "North");
        this.regionTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"Chr", "Start", "End", "Description"}){
            Class<?>[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{String.class, Integer.class, Integer.class, Object.class};
                this.columnEditable = new boolean[]{false, true, true, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        TableColumnModel cm = this.regionTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(50);
        cm.getColumn(1).setPreferredWidth(100);
        cm.getColumn(2).setPreferredWidth(100);
        cm.getColumn(3).setPreferredWidth(200);
        this.regionTable.setAutoCreateRowSorter(true);
        this.regionTable.addMouseListener(new IGVMouseInputAdapter(){

            @Override
            public void igvMouseClicked(MouseEvent e) {
                RegionNavigatorDialog.this.regionTableMouseClicked(e);
            }
        });
        this.scrollPane1.setViewportView(this.regionTable);
        this.contentPanel.add((Component)this.scrollPane1, "Center");
        this.panel1.setLayout(new BoxLayout(this.panel1, 1));
        this.panel2.setBorder(LineBorder.createBlackLineBorder());
        this.panel2.setLayout(new FlowLayout(0));
        this.viewButton.setText("View");
        this.viewButton.setAction(this.viewAction);
        this.viewButton.setActionCommand("View");
        this.panel2.add(this.viewButton);
        this.checkBoxZoomWhenNav.setText("Zoom to Region");
        this.checkBoxZoomWhenNav.setToolTipText("When navigating to a region, change zoom level?");
        this.checkBoxZoomWhenNav.setSelected(true);
        this.panel2.add(this.checkBoxZoomWhenNav);
        this.panel1.add(this.panel2);
        this.panel4.setBorder(LineBorder.createBlackLineBorder());
        this.panel4.setLayout(new FlowLayout(0));
        this.label1.setText("Search");
        this.panel4.add(this.label1);
        this.textFieldSearch.setToolTipText("Search for regions containing the specified description text.");
        this.textFieldSearch.setPreferredSize(new Dimension(200, 28));
        this.panel4.add(this.textFieldSearch);
        this.clearSearchButton.setAction(this.cancelAction);
        this.clearSearchButton.setText("Clear Search");
        this.panel4.add(this.clearSearchButton);
        this.panel1.add(this.panel4);
        this.contentPanel.add((Component)this.panel1, "South");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class RegionTablePopupHandler
    extends MouseAdapter {
        private static final int MAX_SEQUENCE_LENGTH = 1000000;

        private RegionTablePopupHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                Point p = e.getPoint();
                int row = RegionNavigatorDialog.this.regionTable.getRowSorter().convertRowIndexToModel(RegionNavigatorDialog.this.regionTable.rowAtPoint(p));
                int col = RegionNavigatorDialog.this.regionTable.columnAtPoint(p);
                if (row >= 0 && col >= 0) {
                    final String chr = (String)RegionNavigatorDialog.this.regionTableModel.getValueAt(row, 0);
                    final int start = (Integer)RegionNavigatorDialog.this.regionTableModel.getValueAt(row, 1) - 1;
                    final int end = (Integer)RegionNavigatorDialog.this.regionTableModel.getValueAt(row, 2) - 1;
                    final String desc = (String)RegionNavigatorDialog.this.regionTableModel.getValueAt(row, 3);
                    IGVPopupMenu popupMenu = new IGVPopupMenu();
                    JMenuItem copySequenceItem = new JMenuItem("Copy Sequence");
                    copySequenceItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int length = end - start;
                            if (length > 1000000) {
                                JOptionPane.showMessageDialog(RegionNavigatorDialog.this, "Region is to large to copy sequence data.");
                            } else {
                                IGV.copySequenceToClipboard(GenomeManager.getInstance().getCurrentGenome(), chr, start, end, Strand.NONE);
                            }
                        }
                    });
                    popupMenu.add(copySequenceItem);
                    JMenuItem copyDetailsItem = new JMenuItem("Copy Details");
                    copyDetailsItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String details = chr + ":" + start + "-" + end;
                            if (desc != null && !desc.isEmpty()) {
                                details = details + ", " + desc;
                            }
                            StringUtils.copyTextToClipboard(details);
                        }
                    });
                    popupMenu.add(copyDetailsItem);
                    popupMenu.show(RegionNavigatorDialog.this.regionTable, p.x, p.y);
                }
            }
        }
    }

    private class ShowAllChromosomesCheckboxAction
    extends AbstractAction {
        private ShowAllChromosomesCheckboxAction() {
            this.putValue("Name", "Show All Chrs");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RegionNavigatorDialog.this.synchRegions();
            RegionNavigatorDialog.this.updateButtonsEnabled();
        }
    }

    private class ViewSelectedAction
    extends AbstractAction {
        private ViewSelectedAction() {
            this.putValue("Name", "View");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = RegionNavigatorDialog.this.regionTable.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                List<RegionOfInterest> selectedRegions = RegionNavigatorDialog.this.getSelectedRegions(selectedRows);
                ArrayList<String> loci = new ArrayList<String>(selectedRegions.size());
                if (RegionNavigatorDialog.this.checkBoxZoomWhenNav.isSelected() || selectedRegions.size() >= 2 || FrameManager.isGeneListMode()) {
                    for (RegionOfInterest roi : selectedRegions) {
                        loci.add(roi.getLocusString());
                    }
                } else {
                    RegionOfInterest roi = selectedRegions.get(0);
                    Range range = FrameManager.getDefaultFrame().getCurrentRange();
                    int length = range.getLength();
                    int start = roi.getCenter() - length / 2;
                    int end = start + length;
                    if (start < 0) {
                        end += Math.abs(start);
                        start = 0;
                    }
                    loci.add(new RegionOfInterest(roi.getChr(), start, end, roi.getDescription()).getLocusString());
                }
                GeneList geneList = new GeneList("Regions of Interest", loci, false);
                IGV.getInstance().setGeneList(geneList);
                IGV.getInstance().resetFrames();
            }
            RegionNavigatorDialog.this.updateButtonsEnabled();
        }
    }

    private class RemoveSelectedRegionsAction
    extends AbstractAction {
        private RemoveSelectedRegionsAction() {
            this.putValue("Name", "Remove");
            this.putValue("ShortDescription", "Remove all selected regions");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = RegionNavigatorDialog.this.regionTable.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                List<RegionOfInterest> selectedRegions = RegionNavigatorDialog.this.getSelectedRegions(selectedRows);
                IGV.getInstance().getSession().removeRegionsOfInterest(selectedRegions);
                RegionNavigatorDialog.this.synchRegions();
            } else {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "No regions have been selected for removal.", "Error", 1);
            }
            RegionNavigatorDialog.this.updateButtonsEnabled();
        }
    }

    private class AddRegionAction
    extends AbstractAction {
        private AddRegionAction() {
            this.putValue("Name", "Add");
            this.putValue("ShortDescription", "Add a new region");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String chr = FrameManager.getDefaultFrame().getChrName();
            if (FrameManager.isGeneListMode()) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "Regions cannot be created in gene list or split-screen views.", "Error", 1);
            } else if (chr == null || chr.isEmpty()) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "No chromosome is specified. Can't create a region without a chromosome.", "Error", 1);
            } else if (chr.equalsIgnoreCase("All")) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "Regions cannot be created in the All Chromosomes view.", "Error", 1);
            } else {
                Range r = FrameManager.getDefaultFrame().getCurrentRange();
                RegionOfInterest newRegion = new RegionOfInterest(r.getChr(), r.getStart(), r.getEnd(), "");
                IGV.getInstance().getSession().addRegionOfInterestWithNoListeners(newRegion);
            }
            RegionNavigatorDialog.this.updateButtonsEnabled();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Clear search box");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RegionNavigatorDialog.this.textFieldSearch.setText("");
        }
    }

    private class RegionTableSelectionListener
    implements ListSelectionListener {
        private RegionTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                List<RegionOfInterest> regions = RegionNavigatorDialog.this.retrieveRegionsAsList();
                int[] selectedRows = RegionNavigatorDialog.this.regionTable.getSelectedRows();
                if (selectedRows != null && selectedRows.length > 0 && regions.size() >= selectedRows.length) {
                    RegionOfInterest firstStartRegion = null;
                    RegionOfInterest lastEndRegion = null;
                    HashSet<String> selectedChrs = new HashSet<String>();
                    for (int selectedRowIndex : selectedRows) {
                        int selectedModelRow = RegionNavigatorDialog.this.regionTableRowSorter.convertRowIndexToModel(selectedRowIndex);
                        RegionOfInterest region = regions.get(selectedModelRow);
                        selectedChrs.add(region.getChr());
                        if (firstStartRegion == null || region.getStart() < firstStartRegion.getStart()) {
                            firstStartRegion = region;
                        }
                        if (lastEndRegion != null && region.getEnd() <= lastEndRegion.getEnd()) continue;
                        lastEndRegion = region;
                    }
                    if (selectedChrs.size() > 1) {
                        return;
                    }
                }
            }
        }
    }

    private class RegionTableModelListener
    implements TableModelListener {
        private RegionTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (RegionNavigatorDialog.this.synchingRegions) {
                return;
            }
            List<RegionOfInterest> regions = RegionNavigatorDialog.this.retrieveRegionsAsList();
            int firstRow = e.getFirstRow();
            if (firstRow > regions.size() - 1) {
                return;
            }
            for (int i = firstRow; i <= Math.max(firstRow, Math.min(RegionNavigatorDialog.this.regionTable.getRowCount(), e.getLastRow())); ++i) {
                RegionNavigatorDialog.this.updateROIFromRegionTable(i);
            }
        }
    }

    private class RegionRowFilter
    extends RowFilter<TableModel, Object> {
        @Override
        public boolean include(RowFilter.Entry entry) {
            return RegionNavigatorDialog.this.shouldIncludeRegion((String)entry.getValue(0), (String)entry.getValue(3));
        }
    }

    private class SearchFieldDocumentListener
    implements DocumentListener {
        private SearchFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            System.err.println("This should not happen");
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RegionNavigatorDialog.this.regionTableModel.fireTableDataChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RegionNavigatorDialog.this.regionTableModel.fireTableDataChanged();
        }
    }
}

