/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.ViewChange;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.CytobandRenderer;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IGVMouseInputAdapter;

public class CytobandPanel
extends JPanel
implements IGVEventObserver {
    private static int bandHeight = 10;
    private boolean isDragging = false;
    private double viewOrigin;
    private double viewEnd;
    double cytobandScale;
    ReferenceFrame frame;
    private CytobandRenderer cytobandRenderer;
    private List<Cytoband> currentCytobands;

    public CytobandPanel(ReferenceFrame frame) {
        this(frame, true);
    }

    public CytobandPanel(ReferenceFrame frame, boolean mouseable) {
        this.frame = frame;
        this.viewOrigin = frame.getOrigin();
        this.viewEnd = frame.getEnd();
        if (mouseable) {
            this.initMouseAdapter();
        }
        this.cytobandRenderer = new CytobandRenderer();
        IGVEventBus.getInstance().subscribe(ViewChange.class, this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (PreferencesManager.getPreferences().getAntiAliasing()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.frame.getChrName().equals("All") || this.getWidth() < 10) {
            return;
        }
        int dataPanelWidth = this.getWidth();
        Rectangle cytoRect = new Rectangle(0, 10, dataPanelWidth, bandHeight);
        Chromosome chromosome = this.getReferenceFrame().getChromosome();
        if (chromosome == null) {
            return;
        }
        this.currentCytobands = chromosome.getCytobands();
        if (this.currentCytobands == null) {
            return;
        }
        this.cytobandRenderer.drawIdeogram(this.currentCytobands, g, cytoRect, this.frame);
        int chromosomeLength = this.getReferenceFrame().getMaxCoordinate();
        this.cytobandScale = (double)chromosomeLength / (double)dataPanelWidth;
        if (this.getReferenceFrame().getZoom() > 0) {
            double origin = this.viewOrigin;
            double end = this.viewEnd;
            int pixelStart = (int)(origin / this.cytobandScale);
            int pixelEnd = (int)(end / this.cytobandScale);
            int pixelSpan = Math.max(0, pixelEnd - pixelStart);
            int height = (int)cytoRect.getHeight();
            g.setColor(Color.RED);
            int y = (int)cytoRect.getY() + 5;
            g.drawRect(pixelStart, y, pixelSpan, height);
            g.drawRect(pixelStart - 1, y - 1, pixelSpan + 2, height + 2);
            g.drawRect(pixelStart - 2, y - 2, pixelSpan + 4, height + 4);
            if (pixelSpan < 2) {
                g.drawRect(pixelStart - 2, y - 2, pixelSpan + 4, height + 4);
            }
        }
    }

    private void initMouseAdapter() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setToolTipText("<html>Click anywhere on the chromosome<br/>to center view at that location.");
        IGVMouseInputAdapter mouseAdapter = new IGVMouseInputAdapter(){
            int lastMousePressX;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void igvMouseClicked(MouseEvent e) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                int mouseX = e.getX();
                int clickCount = e.getClickCount();
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    double newLocation = CytobandPanel.this.cytobandScale * (double)mouseX;
                    if (clickCount > 1) {
                        int newZoom = CytobandPanel.this.getReferenceFrame().getZoom() + 1;
                        CytobandPanel.this.getReferenceFrame().doSetZoomCenter(newZoom, newLocation);
                    } else {
                        CytobandPanel.this.getReferenceFrame().centerOnLocation(newLocation);
                    }
                    ViewChange result = ViewChange.Result();
                    result.setRecordHistory(true);
                    IGVEventBus.getInstance().post(result);
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.lastMousePressX = e.getX();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                if (CytobandPanel.this.isDragging) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        CytobandPanel.this.getReferenceFrame().setOrigin(CytobandPanel.this.viewOrigin);
                        CytobandPanel.this.getReferenceFrame().recordHistory();
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                    ViewChange result = ViewChange.Result();
                    result.setRecordHistory(true);
                    IGVEventBus.getInstance().post(result);
                }
                CytobandPanel.this.isDragging = false;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                CytobandPanel.this.isDragging = true;
                int x = e.getX();
                int delta = x - this.lastMousePressX;
                if (delta != 0 && CytobandPanel.this.cytobandScale > 0.0) {
                    double chrLength = CytobandPanel.this.frame.getChromosomeLength();
                    double deltaBP = Math.min(Math.max(-CytobandPanel.this.viewOrigin, (double)delta * CytobandPanel.this.cytobandScale), chrLength - CytobandPanel.this.viewEnd);
                    CytobandPanel.this.viewOrigin += deltaBP;
                    CytobandPanel.this.viewEnd += deltaBP;
                    CytobandPanel.this.repaint();
                }
                this.lastMousePressX = x;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private ReferenceFrame getReferenceFrame() {
        return this.frame;
    }

    @Override
    public void receiveEvent(Object e) {
        if (e instanceof ViewChange) {
            ViewChange event = (ViewChange)e;
            if (event.type == ViewChange.Type.ChromosomeChange || event.type == ViewChange.Type.LocusChange) {
                this.viewOrigin = this.frame.getOrigin();
                this.viewEnd = this.frame.getEnd();
            }
        }
    }
}

