/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.samtools.util.LocationAware;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.variant.vcf.VCFVariant;

public class BCF2WrapperCodec
implements FeatureCodec<VCFVariant, PositionalBufferedStream> {
    private static Logger log = LogManager.getLogger(BCF2WrapperCodec.class);
    FeatureCodec<VariantContext, PositionalBufferedStream> wrappedCodec;
    Genome genome;

    public BCF2WrapperCodec(FeatureCodec<VariantContext, PositionalBufferedStream> wrappedCodec, Genome genome) {
        this.wrappedCodec = wrappedCodec;
        this.genome = genome;
    }

    public VCFVariant decode(PositionalBufferedStream stream) throws IOException {
        VariantContext vc = (VariantContext)this.wrappedCodec.decode((Object)stream);
        if (vc == null) {
            return null;
        }
        String chr = this.genome == null ? vc.getChr() : this.genome.getCanonicalChrName(vc.getChr());
        return new VCFVariant(vc, chr);
    }

    public Feature decodeLoc(PositionalBufferedStream stream) throws IOException {
        return this.wrappedCodec.decodeLoc((Object)stream);
    }

    public FeatureCodecHeader readHeader(PositionalBufferedStream stream) throws IOException {
        return this.wrappedCodec.readHeader((Object)stream);
    }

    public Class<VCFVariant> getFeatureType() {
        return VCFVariant.class;
    }

    public boolean canDecode(String path) {
        return path.endsWith(".bcf");
    }

    public LocationAware makeIndexableSourceFromStream(InputStream bufferedInputStream) {
        PositionalBufferedStream pbs = bufferedInputStream instanceof PositionalBufferedStream ? (PositionalBufferedStream)bufferedInputStream : new PositionalBufferedStream(bufferedInputStream);
        return new AsciiLineReaderIterator(new AsciiLineReader(pbs));
    }

    public boolean isDone(PositionalBufferedStream positionalBufferedStream) {
        try {
            return positionalBufferedStream.isDone();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public void close(PositionalBufferedStream positionalBufferedStream) {
        positionalBufferedStream.close();
    }

    public PositionalBufferedStream makeSourceFromStream(InputStream bufferedInputStream) {
        return new PositionalBufferedStream(bufferedInputStream);
    }
}

