/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import it.unimi.dsi.lang.MutableString;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public final class ICBStringUtils {
    private static final String HTML_AMP = "&amp;";
    private static final String HTML_SINGLE_QUOTE = "&apos;";
    private static final String HTML_DOUBLE_QUOTE = "&quot;";
    private static final String HTML_LESS_THAN = "&lt;";
    private static final String HTML_GREATER_THAN = "&gt;";
    private static final String XML_NEWLINE = "&#10;";
    private static final String XML_CR = "&#13;";
    public static int RANDOM_STRING_LENGTH_DEFAULT = 7;
    private static final Map<String, String> HTML_TO_CONSOLE_MAP = new HashMap<String, String>();
    private static final Map<String, String> CONSOLE_TO_HTML_MAP;
    private static final String NO_BREAK_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789[]();:";

    private ICBStringUtils() {
    }

    public static String stripExtraSpaces(String x) {
        if (x == null || x.length() == 0) {
            return x;
        }
        return x.replaceAll("\t", " ").replaceAll(" {2,}", " ").trim();
    }

    public static String htmlFix(String inval) {
        if (StringUtils.isEmpty((String)inval)) {
            return "";
        }
        String outval = StringUtils.replace((String)inval, (String)"&", (String)HTML_AMP);
        outval = StringUtils.replace((String)outval, (String)"'", (String)HTML_SINGLE_QUOTE);
        outval = StringUtils.replace((String)outval, (String)"\"", (String)HTML_DOUBLE_QUOTE);
        outval = StringUtils.replace((String)outval, (String)"<", (String)HTML_LESS_THAN);
        outval = StringUtils.replace((String)outval, (String)">", (String)HTML_GREATER_THAN);
        return outval;
    }

    public static String xmlFix(String inval) {
        if (StringUtils.isBlank((String)inval)) {
            return "";
        }
        String outval = StringUtils.replace((String)inval, (String)"&", (String)HTML_AMP);
        outval = StringUtils.replace((String)outval, (String)"\"", (String)HTML_DOUBLE_QUOTE);
        outval = StringUtils.replace((String)outval, (String)"<", (String)HTML_LESS_THAN);
        outval = StringUtils.replace((String)outval, (String)">", (String)HTML_GREATER_THAN);
        outval = StringUtils.replace((String)outval, (String)"\n", (String)XML_NEWLINE);
        outval = StringUtils.replace((String)outval, (String)"\r", (String)XML_CR);
        return outval;
    }

    public static String urlFix(String toEncode) {
        String outval = StringUtils.replace((String)toEncode, (String)"%", (String)"%25");
        outval = StringUtils.replace((String)outval, (String)"$", (String)"%24");
        outval = StringUtils.replace((String)outval, (String)"&", (String)"%26");
        outval = StringUtils.replace((String)outval, (String)"+", (String)"%2B");
        outval = StringUtils.replace((String)outval, (String)",", (String)"%2C");
        outval = StringUtils.replace((String)outval, (String)"/", (String)"%2F");
        outval = StringUtils.replace((String)outval, (String)":", (String)"%3A");
        outval = StringUtils.replace((String)outval, (String)";", (String)"%3B");
        outval = StringUtils.replace((String)outval, (String)"=", (String)"%3D");
        outval = StringUtils.replace((String)outval, (String)"?", (String)"%3F");
        outval = StringUtils.replace((String)outval, (String)"@", (String)"%40");
        outval = StringUtils.replace((String)outval, (String)" ", (String)"%20");
        outval = StringUtils.replace((String)outval, (String)"\"", (String)"%22");
        outval = StringUtils.replace((String)outval, (String)"<", (String)"%3C");
        outval = StringUtils.replace((String)outval, (String)">", (String)"%3E");
        outval = StringUtils.replace((String)outval, (String)"#", (String)"%23");
        outval = StringUtils.replace((String)outval, (String)"{", (String)"%7B");
        outval = StringUtils.replace((String)outval, (String)"}", (String)"%7D");
        outval = StringUtils.replace((String)outval, (String)"|", (String)"%7C");
        outval = StringUtils.replace((String)outval, (String)"\\", (String)"%5C");
        outval = StringUtils.replace((String)outval, (String)"^", (String)"%5E");
        outval = StringUtils.replace((String)outval, (String)"~", (String)"%7E");
        outval = StringUtils.replace((String)outval, (String)"[", (String)"%5B");
        outval = StringUtils.replace((String)outval, (String)"]", (String)"%5D");
        outval = StringUtils.replace((String)outval, (String)"`", (String)"%60");
        return outval;
    }

    public static String modifyFilename(String origFilename, String[] extensions, String mod) {
        if (StringUtils.isBlank((String)origFilename)) {
            return mod;
        }
        String foundExt = null;
        if (extensions != null) {
            for (String ext : extensions) {
                if (!origFilename.endsWith(ext)) continue;
                foundExt = ext;
                break;
            }
        }
        if (foundExt == null) {
            return origFilename + mod;
        }
        return origFilename.substring(0, origFilename.length() - foundExt.length()) + mod + foundExt;
    }

    public static String highlightString(String toHighlight, String highlightWord, String highlightStart, String highlightEnd) {
        String[] highlightWords = new String[]{highlightWord};
        return ICBStringUtils.highlightStrings(toHighlight, highlightWords, highlightStart, highlightEnd);
    }

    public static String highlightStrings(String toHighlight, String[] highlightWords, String highlightStart, String highlightEnd) {
        if (StringUtils.isBlank((String)toHighlight)) {
            return toHighlight;
        }
        String[] cleanHighlightWords = ICBStringUtils.cleanStringArray(highlightWords);
        if (cleanHighlightWords == null || cleanHighlightWords.length == 0) {
            return toHighlight;
        }
        for (int i = 0; i < cleanHighlightWords.length; ++i) {
            cleanHighlightWords[i] = cleanHighlightWords[i].toLowerCase();
        }
        if (StringUtils.isBlank((String)highlightStart) && StringUtils.isBlank((String)highlightEnd)) {
            return toHighlight;
        }
        StringBuilder input = new StringBuilder(toHighlight);
        StringBuilder inputLC = new StringBuilder(toHighlight.toLowerCase());
        StringBuilder output = new StringBuilder();
        StringBuilder tagStart = highlightStart == null ? new StringBuilder() : new StringBuilder(highlightStart);
        StringBuilder tagEnd = highlightEnd == null ? new StringBuilder() : new StringBuilder(highlightEnd);
        while (input.length() != 0) {
            int pos = -1;
            int size = -1;
            for (String toFind : cleanHighlightWords) {
                int curPos = inputLC.indexOf(toFind);
                if (curPos == -1) continue;
                if (pos == -1) {
                    pos = curPos;
                    size = toFind.length();
                    continue;
                }
                if (curPos >= pos) continue;
                pos = curPos;
                size = toFind.length();
            }
            if (pos == -1) {
                output.append((CharSequence)input);
                break;
            }
            assert (size > 0);
            if (pos > 0) {
                output.append(input.substring(0, pos));
            }
            output.append((CharSequence)tagStart);
            output.append(input.substring(pos, pos + size));
            output.append((CharSequence)tagEnd);
            input.delete(0, pos + size);
            inputLC.delete(0, pos + size);
        }
        return output.toString();
    }

    public static String[] cleanStringArray(String[] strings) {
        if (strings == null) {
            return null;
        }
        LinkedList<String> cleanList = new LinkedList<String>();
        for (String string : strings) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            cleanList.add(string);
        }
        return cleanList.toArray(new String[cleanList.size()]);
    }

    public static String millis2hms(long t) {
        if (t < 0L) {
            return "INVALID MILLISECONDS: " + t;
        }
        if (t < 1000L) {
            return t + "ms";
        }
        long s = t / 1000L % 60L;
        long m = t / 1000L / 60L % 60L;
        long h = t / 3600000L;
        if (h == 0L && m == 0L) {
            return s + "s";
        }
        if (h == 0L) {
            return m + "m " + s + "s";
        }
        return h + "h " + m + "m " + s + "s";
    }

    public static String[] split(String inval, char splitChar, Character escapeChar) {
        if (inval == null) {
            return null;
        }
        if (inval.length() == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Character escape = escapeChar;
        if (escape != null && escape.charValue() == splitChar) {
            escape = null;
        }
        LinkedList<String> output = new LinkedList<String>();
        int length = inval.length();
        StringBuilder curSplit = new StringBuilder();
        boolean inEscape = false;
        for (int i = 0; i < length; ++i) {
            char curChar = inval.charAt(i);
            if (!inEscape && curChar == splitChar) {
                output.add(curSplit.toString());
                curSplit.setLength(0);
                continue;
            }
            if (escape != null) {
                if (!inEscape && curChar == escape.charValue()) {
                    inEscape = true;
                    curSplit.append(curChar);
                    continue;
                }
                if (inEscape) {
                    inEscape = false;
                }
            }
            curSplit.append(curChar);
        }
        output.add(curSplit.toString());
        return output.toArray(new String[output.size()]);
    }

    public static String[] unescape(String[] inval, Character escapeChar) {
        if (inval != null && escapeChar != null && inval.length != 0) {
            for (int i = 0; i < inval.length; ++i) {
                inval[i] = ICBStringUtils.unescape(inval[i], escapeChar);
            }
        }
        return inval;
    }

    public static String unescape(String inval, Character escapeChar) {
        if (inval == null || escapeChar == null || inval.length() == 0) {
            return inval;
        }
        int length = inval.length();
        StringBuilder curSplit = new StringBuilder();
        boolean inEscape = false;
        for (int i = 0; i < length; ++i) {
            char curChar = inval.charAt(i);
            if (!inEscape && curChar == escapeChar.charValue()) {
                inEscape = true;
                continue;
            }
            if (inEscape) {
                inEscape = false;
            }
            curSplit.append(curChar);
        }
        return curSplit.toString();
    }

    public static String makeStringWrappable(String stringToBreak, int maxLength, String breakStr) {
        StringBuilder returnVal = new StringBuilder();
        if (stringToBreak != null) {
            String remain = stringToBreak.replaceAll("[\t|\n| ]+", " ").trim();
            if (remain.length() <= maxLength) {
                return remain;
            }
            int pos = maxLength;
            while (true) {
                if (pos < 0) {
                    pos = maxLength;
                    returnVal.append(remain.substring(0, pos)).append(breakStr);
                    remain = remain.substring(pos, remain.length());
                    if (remain.length() <= maxLength) {
                        returnVal.append(remain);
                        break;
                    }
                    pos = maxLength;
                    continue;
                }
                String curChar = remain.substring(pos, pos + 1).toLowerCase();
                if (!NO_BREAK_CHARS.contains(curChar)) {
                    returnVal.append(remain.substring(0, pos + 1)).append(breakStr);
                    remain = remain.substring(pos + 1, remain.length());
                    if (remain.length() <= maxLength) {
                        returnVal.append(remain);
                        break;
                    }
                    pos = maxLength;
                    continue;
                }
                --pos;
            }
        }
        return returnVal.toString();
    }

    public static String htmlToConsole(String html) {
        if (StringUtils.isBlank((String)html)) {
            return "";
        }
        String work = html;
        for (String htmlVal : HTML_TO_CONSOLE_MAP.keySet()) {
            String replaceVal = HTML_TO_CONSOLE_MAP.get(htmlVal);
            work = StringUtils.replace((String)work, (String)htmlVal, (String)replaceVal);
        }
        return work;
    }

    public static String consoleToHtml(String console) {
        if (StringUtils.isBlank((String)console)) {
            return "";
        }
        String work = console;
        for (String consoleVal : CONSOLE_TO_HTML_MAP.keySet()) {
            String replaceVal = HTML_TO_CONSOLE_MAP.get(consoleVal);
            work = StringUtils.replace((String)work, (String)consoleVal, (String)replaceVal);
        }
        return work;
    }

    public static String generateRandomString() {
        return ICBStringUtils.generateRandomString(RANDOM_STRING_LENGTH_DEFAULT);
    }

    public static String generateRandomString(int length) {
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)false).toUpperCase();
    }

    public static String safeFilename(String inval) {
        if (StringUtils.isBlank((String)inval)) {
            return "";
        }
        String outval = inval.trim();
        outval = StringUtils.replace((String)outval, (String)" ", (String)"-");
        while (outval.contains("--")) {
            outval = StringUtils.replace((String)outval, (String)"--", (String)"-");
        }
        outval = outval.replaceAll("[^a-zA-Z0-9\\-._]", "_");
        while (outval.contains("__")) {
            outval = StringUtils.replace((String)outval, (String)"__", (String)"_");
        }
        return outval;
    }

    public static String humanMemorySize(long bytes) {
        return ICBStringUtils.humanMemorySize(bytes, 1024);
    }

    public static String humanMemorySize(long bytes, int unit) {
        MutableString result = new MutableString();
        if (bytes < (long)unit) {
            result.append(bytes);
            result.append(" B");
        } else {
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            result.append(String.format("%.1f", (double)bytes / Math.pow(unit, exp)));
            if (result.endsWith(".0")) {
                result.length(result.length() - 2);
            }
            result.append(' ');
            result.append("KMGTPE".charAt(exp - 1));
            result.append('B');
        }
        return result.toString();
    }

    static {
        HTML_TO_CONSOLE_MAP.put("<br/>", "\n");
        HTML_TO_CONSOLE_MAP.put("<BR/>", "\n");
        HTML_TO_CONSOLE_MAP.put("<hr/>", "--------------------------\n");
        HTML_TO_CONSOLE_MAP.put("<HR/>", "--------------------------\n");
        HTML_TO_CONSOLE_MAP.put("<ul>", "\n");
        HTML_TO_CONSOLE_MAP.put("<UL>", "\n");
        HTML_TO_CONSOLE_MAP.put("</ul>", "\n");
        HTML_TO_CONSOLE_MAP.put("</UL>", "\n");
        HTML_TO_CONSOLE_MAP.put("<li>", "\n* ");
        HTML_TO_CONSOLE_MAP.put("<LI>", "\n* ");
        HTML_TO_CONSOLE_MAP.put("</li>", "");
        HTML_TO_CONSOLE_MAP.put("</LI>", "");
        HTML_TO_CONSOLE_MAP.put("<p>", "\n\n");
        HTML_TO_CONSOLE_MAP.put("<P>", "\n\n");
        HTML_TO_CONSOLE_MAP.put("</p>", "");
        HTML_TO_CONSOLE_MAP.put("</P>", "");
        CONSOLE_TO_HTML_MAP = new HashMap<String, String>();
        CONSOLE_TO_HTML_MAP.put("\n".toLowerCase(), "<br/>");
        CONSOLE_TO_HTML_MAP.put("\t".toLowerCase(), "&nbsp;");
        CONSOLE_TO_HTML_MAP.put(" ".toLowerCase(), "\"&nbsp;\"&nbsp;\"&nbsp;\"&nbsp;");
    }
}

