/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.vcf;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.vcf.VCFAllele;
import org.broad.igv.variant.vcf.VCFGenotype;

public class VCFVariant
implements Variant {
    private static Logger log = LogManager.getLogger(Variant.class);
    VariantContext variantContext;
    List<Allele> alternateAlleles;
    String chr;
    private double[] alleleFreqs;
    private int[] alleleCounts;
    private double methylationRate = Double.NaN;
    private double coveredSampleFraction = Double.NaN;
    Map<String, VCFGenotype> genotypeMap;
    private int start = -1;
    private int totalAlleleCount = 0;

    public VCFVariant(VariantContext variantContext, String chr) {
        this.variantContext = variantContext;
        this.chr = chr;
        this.init();
    }

    private void init() {
        String anKey;
        String anString;
        this.genotypeMap = new HashMap<String, VCFGenotype>();
        for (String sample : this.getSampleNames()) {
            String[] genotype = this.variantContext.getGenotype(sample);
            VCFGenotype vcfGenotype = genotype == null ? null : new VCFGenotype((htsjdk.variant.variantcontext.Genotype)genotype);
            this.genotypeMap.put(sample, vcfGenotype);
        }
        String afString = null;
        String[] alleleFreqKeys = new String[]{"AF", "GMAF"};
        try {
            for (String alleleFreqKey : alleleFreqKeys) {
                afString = this.variantContext.getAttributeAsString(alleleFreqKey, "-1");
                this.alleleFreqs = this.parseDoubleArrayString(afString);
                if (!(this.alleleFreqs[0] >= 0.0)) {
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException e) {
            this.alleleFreqs = new double[]{-1.0};
            log.error("Error parsing allele frequency: " + afString);
        }
        String acKey = "AC";
        String acString = this.variantContext.getAttributeAsString(acKey, null);
        if (acString != null) {
            try {
                this.alleleCounts = this.parseIntArrayString(acString);
            }
            catch (NumberFormatException e) {
                log.error("Error parsing allele counts:" + acString);
            }
        }
        if ((anString = this.variantContext.getAttributeAsString(anKey = "AN", null)) != null) {
            try {
                this.totalAlleleCount = Integer.parseInt(anString);
            }
            catch (NumberFormatException e) {
                log.error("Error parsing 'AN' attribute: " + anString);
            }
        }
    }

    private double[] parseDoubleArrayString(String afString) throws NumberFormatException {
        afString = afString.replaceAll("[\\[\\]\\(\\)]", "");
        String[] tokens = afString.split(",");
        double[] result = new double[tokens.length];
        for (int ii = 0; ii < tokens.length; ++ii) {
            result[ii] = Double.parseDouble(tokens[ii].trim());
        }
        return result;
    }

    private int[] parseIntArrayString(String afString) throws NumberFormatException {
        afString = afString.replaceAll("[\\[\\]\\(\\)]", "");
        String[] tokens = afString.split(",");
        int[] result = new int[tokens.length];
        for (int ii = 0; ii < tokens.length; ++ii) {
            result[ii] = Integer.parseInt(tokens[ii].trim());
        }
        return result;
    }

    private void computeMethylationRate() {
        double methTotal = 0.0;
        int samplesWithData = 0;
        int size = this.getSampleNames().size();
        if (size > 0) {
            for (String sample : this.getSampleNames()) {
                Genotype genotype = this.getGenotype(sample);
                double mr = genotype.getAttributeAsDouble("MR");
                double goodBaseCount = genotype.getAttributeAsDouble("MR");
                if (Double.isNaN(mr) || Double.isNaN(goodBaseCount) || !(goodBaseCount > (double)VariantTrack.METHYLATION_MIN_BASE_COUNT)) continue;
                methTotal += mr;
                ++samplesWithData;
            }
            this.methylationRate = samplesWithData == 0 ? 0.0 : methTotal / (double)samplesWithData;
            this.coveredSampleFraction = (double)samplesWithData / (double)size;
        }
    }

    @Override
    public String getID() {
        return this.variantContext.getID();
    }

    @Override
    public boolean isFiltered() {
        return this.variantContext.isFiltered();
    }

    @Override
    public String getAttributeAsString(String key) {
        return this.variantContext.getAttributeAsString(key, null);
    }

    @Override
    public String getReference() {
        return this.variantContext.getReference().toString();
    }

    @Override
    public List<Allele> getAlternateAlleles() {
        if (this.alternateAlleles == null) {
            List tmp = this.variantContext.getAlternateAlleles();
            this.alternateAlleles = new ArrayList<Allele>(tmp.size());
            for (htsjdk.variant.variantcontext.Allele a : tmp) {
                this.alternateAlleles.add(new VCFAllele(a.getBases()));
            }
        }
        return this.alternateAlleles;
    }

    @Override
    public double getPhredScaledQual() {
        return this.variantContext.getPhredScaledQual();
    }

    @Override
    public boolean hasLog10PError() {
        return this.variantContext.hasLog10PError();
    }

    @Override
    public String getType() {
        return this.variantContext.getType().toString();
    }

    @Override
    public double[] getAlleleFreqs() {
        return this.alleleFreqs;
    }

    @Override
    public double getAlternateAlleleFrequency() {
        double af = 0.0;
        double[] afreqs = this.getAlleleFreqs();
        if (afreqs != null) {
            for (int i = 0; i < afreqs.length; ++i) {
                af += afreqs[i];
            }
        }
        return af;
    }

    @Override
    public int[] getAlleleCounts() {
        return this.alleleCounts;
    }

    @Override
    public int getTotalAlleleCount() {
        return this.totalAlleleCount;
    }

    @Override
    public double getAlleleFraction() {
        if (this.alleleCounts != null && this.alleleCounts.length > 0 && this.totalAlleleCount > 0) {
            double ac = 0.0;
            for (int i = 0; i < this.alleleCounts.length; ++i) {
                ac += (double)this.alleleCounts[i];
            }
            return ac / (double)this.totalAlleleCount;
        }
        return -1.0;
    }

    @Override
    public double getMethlationRate() {
        if (Double.isNaN(this.methylationRate)) {
            this.computeMethylationRate();
        }
        return this.methylationRate;
    }

    @Override
    public double getCoveredSampleFraction() {
        if (Double.isNaN(this.coveredSampleFraction)) {
            this.computeMethylationRate();
        }
        return this.coveredSampleFraction;
    }

    @Override
    public Collection<String> getSampleNames() {
        return this.variantContext.getSampleNames();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.variantContext.getAttributes();
    }

    @Override
    public Genotype getGenotype(String sample) {
        return this.genotypeMap.get(sample);
    }

    @Override
    public Collection<String> getFilters() {
        return this.variantContext.getFilters();
    }

    public String getChr() {
        return this.chr;
    }

    public String getContig() {
        return this.chr;
    }

    public int getStart() {
        if (this.start < 0) {
            this.calcStart();
        }
        return this.start;
    }

    public int getEnd() {
        String chr2 = this.variantContext.getAttributeAsString("CHR2", null);
        if (chr2 != null) {
            Genome genome = GenomeManager.getInstance().getCurrentGenome();
            String string = chr2 = genome == null ? chr2 : genome.getCanonicalChrName(chr2);
        }
        if (chr2 == null || chr2.equals(this.getChr())) {
            return this.variantContext.getEnd();
        }
        return this.start + 1;
    }

    public String toString() {
        return String.format("VCFVariant[%s:%d-%d]", this.getChr(), this.getStart(), this.getEnd());
    }

    @Override
    public String getPositionString() {
        if (this.variantContext.getStart() == this.variantContext.getEnd()) {
            return String.valueOf(this.variantContext.getStart());
        }
        String chr2 = this.variantContext.getAttributeAsString("CHR2", null);
        if (chr2 == null || chr2.equals(this.getChr())) {
            return String.format("%d-%d", this.variantContext.getStart(), this.variantContext.getEnd());
        }
        return String.format("%s:%d-%s:%d", this.getChr(), this.variantContext.getStart(), chr2, this.variantContext.getEnd());
    }

    public String getSource() {
        return this.variantContext.getSource();
    }

    public VariantContext getVariantContext() {
        return this.variantContext;
    }

    public static VariantContext getVariantContext(Variant variant) {
        if (variant instanceof VCFVariant) {
            return ((VCFVariant)variant).getVariantContext();
        }
        ArrayList<htsjdk.variant.variantcontext.Allele> alleleList = new ArrayList<htsjdk.variant.variantcontext.Allele>(variant.getAlternateAlleles().size() + 1);
        alleleList.add(htsjdk.variant.variantcontext.Allele.create((String)variant.getReference(), (boolean)true));
        for (Allele all : variant.getAlternateAlleles()) {
            alleleList.add(htsjdk.variant.variantcontext.Allele.create((byte[])all.getBases(), (boolean)false));
        }
        VariantContextBuilder vcb = new VariantContextBuilder(variant.getID(), variant.getChr(), (long)variant.getStart(), (long)variant.getEnd(), alleleList);
        return vcb.make();
    }

    private void calcStart() {
        int prefixLength = 0;
        if (this.variantContext.getType() == VariantContext.Type.INDEL || this.variantContext.getType() == VariantContext.Type.MIXED) {
            prefixLength = this.findCommonPrefixLength();
        }
        this.start = this.variantContext.getStart() - 1 + prefixLength;
    }

    private int findCommonPrefixLength() {
        String ref = this.variantContext.getReference().getDisplayString();
        int prefixLength = 0;
        boolean foundmisMatch = false;
        for (int refPos = 0; refPos < ref.length(); ++refPos) {
            char refChar = ref.charAt(refPos);
            for (Allele var : this.getAlternateAlleles()) {
                byte[] varBases = var.getBases();
                if (refPos < varBases.length && varBases[refPos] == refChar) continue;
                foundmisMatch = true;
                break;
            }
            if (foundmisMatch) break;
            ++prefixLength;
        }
        return prefixLength;
    }
}

