/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broad.igv.gwas.GWASParser;
import org.broad.igv.tools.sort.AsciiSorter;
import org.broad.igv.tools.sort.Parser;

public class GWASSorter
extends AsciiSorter {
    static Logger log = LogManager.getLogger(GWASSorter.class);
    List<String> headerLines = new ArrayList<String>();
    private GWASParser.GWASColumns columns = new GWASParser.GWASColumns();

    public GWASSorter(File inputFile, File outputFile) {
        super(inputFile, outputFile);
        this.findColumns(inputFile);
    }

    private void findColumns(File inputFile) {
        BufferedReader br = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(inputFile));
            while ((nextLine = br.readLine()) != null) {
                this.headerLines.add(nextLine);
                if (nextLine.startsWith("#")) continue;
                this.columns.parseHeader(nextLine);
                break;
            }
            if (this.columns.chrCol < 0) {
                throw new RuntimeException("Could not find chromosome column");
            }
            if (this.columns.locationCol < 0) {
                throw new RuntimeException("Could not find start column");
            }
        }
        catch (IOException e) {
            log.error("Error reading GWAS file", (Throwable)e);
            throw new RuntimeException("Error reading GWAS file" + e.getMessage(), e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    Parser getParser() {
        return new Parser(this.columns.chrCol, this.columns.locationCol, true);
    }

    @Override
    String writeHeader(AsciiLineReader reader, PrintWriter writer) throws IOException {
        String nextLine;
        while ((nextLine = reader.readLine()) != null) {
            writer.println(nextLine);
            if (nextLine.startsWith("#")) continue;
            break;
        }
        return null;
    }
}

