/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.iterators;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class TextFileLineIterator
implements Iterable<String>,
Closeable {
    private final BufferedReader in;
    private boolean closed = false;

    public TextFileLineIterator(String filenameToRead) throws IOException {
        this(new File(filenameToRead));
    }

    public TextFileLineIterator(File fileToRead) throws IOException {
        this(fileToRead.toString().toLowerCase().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(fileToRead)) : new FileInputStream(fileToRead));
    }

    public TextFileLineIterator(InputStream stream) {
        this.in = new BufferedReader(new InputStreamReader(stream));
    }

    @Override
    public Iterator<String> iterator() {
        return new TextFileIterator();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.closeQuietly((Reader)this.in);
            this.closed = true;
        }
    }

    class TextFileIterator
    implements Iterator<String> {
        private String nextline;

        public TextFileIterator() {
            try {
                this.nextline = TextFileLineIterator.this.in.readLine();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextline != null;
        }

        @Override
        public String next() {
            try {
                String result = this.nextline;
                if (this.nextline != null) {
                    this.nextline = TextFileLineIterator.this.in.readLine();
                    if (this.nextline == null) {
                        TextFileLineIterator.this.close();
                    }
                }
                return result;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

