/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.blat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.HttpUtils;

public class LegacyBlatClient {
    private static Logger log = Logger.getLogger(LegacyBlatClient.class);
    static int sleepTime = 15000;
    static String hgsid;
    static long lastQueryTime;

    static List<PSLRecord> blat(String userSeq) throws IOException {
        Genome genome;
        List<String> tokensList;
        String serverType = PreferencesManager.getPreferences().get("BLAT_SERVER_TYPE");
        if (serverType.equalsIgnoreCase("web_blat")) {
            tokensList = LegacyBlatClient.webBlat(userSeq);
        } else {
            genome = IGV.hasInstance() ? GenomeManager.getInstance().getCurrentGenome() : null;
            String db = genome.getId();
            String species = genome.getSpecies();
            if (species == null) {
                throw new RuntimeException("Cannot determine species name for genome: " + genome.getDisplayName());
            }
            tokensList = LegacyBlatClient.ucscBlat(species, db, userSeq);
        }
        genome = GenomeManager.getInstance().getCurrentGenome();
        PSLCodec codec = new PSLCodec(genome, true);
        ArrayList<PSLRecord> features = new ArrayList<PSLRecord>(tokensList.size());
        for (String tokens : tokensList) {
            PSLRecord f = codec.decode(tokens);
            if (f == null) continue;
            features.add(f);
        }
        return features;
    }

    private static List<String> ucscBlat(String org, String db, String userSeq) throws IOException {
        String result;
        String searchType = "DNA";
        String sortOrder = "query,score";
        String outputType = "psl";
        String $url = PreferencesManager.getPreferences().get("BLAT_URL").trim();
        String serverType = PreferencesManager.getPreferences().get("BLAT_SERVER_TYPE");
        if (serverType.equalsIgnoreCase("web_blat")) {
            String urlString = $url + "?&wb_qtype=" + searchType + "&wb_sort=" + sortOrder + "&wb_output=" + outputType + "&wb_seq=" + userSeq;
            result = HttpUtils.getInstance().getContentsAsString(new URL(urlString));
        } else {
            String urlString = $url + "?org=" + org + "&db=" + db + "&type=" + searchType + "&sort=" + sortOrder + "&output=" + outputType;
            if (hgsid != null) {
                urlString = urlString + "&hgsid=" + hgsid;
            }
            URL url = HttpUtils.createURL(urlString);
            long dt = System.currentTimeMillis() - lastQueryTime;
            if (dt < (long)sleepTime) {
                try {
                    Thread.sleep(dt);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            lastQueryTime = System.currentTimeMillis();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userSeq", userSeq);
            result = HttpUtils.getInstance().doPost(url, params);
        }
        return LegacyBlatClient.parseResult(result);
    }

    public static List<String> webBlat(String userSeq) throws IOException {
        String searchType = "DNA";
        String sortOrder = "query,score";
        String outputType = "psl";
        String $url = PreferencesManager.getPreferences().get("BLAT_URL").trim();
        String urlString = $url + "?&wb_qtype=" + searchType + "&wb_sort=" + sortOrder + "&wb_output=" + outputType + "&wb_seq=" + userSeq;
        log.info((Object)("BLAT: " + urlString));
        String result = HttpUtils.getInstance().getContentsAsString(new URL(urlString));
        List<String> records = LegacyBlatClient.parseResult(result);
        return LegacyBlatClient.fixWebBlat(records);
    }

    static List<String> fixWebBlat(List<String> records) {
        ArrayList<String> fixed = new ArrayList<String>(records.size());
        for (String line : records) {
            if (line.startsWith("#")) {
                fixed.add(line);
                continue;
            }
            Object fixedLine = "";
            String[] tokens = Globals.singleTabMultiSpacePattern.split(line);
            for (int i = 0; i < tokens.length; ++i) {
                int idx;
                if (i > 0) {
                    fixedLine = (String)fixedLine + "\t";
                }
                String t = tokens[i];
                if (i == 13 && (idx = t.indexOf(":")) > 0) {
                    t = t.substring(idx + 1);
                }
                fixedLine = (String)fixedLine + t;
            }
            fixed.add((String)fixedLine);
        }
        return fixed;
    }

    static List<String> parseResult(String result) throws IOException {
        String l;
        ArrayList<String> records = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(result));
        boolean pslSectionFound = false;
        boolean pslHeaderFound = false;
        while ((l = br.readLine()) != null) {
            String line = l.trim();
            String lowerCase = line.toLowerCase();
            if (pslHeaderFound) {
                if (lowerCase.contains("</tt>")) break;
                String[] tokens = Globals.whitespacePattern.split(line);
                if (tokens.length == 21) {
                    records.add(line);
                }
            }
            if (lowerCase.contains("<tt>") && lowerCase.contains("<pre>") && lowerCase.contains("pslayout")) {
                pslSectionFound = true;
                continue;
            }
            if (!pslSectionFound || !lowerCase.startsWith("-----------------------------")) continue;
            pslHeaderFound = true;
        }
        return records;
    }

    static {
        lastQueryTime = 0L;
    }
}

