/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import htsjdk.tribble.Feature;
import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IGVMouseInputAdapter;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;

public class SearchCommand {
    private static Logger log;
    public static int SEARCH_LIMIT;
    private boolean askUser = false;
    String searchString;
    ReferenceFrame referenceFrame;
    boolean recordHistory = true;
    Genome genome;
    private static HashMap<ResultType, String> tokenMatchers;

    public SearchCommand(ReferenceFrame referenceFrame, String searchString) {
        this(referenceFrame, searchString, GenomeManager.getInstance().getCurrentGenome());
    }

    public SearchCommand(ReferenceFrame referenceFrame, String searchString, boolean recordHistory) {
        this(referenceFrame, searchString);
        this.recordHistory = recordHistory;
    }

    SearchCommand(ReferenceFrame referenceFrame, String searchString, Genome genome) {
        this.referenceFrame = referenceFrame;
        this.searchString = searchString.trim();
        this.genome = genome;
    }

    public void execute() {
        List<SearchResult> results = this.runSearch(this.searchString);
        this.showSearchResult(results);
    }

    public List<SearchResult> runSearch(String searchString) {
        String[] tokens;
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        Set<ResultType> wholeStringType = this.checkTokenType(searchString = searchString.replace("\"", ""));
        if (wholeStringType.contains((Object)ResultType.LOCUS)) {
            results.add(this.calcChromoLocus(searchString));
            return results;
        }
        for (String s : tokens = searchString.split("\\s+")) {
            SearchResult result = this.parseToken(s);
            if (result != null) {
                results.add(result);
                continue;
            }
            SearchResult unknownResult = new SearchResult();
            unknownResult.setMessage("Unknown search term: " + s);
            results.add(unknownResult);
        }
        if (results.size() == 0) {
            SearchResult result = new SearchResult();
            result.setMessage("Invalid Search String: " + searchString);
            results.add(result);
        }
        return results;
    }

    public void showSearchResult(List<SearchResult> results) {
        int origZoom = this.referenceFrame.getZoom();
        if (results == null || results.size() == 0) {
            results = new ArrayList<SearchResult>();
            results.add(new SearchResult());
        }
        boolean showMessage = false;
        boolean success = true;
        Object message = "Invalid search string: " + this.searchString;
        boolean isGeneListMode = FrameManager.isGeneListMode();
        boolean resetFrames = false;
        if (results.size() == 1) {
            resetFrames = isGeneListMode;
            SearchResult result = results.get(0);
            if (result.type != ResultType.ERROR) {
                IGV.getInstance().getSession().setCurrentGeneList(null);
            }
            switch (result.type) {
                case FEATURE: {
                    this.showFlankedRegion(result.chr, result.start, result.end);
                    break;
                }
                case LOCUS: {
                    this.referenceFrame.jumpTo(result.chr, result.start, result.end);
                    break;
                }
                case CHROMOSOME: {
                    this.referenceFrame.changeChromosome(result.chr, true);
                    break;
                }
                default: {
                    message = "Cannot find feature or locus: " + this.searchString;
                    success = false;
                    showMessage = true;
                    break;
                }
            }
        } else {
            resetFrames = true;
            ArrayList<String> loci = new ArrayList<String>(results.size());
            message = "<html>";
            for (SearchResult res : results) {
                if (res.type != ResultType.ERROR) {
                    loci.add(res.getLocus());
                    continue;
                }
                message = (String)message + res.getMessage() + "<br>";
                showMessage = true;
            }
            GeneList geneList = new GeneList("", loci, false);
            IGV.getInstance().getSession().setCurrentGeneList(geneList);
        }
        if (resetFrames) {
            IGV.getInstance().resetFrames();
        } else {
            IGV.getInstance().repaint();
        }
        if (success && this.recordHistory) {
            IGV.getInstance().getSession().getHistory().push(this.searchString, origZoom);
        }
        if (showMessage) {
            MessageUtils.showMessage((String)message);
        }
    }

    public static Object[] getSelectionList(List<SearchResult> results, boolean longName) {
        ArrayList<String> options = new ArrayList<String>(Math.min(results.size(), SEARCH_LIMIT));
        for (SearchResult result : results) {
            if (result.type == ResultType.ERROR) continue;
            if (longName) {
                options.add(result.getLongName());
                continue;
            }
            options.add(result.getShortName());
        }
        return options.toArray();
    }

    Set<ResultType> checkTokenType(String token) {
        token = token.trim();
        HashSet<ResultType> possibles = new HashSet<ResultType>();
        for (ResultType type : tokenMatchers.keySet()) {
            if (!token.matches(tokenMatchers.get((Object)type))) continue;
            possibles.add(type);
        }
        return possibles;
    }

    private SearchResult parseToken(String token) {
        NamedFeature feat;
        Set<ResultType> types = this.checkTokenType(token);
        if (types.contains((Object)ResultType.LOCUS) || types.contains((Object)ResultType.CHROMOSOME)) {
            SearchResult result = this.calcChromoLocus(token);
            if (result.type != ResultType.ERROR) {
                return result;
            }
        }
        if (types.contains((Object)ResultType.FEATURE_MUT_AA) || types.contains((Object)ResultType.FEATURE_MUT_NT)) {
            Map<Integer, BasicFeature> genomePosList;
            String[] items = token.toUpperCase().split(":");
            String name = items[0].trim().toUpperCase();
            String coords = items[1];
            int coordLength = coords.length();
            if (types.contains((Object)ResultType.FEATURE_MUT_AA)) {
                String refSymbol = coords.substring(0, 1);
                String mutSymbol = coords.substring(coordLength - 1);
                String strLoc = coords.substring(1, coordLength - 1);
                int location = Integer.parseInt(strLoc) - 1;
                genomePosList = FeatureDB.getMutationAA(name, location + 1, refSymbol, mutSymbol, this.genome);
            } else if (types.contains((Object)ResultType.FEATURE_MUT_NT)) {
                String strLoc = coords.substring(0, coordLength - 3);
                String refSymbol = coords.substring(coordLength - 3, coordLength - 2);
                int location = Integer.parseInt(strLoc) - 1;
                genomePosList = FeatureDB.getMutationNT(name, location + 1, refSymbol, this.genome);
            } else {
                throw new IllegalArgumentException("Something went wrong parsing input token");
            }
            this.askUser |= genomePosList.size() >= 2;
            Iterator<Integer> iterator = genomePosList.keySet().iterator();
            if (iterator.hasNext()) {
                int genomePos = iterator.next();
                Feature feat2 = genomePosList.get(genomePos);
                int[] locs = SearchCommand.getStartEnd("" + (genomePos + 2));
                return new SearchResult(ResultType.LOCUS, feat2.getChr(), locs[0], locs[1]);
            }
        } else if (types.contains((Object)ResultType.FEATURE) && (feat = this.searchFeatureDBs(token)) != null) {
            return new SearchResult(feat);
        }
        return null;
    }

    private NamedFeature searchFeatureDBs(String str) {
        NamedFeature feat = FeatureDB.getFeature(str.toUpperCase().trim());
        if (feat != null) {
            return feat;
        }
        try {
            String tmp = "https://igv.org/genomes/locus.php?genome=$GENOME$&name=$FEATURE$";
            String genomeID = GenomeManager.getInstance().getGenomeId();
            if (genomeID != null) {
                URL url = new URL(tmp.replace("$GENOME$", genomeID).replace("$FEATURE$", str));
                String r = HttpUtils.getInstance().getContentsAsString(url);
                String[] t = Globals.whitespacePattern.split(r);
                if (t.length > 2) {
                    Locus l = Locus.fromString(t[1]);
                    String chr = this.genome == null ? l.getChr() : this.genome.getCanonicalChrName(l.getChr());
                    feat = new BasicFeature(chr, l.getStart(), l.getEnd());
                    return feat;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Search webservice error", (Throwable)e);
        }
        return null;
    }

    private SearchResult calcChromoLocus(String searchString) {
        boolean whitespace_delim;
        int[] startEnd = null;
        String[] tokens = searchString.split("\\s+");
        String chr = tokens[0];
        boolean bl = whitespace_delim = tokens.length >= 2;
        if (whitespace_delim) {
            Object posString = tokens[1];
            if (tokens.length >= 3) {
                posString = (String)posString + "-" + tokens[2];
            }
            startEnd = SearchCommand.getStartEnd((String)posString);
        } else {
            int colonIdx = searchString.lastIndexOf(":");
            if (colonIdx > 0) {
                chr = searchString.substring(0, colonIdx);
                String posString = searchString.substring(colonIdx).replace(":", "");
                startEnd = SearchCommand.getStartEnd(posString);
                if (startEnd == null) {
                    chr = searchString;
                }
            }
        }
        if (chr.equals("*") || chr.toLowerCase().equals("all")) {
            return new SearchResult(ResultType.CHROMOSOME, "All", 0, 1);
        }
        Chromosome chromosome = this.genome.getChromosome(chr = this.genome.getCanonicalChrName(chr));
        if (chromosome == null && (chromosome = this.genome.getChromosome(chr = this.genome.getCanonicalChrName(tokens[0]))) != null) {
            startEnd = null;
        }
        if (chromosome != null && !searchString.equals("All")) {
            if (startEnd != null) {
                if (startEnd[1] >= startEnd[0]) {
                    return new SearchResult(ResultType.LOCUS, chr, startEnd[0], startEnd[1]);
                }
                SearchResult error = new SearchResult(ResultType.ERROR, chr, startEnd[0], startEnd[1]);
                error.setMessage("End must be greater than start");
                return error;
            }
            return new SearchResult(ResultType.CHROMOSOME, chr, 0, chromosome.getLength() - 1);
        }
        return new SearchResult(ResultType.ERROR, chr, -1, -1);
    }

    private void showFlankedRegion(String chr, int start, int end) {
        int flankingRegion = PreferencesManager.getPreferences().getAsInt("FLANKING_REGION");
        int delta = end - start == 1 ? 20 : (flankingRegion < 0 ? -flankingRegion * (end - start) / 100 : flankingRegion);
        start = Math.max(0, start - delta);
        this.referenceFrame.jumpTo(chr, start, end += delta);
    }

    private static int[] getStartEnd(String posString) {
        try {
            String[] posTokens = posString.split("-");
            String startString = posTokens[0].replaceAll(",", "");
            int start = Math.max(0, Integer.parseInt(startString) - 1);
            int end = start + 1;
            if (posTokens.length > 1) {
                String endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            if (posTokens.length == 1 || end >= start && end - start < 10) {
                int center = (start + end) / 2;
                int widen = 20;
                start = center - widen;
                start = Math.max(0, start);
                end = center + widen;
            }
            return new int[]{Math.min(start, end), Math.max(start, end)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static List<SearchResult> getResults(List<NamedFeature> objects) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>(objects.size());
        for (NamedFeature f : objects) {
            results.add(new SearchResult(f));
        }
        return results;
    }

    private List<SearchResult> askUserFeature(List<SearchResult> results) {
        Object[] list = SearchCommand.getSelectionList(results, true);
        JList<Object> ls = new JList<Object>(list);
        ls.setSelectionMode(0);
        final JOptionPane pane = new JOptionPane(ls, -1, 2);
        final JDialog dialog = pane.createDialog("Features");
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        ls.addMouseListener(new IGVMouseInputAdapter(){

            @Override
            public void igvMouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    dialog.setVisible(false);
                    pane.setValue(0);
                    dialog.dispose();
                }
            }
        });
        dialog.setVisible(true);
        int resp = (Integer)pane.getValue();
        ArrayList<SearchResult> val = null;
        if (resp == 0) {
            int[] selected = ls.getSelectedIndices();
            val = new ArrayList<SearchResult>(selected.length);
            for (int ii = 0; ii < selected.length; ++ii) {
                val.add(ii, results.get(selected[ii]));
            }
        }
        return val;
    }

    static {
        String chromo_string;
        log = Logger.getLogger(SearchCommand.class);
        SEARCH_LIMIT = 10000;
        String num_withcommas = "(((\\d)+,?)+)";
        String chromo = chromo_string = "(\\S)+";
        String chromo_range = chromo_string + "(:|(\\s)+)" + num_withcommas + "(-|(\\s)+)?" + num_withcommas + "?(\\s)*";
        String feature = chromo_string;
        String featureMutAA = chromo_string + ":[A-Z,a-z,*]" + num_withcommas + "[A-Z,a-z,*]";
        String nts = "[A,C,G,T,a,c,g,t]";
        String featureMutNT = chromo_string + ":" + num_withcommas + nts + "\\>" + nts;
        tokenMatchers = new HashMap();
        tokenMatchers.put(ResultType.CHROMOSOME, chromo);
        tokenMatchers.put(ResultType.FEATURE, feature);
        tokenMatchers.put(ResultType.LOCUS, chromo_range);
        tokenMatchers.put(ResultType.FEATURE_MUT_AA, featureMutAA);
        tokenMatchers.put(ResultType.FEATURE_MUT_NT, featureMutNT);
    }

    public static class SearchResult {
        String chr;
        private int start;
        private int end;
        ResultType type;
        private String locus;
        private String message;
        private NamedFeature feature;

        public SearchResult() {
            this(ResultType.ERROR, null, -1, -1);
        }

        public SearchResult(ResultType type, String chr, int start, int end) {
            this.type = type;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.locus = Locus.getFormattedLocusString(chr, start, end);
        }

        public SearchResult(NamedFeature feature) {
            this(ResultType.FEATURE, feature.getChr(), feature.getStart(), feature.getEnd());
            this.feature = feature;
            this.locus = Locus.getFormattedLocusString(this.chr, this.start, this.end);
        }

        void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        String getLocus() {
            return this.locus;
        }

        String getShortName() {
            if (this.type == ResultType.FEATURE) {
                return this.feature.getName();
            }
            return this.locus;
        }

        String getLongName() {
            if (this.type == ResultType.FEATURE) {
                return this.feature.getName() + " (" + this.locus + ")";
            }
            return this.locus;
        }

        public ResultType getType() {
            return this.type;
        }

        public String getChr() {
            return this.chr;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public NamedFeature getFeature() {
            return this.feature;
        }
    }

    public static enum ResultType {
        FEATURE,
        FEATURE_MUT_AA,
        FEATURE_MUT_NT,
        LOCUS,
        CHROMOSOME,
        ERROR;

    }
}

