/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.variant.VariantTrack;

public class TrackGroup {
    private static Logger log = LogManager.getLogger(TrackGroup.class);
    private String name;
    private boolean drawBorder = true;
    private List<Track> tracks;
    private boolean selected;
    private boolean autoScale = false;

    public TrackGroup() {
        this("");
    }

    public TrackGroup(String name) {
        this.name = name;
        this.tracks = Collections.synchronizedList(new ArrayList());
    }

    public boolean contains(Track track) {
        return this.tracks.contains(track);
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public List<Track> getVisibleTracks() {
        ArrayList<Track> visibleTracks = new ArrayList<Track>();
        for (Track t : this.tracks) {
            if (!t.isVisible()) continue;
            visibleTracks.add(t);
        }
        return visibleTracks;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public int indexOf(Track track) {
        return this.tracks.indexOf(track);
    }

    public int size() {
        return this.tracks.size();
    }

    public void add(Track track) {
        if (track == null) {
            log.info("Attempt to add null track");
        } else {
            log.debug("Adding track " + track.getName());
            this.tracks.add(track);
        }
    }

    public void add(int pos, Track track) {
        if (track == null) {
            log.info("Attempt to add null track");
        } else {
            this.tracks.add(pos, track);
        }
    }

    public void addAll(Collection<Track> trackList) {
        this.tracks.addAll(trackList);
    }

    public void addAll(int index, Collection<Track> trackList) {
        this.tracks.addAll(index, trackList);
    }

    public void remove(Track track) {
        this.tracks.remove(track);
    }

    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        float score = -3.4028235E38f;
        for (Track track : this.tracks) {
            if (!track.isVisible()) continue;
            score = Math.max(score, track.getRegionScore(chr, start, end, zoom, type, frameName));
        }
        return score;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public boolean isVisible() {
        for (Track t : this.tracks) {
            if (t == null || !t.isVisible()) continue;
            return true;
        }
        return false;
    }

    public int getHeight() {
        int h = 0;
        for (Track track : this.tracks) {
            if (track == null || !track.isVisible()) continue;
            h += track.getHeight();
        }
        return h;
    }

    public void renderName(Graphics2D g2D, Rectangle rect) {
        int fontSize = PreferencesManager.getPreferences().getAsInt("DEFAULT_FONT_SIZE");
        Font font = FontManager.getFont(1, fontSize);
        g2D.setFont(font);
        GraphicUtils.drawWrappedText(this.getName(), rect, g2D, true);
    }

    public void sortByAttributes(String[] attributeNames, boolean[] ascending) {
        if (this.tracks != null && !this.tracks.isEmpty()) {
            ArrayList<Track> allTracks = new ArrayList<Track>(this.tracks);
            try {
                Track t2;
                TrackAttributeComparator comparator = new TrackAttributeComparator(attributeNames, ascending);
                ArrayList<Track> nonsortableTracks = new ArrayList<Track>();
                HashMap<Track, Integer> trackIndices = new HashMap<Track, Integer>();
                for (int i = this.tracks.size() - 1; i >= 0; --i) {
                    if (this.tracks.get(i).isSortable()) continue;
                    t2 = this.tracks.remove(i);
                    nonsortableTracks.add(t2);
                    trackIndices.put(t2, i);
                }
                Collections.sort(this.tracks, comparator);
                for (Track t2 : allTracks) {
                    if (!(t2 instanceof VariantTrack)) continue;
                    ((VariantTrack)t2).sortSamples(new SampleAttributeComparator(attributeNames, ascending));
                }
                if (nonsortableTracks.size() > 0) {
                    for (int i = nonsortableTracks.size() - 1; i >= 0; --i) {
                        t2 = (Track)nonsortableTracks.get(i);
                        int index = (Integer)trackIndices.get(t2);
                        this.tracks.add(index, t2);
                    }
                }
            }
            catch (Exception e) {
                log.error("Error sorting tracks by attribute", e);
                this.tracks = allTracks;
            }
        }
    }

    public void sortGroup(RegionScoreType type, List<String> sortedSamples) {
        ArrayList<Track> unsortableTracks = new ArrayList<Track>();
        HashMap<Track, Integer> trackIndeces = new HashMap<Track, Integer>();
        for (int i = this.tracks.size() - 1; i >= 0; --i) {
            if (this.tracks.get(i).isSortable()) continue;
            Track t = this.tracks.remove(i);
            unsortableTracks.add(t);
            trackIndeces.put(t, i);
        }
        ArrayList<Track> tracksWithScore = new ArrayList<Track>(this.getVisibleTracks().size());
        ArrayList<Track> otherTracks = new ArrayList<Track>(this.getVisibleTracks().size());
        for (Track t : this.getVisibleTracks()) {
            if (t.isRegionScoreType(type)) {
                tracksWithScore.add(t);
                continue;
            }
            otherTracks.add(t);
        }
        this.sortBySampleOrder(tracksWithScore, sortedSamples);
        this.sortBySampleOrder(otherTracks, sortedSamples);
        this.tracks.clear();
        this.tracks.addAll(tracksWithScore);
        this.tracks.addAll(otherTracks);
        if (unsortableTracks.size() > 0) {
            for (int i = unsortableTracks.size() - 1; i >= 0; --i) {
                Track t;
                t = (Track)unsortableTracks.get(i);
                int index = (Integer)trackIndeces.get(t);
                this.tracks.add(index, t);
            }
        }
    }

    private void sortBySampleOrder(List<Track> tracks, List<String> sortedSamples) {
        if (tracks != null && sortedSamples != null && !tracks.isEmpty()) {
            final HashMap<String, Integer> rankMap = new HashMap<String, Integer>(sortedSamples.size() * 2);
            for (int i = sortedSamples.size() - 1; i >= 0; --i) {
                rankMap.put(sortedSamples.get(i), i);
            }
            Comparator<Track> c = new Comparator<Track>(){

                @Override
                public int compare(Track t1, Track t2) {
                    Integer r2;
                    String a1 = t1.getSample();
                    String a2 = t2.getSample();
                    Integer r1 = a1 == null ? null : (Integer)rankMap.get(a1);
                    Integer n = r2 = a2 == null ? null : (Integer)rankMap.get(a2);
                    if (r1 == null && r2 == null) {
                        return 0;
                    }
                    if (r1 == null) {
                        return 1;
                    }
                    if (r2 == null) {
                        return -1;
                    }
                    return r1 - r2;
                }
            };
            Collections.sort(tracks, c);
        }
    }

    public void sortByList(List<String> trackIds) {
        final HashMap<String, Integer> trackPositions = new HashMap<String, Integer>();
        for (int i = 0; i < trackIds.size(); ++i) {
            trackPositions.put(trackIds.get(i), i);
        }
        Comparator<Track> c = new Comparator<Track>(){

            @Override
            public int compare(Track t1, Track t2) {
                String id1 = t1.getId();
                int p1 = trackPositions.containsKey(id1) ? (Integer)trackPositions.get(id1) : Integer.MAX_VALUE;
                String id2 = t2.getId();
                int p2 = trackPositions.containsKey(id2) ? (Integer)trackPositions.get(id2) : Integer.MAX_VALUE;
                return p1 - p2;
            }
        };
        Collections.sort(this.tracks, c);
    }

    public void removeTracks(Collection<? extends Track> tracksToRemove) {
        this.tracks.removeAll(tracksToRemove);
    }

    public boolean moveSelectedTracksTo(Collection<? extends Track> selectedTracks, Track targetTrack, boolean before) {
        int index;
        int n = index = targetTrack == null ? this.tracks.size() : this.tracks.indexOf(targetTrack);
        if (index < 0) {
            return false;
        }
        if (!before) {
            ++index;
        }
        ArrayList<Track> beforeList = new ArrayList<Track>(this.tracks.subList(0, index));
        ArrayList<Track> afterList = new ArrayList<Track>(this.tracks.subList(index, this.tracks.size()));
        beforeList.removeAll(selectedTracks);
        afterList.removeAll(selectedTracks);
        this.tracks.clear();
        this.tracks.addAll(beforeList);
        this.tracks.addAll(selectedTracks);
        this.tracks.addAll(afterList);
        return true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        IGV igv = IGV.getInstance();
        igv.clearSelections();
        igv.setTrackSelections(new HashSet<Track>(this.tracks));
    }

    private static class SampleAttributeComparator
    extends AttributeComparator<String> {
        public SampleAttributeComparator(String[] attributeNames, boolean[] ascending) {
            super(attributeNames, ascending);
        }

        @Override
        protected String getAttributeValue(String sample, String attName) {
            String value = AttributeManager.getInstance().getAttribute(sample, attName);
            if (value == null) {
                value = "";
            }
            return value.toLowerCase();
        }
    }

    private static class TrackAttributeComparator
    extends AttributeComparator<Track> {
        public TrackAttributeComparator(String[] attributeNames, boolean[] ascending) {
            super(attributeNames, ascending);
        }

        @Override
        protected String getAttributeValue(Track track, String attName) {
            String value = track.getAttributeValue(attName);
            if (value == null) {
                value = "";
            }
            return value.toLowerCase();
        }
    }

    private static abstract class AttributeComparator<T>
    implements Comparator<T> {
        private final String[] attributeNames;
        private final boolean[] ascending;

        AttributeComparator(String[] attributeNames, boolean[] ascending) {
            assert (attributeNames.length == ascending.length);
            this.attributeNames = attributeNames;
            this.ascending = ascending;
        }

        protected abstract String getAttributeValue(T var1, String var2);

        @Override
        public int compare(T t1, T t2) {
            for (int i = 0; i < this.attributeNames.length; ++i) {
                String attName = this.attributeNames[i];
                if (attName == null) continue;
                String value1 = this.getAttributeValue(t1, attName);
                String value2 = this.getAttributeValue(t2, attName);
                boolean isNumeric = AttributeManager.getInstance().isNumeric(attName);
                int c = 0;
                if (isNumeric) {
                    double d2;
                    double d1;
                    try {
                        d1 = Double.parseDouble(value1);
                    }
                    catch (NumberFormatException e) {
                        d1 = Double.MIN_VALUE;
                    }
                    try {
                        d2 = Double.parseDouble(value2);
                    }
                    catch (NumberFormatException e) {
                        d2 = Double.MIN_VALUE;
                    }
                    c = Double.compare(d1, d2);
                } else {
                    c = value1.compareTo(value2);
                }
                if (c == 0) continue;
                return this.ascending[i] ? c : -c;
            }
            return 0;
        }
    }
}

